/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.tileentity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.dynamictransport.entities.EntityMasterElevator;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevator;
import net.slimevoid.dynamictransport.tileentity.TileEntityFloorMarker;
import net.slimevoid.dynamictransport.tileentity.TileEntityTransportBase;
import net.slimevoid.library.blocks.BlockBase;
import net.slimevoid.library.util.helpers.BlockHelper;
import net.slimevoid.library.util.helpers.ChatHelper;

public class TileEntityElevatorComputer
extends TileEntityTransportBase {
    private String elevatorName;
    private List<ChunkCoordinates> boundMarkerBlocks = new ArrayList<ChunkCoordinates>();
    private List<ChunkCoordinates> boundElevatorBlocks = new ArrayList<ChunkCoordinates>();
    private LinkedHashMap<Integer, String> floorSpool = new LinkedHashMap();
    private ElevatorMode mode = ElevatorMode.Available;
    private String curTechnicianName;
    private int elevatorPos;
    public boolean pendingMaintenance = false;
    private float elevatorSpeed = ConfigurationLib.elevatorMaxSpeed;
    private boolean isHaltAble = false;

    /*
     * Enabled aggressive block sorting
     */
    public boolean addElevator(ChunkCoordinates elevator, EntityPlayer entityplayer) {
        if (this.mode == ElevatorMode.Maintenance && this.curTechnicianName != null && this.curTechnicianName.equals(entityplayer.func_146103_bH().getName())) {
            if (!this.boundElevatorBlocks.contains(new ChunkCoordinates(elevator.field_71574_a, elevator.field_71572_b - (this.field_145848_d + 1), elevator.field_71573_c))) {
                if (this.isInRange(elevator, true)) {
                    if (this.field_145850_b.func_147439_a(elevator.field_71574_a, elevator.field_71572_b, elevator.field_71573_c) == ConfigurationLib.blockTransportBase && this.field_145850_b.func_72805_g(elevator.field_71574_a, elevator.field_71572_b, elevator.field_71573_c) == 0) {
                        this.boundElevatorBlocks.add(new ChunkCoordinates(elevator.field_71574_a, elevator.field_71572_b - (this.field_145848_d + 1), elevator.field_71573_c));
                        if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindElevatorSuccessWithName", (Object[])new Object[]{this.elevatorName});
                        } else {
                            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindElevatorSuccess", (Object[])new Object[0]);
                        }
                        this.updateBlock();
                        return true;
                    }
                    if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                        ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindInvalidElevatorWithName", (Object[])new Object[]{this.elevatorName});
                        return false;
                    }
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindInvalidElevator", (Object[])new Object[0]);
                    return false;
                }
                if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindElevatorOutOfRangeWithName", (Object[])new Object[]{this.elevatorName, ConfigurationLib.MaxBindingRange});
                    return false;
                }
                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindElevatorOutOfRange", (Object[])new Object[]{ConfigurationLib.MaxBindingRange});
                return false;
            }
            if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindElevatorAlreadyBoundWithName", (Object[])new Object[]{this.elevatorName});
            } else {
                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindElevatorAlreadyBound", (Object[])new Object[0]);
            }
            this.updateBlock();
            return true;
        }
        if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindNoLongerTechWithName", (Object[])new Object[]{this.elevatorName});
        } else {
            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.bindNoLongerTech", (Object[])new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
        }
        ItemStack heldItem = entityplayer.func_70694_bm();
        NBTTagCompound tags = new NBTTagCompound();
        heldItem.func_77982_d(tags);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addFloorMarker(ChunkCoordinates markerBlock, EntityPlayer entityplayer) {
        if (this.mode == ElevatorMode.Maintenance && this.curTechnicianName != null && this.curTechnicianName.equals(entityplayer.func_146103_bH().getName())) {
            if (!this.boundMarkerBlocks.contains(markerBlock)) {
                if (this.boundElevatorBlocks.size() != 0) {
                    if (this.isInRange(markerBlock, false)) {
                        if (this.field_145850_b.func_147439_a(markerBlock.field_71574_a, markerBlock.field_71572_b, markerBlock.field_71573_c) == ConfigurationLib.blockTransportBase && this.field_145850_b.func_72805_g(markerBlock.field_71574_a, markerBlock.field_71572_b, markerBlock.field_71573_c) == 2) {
                            this.boundMarkerBlocks.add(markerBlock);
                            if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("Block Successfully Bound to Elevator: %0$s.", this.elevatorName), (Object[])new Object[0]);
                            } else {
                                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"Block Successfully Bound to Elevator", (Object[])new Object[0]);
                            }
                            this.updateBlock();
                            return true;
                        }
                        if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("Block Can Not be Bound to Elevator: %0$s. Block Does Not Seem To Be a Floor Marker", this.elevatorName), (Object[])new Object[0]);
                            return false;
                        }
                        ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"Block Can Not be Bound to Elevator. Block Does Not Seem To Be a Floor Marker", (Object[])new Object[0]);
                        return false;
                    }
                    if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                        ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("Block Can Not be Bound to Elevator: %0$s. Block Must be set Withing %1$s Meters of an Elevator Block", this.elevatorName, ConfigurationLib.MaxBindingRange), (Object[])new Object[0]);
                        return false;
                    }
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("Block Can Not be Bound to Elevator. Block Must be set Withing %0$s Meters of an Elevator Block", ConfigurationLib.MaxBindingRange), (Object[])new Object[0]);
                    return false;
                }
                if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"Block Can Not be Bound to Elevator: %0$s. Must Bind at Least One Elevator Block", (Object[])new Object[0]);
                    return false;
                }
                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"Block Can Not be Bound to Elevator. Must Bind at Least One Elevator Block", (Object[])new Object[0]);
                return false;
            }
            if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("Block Already Bound to Elevator: %0$s", this.elevatorName), (Object[])new Object[0]);
            } else {
                ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"Block Already Bound to Elevator", (Object[])new Object[0]);
            }
            this.updateBlock();
            return true;
        }
        if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("You are no longer the Technician for the Elevator %0$s", this.elevatorName), (Object[])new Object[0]);
            return false;
        }
        ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)String.format("You are no longer the Technician for the Elevator at %0$s, %1$s ,%2$s", this.field_145851_c, this.field_145848_d, this.field_145849_e), (Object[])new Object[0]);
        return false;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityplayer) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        ItemStack heldItem = entityplayer.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == ConfigurationLib.itemElevatorTool && entityplayer.func_70093_af()) {
            NBTTagCompound tags = new NBTTagCompound();
            if (this.curTechnicianName != null && this.curTechnicianName.equals(entityplayer.func_146103_bH().getName())) {
                this.curTechnicianName = "";
                this.mode = ElevatorMode.Available;
                if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.mantCompleteWithName", (Object[])new Object[]{this.elevatorName});
                } else {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.mantComplete", (Object[])new Object[0]);
                }
            } else if (this.curTechnicianName == null || this.curTechnicianName.isEmpty()) {
                tags.func_74768_a("ComputerX", this.field_145851_c);
                tags.func_74768_a("ComputerY", this.field_145848_d);
                tags.func_74768_a("ComputerZ", this.field_145849_e);
                this.curTechnicianName = entityplayer.func_146103_bH().getName();
                if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.enterMantWithName", (Object[])new Object[]{this.elevatorName});
                } else {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorcomputer.enterMant", (Object[])new Object[0]);
                }
                if (this.boundElevatorBlocks.size() == 0) {
                    this.floorSpool.clear();
                    this.elevatorPos = this.field_145848_d + 1;
                    this.mode = ElevatorMode.Maintenance;
                } else if (this.elevatorPos > this.field_145848_d + 1) {
                    this.callElevator(this.field_145848_d + 1, true, "");
                } else {
                    this.floorSpool.clear();
                    this.mode = ElevatorMode.Maintenance;
                }
            }
            heldItem.func_77982_d(tags);
            this.updateBlock();
        }
        return false;
    }

    public boolean removeBlockByPlayer(EntityPlayer player, BlockBase blockBase) {
        for (ChunkCoordinates boundElevator : this.boundElevatorBlocks) {
            TileEntityElevator eleTile = (TileEntityElevator)((Object)BlockHelper.getTileEntity((IBlockAccess)this.func_145831_w(), (int)boundElevator.field_71574_a, (int)(this.elevatorPos + boundElevator.field_71572_b), (int)boundElevator.field_71573_c, TileEntityElevator.class));
            if (eleTile == null) continue;
            eleTile.RemoveComputer(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        for (ChunkCoordinates boundFloorMarker : this.boundMarkerBlocks) {
            TileEntityFloorMarker markerTile = (TileEntityFloorMarker)((Object)BlockHelper.getTileEntity((IBlockAccess)this.func_145831_w(), (int)boundFloorMarker.field_71574_a, (int)boundFloorMarker.field_71572_b, (int)boundFloorMarker.field_71573_c, TileEntityFloorMarker.class));
            if (markerTile == null) continue;
            markerTile.removeParent();
        }
        return super.removeBlockByPlayer(player, blockBase);
    }

    public String callElevator(int i, String Floorname) {
        return this.callElevator(i, false, Floorname);
    }

    private String callElevator(int i, boolean forMaintenance, String floorname) {
        if (this.mode == ElevatorMode.Available) {
            if (forMaintenance) {
                this.floorSpool.clear();
                this.pendingMaintenance = true;
                if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
                    this.sendMessageFromAllFloors("slimevoid.DT.elevatorcomputer.enterMantWithName", this.elevatorName);
                } else {
                    this.sendMessageFromAllFloors("slimevoid.DT.elevatorcomputer.enterMant", new Object[0]);
                }
            } else if (i != this.elevatorPos) {
                this.floorSpool.put(i, floorname);
            } else {
                return "Elevator Already At Floor " + (floorname == null || floorname.trim().isEmpty() ? Integer.valueOf(i) : floorname);
            }
            this.doCallElevator(i, floorname);
            return "Elevator Called to Floor " + (floorname == null || floorname.trim().isEmpty() ? Integer.valueOf(i) : floorname);
        }
        if (this.mode == ElevatorMode.Maintenance) {
            if (forMaintenance) {
                this.sendMessageFromAllFloors("slimevoid.DT.elevatorcomputer.alreadyMant", new Object[0]);
            }
            return "Elevator in Maintenance Mode please Try Again Later";
        }
        if (this.mode == ElevatorMode.TransitUp || this.mode == ElevatorMode.TransitDown) {
            if (forMaintenance) {
                this.pendingMaintenance = true;
                this.sendMessageFromAllFloors("slimevoid.DT.elevatorcomputer.mantQueued", new Object[0]);
                return "Maintenance Mode Request Queued";
            }
            this.floorSpool.put(i, floorname);
            return "Elevator Called to Floor " + (floorname == null || floorname.trim().isEmpty() ? Integer.valueOf(i) : floorname);
        }
        return "WTF you should never see me";
    }

    private void sendMessageFromAllFloors(String message, Object ... args) {
        for (ChunkCoordinates marker : this.boundMarkerBlocks) {
            ChatHelper.sendChatMessageToAllNear((World)this.func_145831_w(), (int)marker.field_71574_a, (int)marker.field_71572_b, (int)marker.field_71573_c, (int)4, (String)message, (Object[])args);
        }
        if (!this.field_145850_b.field_72995_K) {
            ChatHelper.sendChatMessageToAllNear((World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)4, (String)message, (Object[])args);
        }
    }

    private void doCallElevator(int i, String floorname) {
        this.mode = i > this.elevatorPos ? ElevatorMode.TransitUp : ElevatorMode.TransitDown;
        EntityMasterElevator curElevator = new EntityMasterElevator(this.field_145850_b, this.field_145851_c, this.elevatorPos, this.field_145849_e);
        this.field_145850_b.func_72838_d((Entity)curElevator);
        curElevator.setProperties(i, floorname, this.elevatorSpeed, new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.isHaltAble, this.boundElevatorBlocks);
    }

    private boolean validElevatorBlock(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityElevator && ((TileEntityElevator)tile).getParentElevatorComputer() != null) {
            ChunkCoordinates thisCoords = new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return ((TileEntityElevator)tile).getParent().equals((Object)thisCoords);
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        int[] BoundMarkerBlocksX = new int[this.boundMarkerBlocks.size()];
        int[] BoundMarkerBlocksY = new int[this.boundMarkerBlocks.size()];
        int[] BoundMarkerBlocksZ = new int[this.boundMarkerBlocks.size()];
        for (int i = 0; i < this.boundMarkerBlocks.size(); ++i) {
            BoundMarkerBlocksX[i] = this.boundMarkerBlocks.get((int)i).field_71574_a;
            BoundMarkerBlocksY[i] = this.boundMarkerBlocks.get((int)i).field_71572_b;
            BoundMarkerBlocksZ[i] = this.boundMarkerBlocks.get((int)i).field_71573_c;
        }
        int[] BoundElevatorBlocksX = new int[this.boundElevatorBlocks.size()];
        int[] BoundElevatorBlocksY = new int[this.boundElevatorBlocks.size()];
        int[] BoundElevatorBlocksZ = new int[this.boundElevatorBlocks.size()];
        for (int i = 0; i < this.boundElevatorBlocks.size(); ++i) {
            BoundElevatorBlocksX[i] = this.boundElevatorBlocks.get((int)i).field_71574_a;
            BoundElevatorBlocksY[i] = this.boundElevatorBlocks.get((int)i).field_71572_b;
            BoundElevatorBlocksZ[i] = this.boundElevatorBlocks.get((int)i).field_71573_c;
        }
        if (this.elevatorName != null && !this.elevatorName.isEmpty()) {
            nbttagcompound.func_74778_a("ElevatorName", this.elevatorName);
        }
        nbttagcompound.func_74783_a("BoundMarkerBlocksX", BoundMarkerBlocksX);
        nbttagcompound.func_74783_a("BoundMarkerBlocksY", BoundMarkerBlocksY);
        nbttagcompound.func_74783_a("BoundMarkerBlocksZ", BoundMarkerBlocksZ);
        nbttagcompound.func_74783_a("BoundElevatorBlocksX", BoundElevatorBlocksX);
        nbttagcompound.func_74783_a("BoundElevatorBlocksY", BoundElevatorBlocksY);
        nbttagcompound.func_74783_a("BoundElevatorBlocksZ", BoundElevatorBlocksZ);
        int index = 0;
        int[] tempSpool = new int[this.floorSpool.size()];
        for (Map.Entry<Integer, String> floorName : this.floorSpool.entrySet()) {
            if (floorName.getValue() != null && !floorName.getValue().isEmpty()) {
                nbttagcompound.func_74778_a("FloorSpoolNames_" + index, floorName.getValue());
            }
            tempSpool[index] = floorName.getKey();
        }
        nbttagcompound.func_74783_a("FloorSpool", tempSpool);
        nbttagcompound.func_74768_a("Mode", this.mode.ordinal());
        nbttagcompound.func_74768_a("ElevPos", this.elevatorPos);
        if (this.curTechnicianName != null && !this.curTechnicianName.isEmpty()) {
            nbttagcompound.func_74778_a("CurTechnicianName", this.curTechnicianName);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        int i;
        super.func_145839_a(nbttagcompound);
        int[] BoundMarkerBlocksX = nbttagcompound.func_74759_k("BoundMarkerBlocksX");
        int[] BoundMarkerBlocksY = nbttagcompound.func_74759_k("BoundMarkerBlocksY");
        int[] BoundMarkerBlocksZ = nbttagcompound.func_74759_k("BoundMarkerBlocksZ");
        int[] BoundElevatorBlocksX = nbttagcompound.func_74759_k("BoundElevatorBlocksX");
        int[] BoundElevatorBlocksY = nbttagcompound.func_74759_k("BoundElevatorBlocksY");
        int[] BoundElevatorBlocksZ = nbttagcompound.func_74759_k("BoundElevatorBlocksZ");
        int[] tempSpool = nbttagcompound.func_74759_k("FloorSpool");
        this.boundMarkerBlocks.clear();
        this.boundElevatorBlocks.clear();
        this.floorSpool.clear();
        for (i = 0; i < BoundMarkerBlocksX.length; ++i) {
            this.boundMarkerBlocks.add(new ChunkCoordinates(BoundMarkerBlocksX[i], BoundMarkerBlocksY[i], BoundMarkerBlocksZ[i]));
        }
        for (i = 0; i < BoundElevatorBlocksY.length; ++i) {
            this.boundElevatorBlocks.add(new ChunkCoordinates(BoundElevatorBlocksX[i], BoundElevatorBlocksY[i], BoundElevatorBlocksZ[i]));
        }
        for (i = 0; i < tempSpool.length; ++i) {
            this.floorSpool.put(tempSpool[i], nbttagcompound.func_74779_i("FloorSpoolNames_" + i));
        }
        this.mode = ElevatorMode.values()[nbttagcompound.func_74762_e("Mode")];
        this.elevatorPos = nbttagcompound.func_74762_e("ElevPos");
        this.curTechnicianName = nbttagcompound.func_74779_i("CurTechnicianName");
        this.elevatorName = nbttagcompound.func_74779_i("ElevatorName");
    }

    public String getElevatorName() {
        return this.elevatorName;
    }

    public void RemoveElevatorBlock(ChunkCoordinates elevatorPosition) {
        if (this.boundElevatorBlocks.contains(elevatorPosition)) {
            this.boundElevatorBlocks.remove(this.boundElevatorBlocks.indexOf(elevatorPosition));
            ListIterator<ChunkCoordinates> itr = this.boundMarkerBlocks.listIterator();
            while (itr.hasNext()) {
                ChunkCoordinates boundMarker = itr.next();
                boolean valid = false;
                for (ChunkCoordinates boundElevators : this.boundElevatorBlocks) {
                    if (!(MathHelper.func_76133_a((double)(Math.pow((double)boundElevators.field_71574_a - (double)boundMarker.field_71574_a, 2.0) + Math.pow((double)boundElevators.field_71573_c - (double)boundMarker.field_71573_c, 2.0))) <= (float)ConfigurationLib.MaxBindingRange) || this.field_145850_b.func_147439_a(boundMarker.field_71574_a, boundMarker.field_71572_b, boundMarker.field_71573_c) != ConfigurationLib.blockTransportBase || this.field_145850_b.func_72805_g(boundMarker.field_71574_a, boundMarker.field_71572_b, boundMarker.field_71573_c) != 2) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                TileEntityFloorMarker tile = (TileEntityFloorMarker)((Object)BlockHelper.getTileEntity((IBlockAccess)this.field_145850_b, (int)boundMarker.field_71574_a, (int)boundMarker.field_71572_b, (int)boundMarker.field_71573_c, TileEntityFloorMarker.class));
                if (tile != null) {
                    tile.removeParent();
                }
                itr.remove();
            }
            this.updateBlock();
        }
    }

    public void elevatorArrived(int destination) {
        this.elevatorPos = destination;
        this.floorSpool.remove(destination);
        if (this.pendingMaintenance) {
            if (this.elevatorPos == this.field_145848_d + 1) {
                this.pendingMaintenance = false;
                this.mode = ElevatorMode.Maintenance;
            } else {
                this.floorSpool.clear();
                this.doCallElevator(this.field_145848_d + 1, "");
            }
        } else {
            this.mode = ElevatorMode.Available;
            if (!this.floorSpool.isEmpty()) {
                Integer nextFloor = this.floorSpool.keySet().iterator().next();
                this.doCallElevator(nextFloor, this.floorSpool.get(nextFloor));
            }
        }
    }

    public int getElevatorPos() {
        return this.elevatorPos;
    }

    public ElevatorMode getElevatorMode() {
        return this.mode;
    }

    public int getExtendedBlockID() {
        return 1;
    }

    public boolean isInRange(ChunkCoordinates bindingBlock, boolean shouldCheckComputer) {
        if (this.boundElevatorBlocks != null && this.boundElevatorBlocks.size() > 0) {
            for (ChunkCoordinates boundBlock : this.boundElevatorBlocks) {
                if (!(MathHelper.func_76133_a((double)(Math.pow((double)boundBlock.field_71574_a - (double)bindingBlock.field_71574_a, 2.0) + Math.pow((double)boundBlock.field_71573_c - (double)bindingBlock.field_71573_c, 2.0))) <= (float)ConfigurationLib.MaxBindingRange)) continue;
                return true;
            }
        }
        return shouldCheckComputer && MathHelper.func_76133_a((double)(Math.pow((double)this.field_145851_c - (double)bindingBlock.field_71574_a, 2.0) + Math.pow((double)this.field_145849_e - (double)bindingBlock.field_71573_c, 2.0))) <= (float)ConfigurationLib.MaxBindingRange;
    }

    public SortedMap<Integer, ArrayList<String>> getFloorList() {
        TreeMap<Integer, ArrayList<String>> floors = new TreeMap<Integer, ArrayList<String>>();
        if (this.boundMarkerBlocks != null && this.boundMarkerBlocks.size() > 0) {
            for (ChunkCoordinates boundBlock : this.boundMarkerBlocks) {
                TileEntity tile = this.field_145850_b.func_147438_o(boundBlock.field_71574_a, boundBlock.field_71572_b, boundBlock.field_71573_c);
                if (tile == null || !(tile instanceof TileEntityFloorMarker)) continue;
                int floorY = ((TileEntityFloorMarker)tile).getFloorY();
                String floorName = ((TileEntityFloorMarker)tile).getFloorName();
                if (!floors.containsKey(floorY)) {
                    floors.put(floorY, new ArrayList());
                }
                if (floorName == null || floorName.trim().equals("")) continue;
                ((ArrayList)floors.get(floorY)).add(floorName);
            }
        }
        return floors;
    }

    public void removeMarkerBlock(ChunkCoordinates elevatorPosition) {
        if (this.boundMarkerBlocks.contains(elevatorPosition)) {
            this.boundMarkerBlocks.remove(this.boundMarkerBlocks.indexOf(elevatorPosition));
            this.updateBlock();
        }
    }

    @Override
    protected boolean isInMaintenanceMode() {
        return this.getElevatorMode() == ElevatorMode.Maintenance;
    }

    public String getInvName() {
        return "dt.transport.computer";
    }

    public static enum ElevatorMode {
        Maintenance,
        TransitUp,
        TransitDown,
        Available;

    }
}

