/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.entities;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevator;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevatorComputer;
import net.slimevoid.library.util.helpers.BlockHelper;
import net.slimevoid.library.util.helpers.ChatHelper;

public class EntityElevatorOld
extends Entity {
    protected static final float elevatorAccel = 0.01f;
    protected static final float minElevatorMovingSpeed = 0.016f;
    protected ChunkCoordinates computerPos = null;
    protected String elevatorName = "";
    protected String destFloorName = "";
    protected boolean canBeHalted = true;
    protected Set<Integer> conjoinedelevators = new HashSet<Integer>();
    protected Set<Integer> confirmedRiders = new HashSet<Integer>();
    protected int startStops = 0;
    protected int notifierElevatorID = 0;
    protected boolean emerHalt = false;
    protected boolean isNotifierElevator = false;
    protected byte stillCount = 0;
    protected boolean slowingDown = false;

    public EntityElevatorOld(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.field_70144_Y = 1.0f;
        this.field_70158_ak = true;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public EntityElevatorOld(World world, double i, double j, double k) {
        this(world);
        this.field_70169_q = i + 0.5;
        this.field_70167_r = j + 0.5;
        this.field_70166_s = k + 0.5;
        this.func_70107_b(this.field_70169_q, this.field_70167_r, this.field_70166_s);
        this.isNotifierElevator = false;
        this.setWaitToAccelerate((byte)0);
        this.updatePotentialRiders();
    }

    public int getDestinationY() {
        return this.func_70096_w().func_75679_c(2);
    }

    public int getElevatorYOffset() {
        return this.func_70096_w().func_75679_c(5);
    }

    public int getTargetY() {
        return this.func_70096_w().func_75679_c(2) + this.func_70096_w().func_75679_c(5);
    }

    public float getMaximumSpeed() {
        return this.func_70096_w().func_111145_d(3);
    }

    public ItemStack getCamoItem() {
        return this.func_70096_w().func_82710_f(4);
    }

    public Short getOverlay() {
        return this.func_70096_w().func_75693_b(7);
    }

    protected void setDestinationY(int destinationY) {
        this.func_70096_w().func_75692_b(2, (Object)destinationY);
    }

    protected void setYOffset(int yOffset) {
        this.func_70096_w().func_75692_b(5, (Object)yOffset);
    }

    protected void setMaximumSpeed(float speed) {
        this.func_70096_w().func_75692_b(3, (Object)Float.valueOf(speed));
    }

    protected void setCamoItem(ItemStack itemstack) {
        this.func_70096_w().func_75692_b(4, (Object)itemstack);
    }

    public void setOverlay(Short overlay) {
        this.func_70096_w().func_75692_b(7, (Object)overlay);
    }

    public void setWaitToAccelerate(byte value) {
        this.func_70096_w().func_75692_b(6, (Object)value);
    }

    public byte getWaitToAccelerate() {
        return this.func_70096_w().func_75683_a(6);
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(2, (Object)-1);
        this.func_70096_w().func_75682_a(3, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_82709_a(4, 5);
        this.func_70096_w().func_75682_a(5, (Object)-1);
        this.func_70096_w().func_75682_a(6, (Object)0);
        this.func_70096_w().func_75682_a(7, (Object)0);
    }

    public void func_70106_y() {
        boolean blockPlaced;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        if (Math.abs(y - this.getTargetY()) < 1) {
            y = this.getTargetY();
        }
        boolean bl = blockPlaced = !this.field_70170_p.field_72995_K && (this.field_70170_p.func_147439_a(x, y, z) == ConfigurationLib.blockTransportBase || this.field_70170_p.func_147472_a((Block)ConfigurationLib.blockTransportBase, x, y, z, true, 1, null, null) && this.field_70170_p.func_147465_d(x, y, z, (Block)ConfigurationLib.blockTransportBase, 0, 3));
        if (!this.field_70170_p.field_72995_K) {
            if (blockPlaced) {
                TileEntityElevator tile = (TileEntityElevator)this.field_70170_p.func_147438_o(x, y, z);
                if (tile != null) {
                    tile.setParentElevatorComputer(this.computerPos);
                    if (this.getCamoItem() != null) {
                        tile.setCamoItem(this.getCamoItem());
                    }
                    tile.setYOffset(this.getElevatorYOffset());
                    tile.setOverlay(this.getOverlay());
                }
            } else {
                this.func_70099_a(new ItemStack((Block)ConfigurationLib.blockTransportBase, 1, 0), 0.0f);
            }
        }
        this.updateRiders(true);
        if (!this.field_70170_p.field_72995_K && this.isNotifierElevator) {
            if (this.elevatorName != null && !this.elevatorName.trim().equals("")) {
                ChatHelper.sendChatMessageToAllNear((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)4, (String)"slimevoid.DT.entityElevator.arriveWithName", (Object[])new Object[]{this.elevatorName, this.destFloorName});
            } else {
                ChatHelper.sendChatMessageToAllNear((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)4, (String)"slimevoid.DT.entityElevator.arrive", (Object[])new Object[]{this.destFloorName});
            }
        }
        super.func_70106_y();
    }

    public void func_70071_h_() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.removeElevatorBlock(x, y, z);
        }
        if (this.getDestinationY() == -1) {
            return;
        }
        if (this.field_70173_aa % 10 == 0) {
            this.setTransitBlocks(x, y, z);
        }
        this.moveElevator();
        this.func_70043_V();
        if (!this.emerHalt) {
            if (MathHelper.func_76135_e((float)((float)this.field_70181_x)) < 0.016f) {
                byte by = this.stillCount;
                this.stillCount = (byte)(by + 1);
                if (by > 10) {
                    this.killAllConjoined();
                }
            } else {
                this.stillCount = 0;
            }
        }
    }

    protected void moveElevator() {
        boolean atDestination;
        if (this.field_70133_I) {
            this.field_70133_I = false;
            this.setEmerHalt(!this.emerHalt);
            ++this.startStops;
            if (this.startStops > 2) {
                this.func_70106_y();
            }
        }
        float destY = (float)this.getTargetY() + 0.5f;
        float elevatorSpeed = (float)Math.abs(this.field_70181_x);
        if (this.emerHalt) {
            elevatorSpeed = 0.0f;
        } else if (this.getWaitToAccelerate() < 15) {
            elevatorSpeed = this.getWaitToAccelerate() < 10 ? 0.0f : 0.016f;
            this.setWaitToAccelerate((byte)(this.getWaitToAccelerate() + 1));
        } else {
            float tempSpeed = elevatorSpeed + 0.01f;
            float maxElevatorSpeed = this.getMaximumSpeed();
            if (tempSpeed > maxElevatorSpeed) {
                tempSpeed = maxElevatorSpeed;
            }
            if (!this.slowingDown && MathHelper.func_76135_e((float)((float)((double)destY - this.field_70163_u))) >= (tempSpeed * tempSpeed - 2.5600003E-4f) / 0.02f) {
                elevatorSpeed = tempSpeed;
            } else {
                elevatorSpeed -= 0.01f;
                this.slowingDown = true;
            }
            if (elevatorSpeed > maxElevatorSpeed) {
                elevatorSpeed = maxElevatorSpeed;
            }
            if (elevatorSpeed < 0.016f) {
                elevatorSpeed = 0.016f;
            }
        }
        boolean bl = atDestination = this.field_70122_E || MathHelper.func_76135_e((float)((float)((double)destY - this.field_70163_u))) < elevatorSpeed;
        if (destY < 1.0f || destY > (float)this.field_70170_p.func_72800_K()) {
            atDestination = true;
        }
        if (atDestination) {
            this.killAllConjoined();
            return;
        }
        this.field_70181_x = (double)destY > this.field_70163_u ? (double)elevatorSpeed : (double)(-elevatorSpeed);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70159_w);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 0.5), (double)(this.field_70163_u - 0.5), (double)(this.field_70161_v - 0.5), (double)(this.field_70165_t + 0.5), (double)(this.field_70163_u + 0.5), (double)(this.field_70161_v + 0.5));
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("destY", this.getDestinationY());
        if (this.destFloorName != null && !this.destFloorName.trim().isEmpty()) {
            nbttagcompound.func_74778_a("destName", this.destFloorName);
        }
        nbttagcompound.func_74768_a("yOffset", this.getElevatorYOffset());
        nbttagcompound.func_74757_a("emerHalt", this.emerHalt);
        nbttagcompound.func_74757_a("isCenter", this.isNotifierElevator);
        nbttagcompound.func_74768_a("ComputerX", this.computerPos.field_71574_a);
        nbttagcompound.func_74768_a("ComputerY", this.computerPos.field_71572_b);
        nbttagcompound.func_74768_a("ComputerZ", this.computerPos.field_71573_c);
        nbttagcompound.func_74776_a("TopSpeed", this.getMaximumSpeed());
        if (this.getCamoItem() != null) {
            NBTTagCompound itemNBTTagCompound = new NBTTagCompound();
            this.getCamoItem().func_77955_b(itemNBTTagCompound);
            nbttagcompound.func_74782_a("CamoItem", (NBTBase)itemNBTTagCompound);
        }
        nbttagcompound.func_74777_a("overlay", this.getOverlay().shortValue());
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setDestinationY(nbttagcompound.func_74762_e("destY"));
        this.setYOffset(nbttagcompound.func_74762_e("yOffset"));
        this.setMaximumSpeed(nbttagcompound.func_74760_g("TopSpeed"));
        this.emerHalt = nbttagcompound.func_74767_n("emerHalt");
        this.destFloorName = nbttagcompound.func_74779_i("destName");
        this.isNotifierElevator = nbttagcompound.func_74767_n("isCenter");
        this.computerPos = new ChunkCoordinates(nbttagcompound.func_74762_e("ComputerX"), nbttagcompound.func_74762_e("ComputerY"), nbttagcompound.func_74762_e("ComputerZ"));
        if (ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("CamoItem")) != null) {
            this.setCamoItem(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("CamoItem")));
        }
        this.setOverlay(nbttagcompound.func_74765_d("overlay"));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70046_E();
    }

    protected void unmountRiders() {
        if (!this.confirmedRiders.isEmpty()) {
            for (Integer entityID : this.confirmedRiders) {
                Entity rider = this.field_70170_p.func_73045_a(entityID.intValue());
                if (rider == null) continue;
                rider.field_70121_D.func_72317_d(0.0, this.func_70042_X(), 0.0);
                rider.field_70163_u = this.func_70046_E().field_72337_e + this.func_70042_X() + (double)rider.field_70129_M;
                rider.field_70160_al = false;
                rider.field_70122_E = true;
                rider.field_70143_R = 0.0f;
            }
            this.confirmedRiders.clear();
        }
    }

    protected void updatePotentialRiders() {
        HashSet potentialRiders = new HashSet();
        AxisAlignedBB boundBox = this.func_70046_E().func_72317_d(0.0, 1.5, 0.0).func_72314_b(0.0, 1.0, 0.0);
        potentialRiders.addAll(this.field_70170_p.func_72839_b((Entity)this, boundBox));
        for (Entity rider : potentialRiders) {
            if (rider instanceof EntityElevatorOld || rider.func_70115_ae() || this.confirmedRiders.contains(rider.func_145782_y()) || rider instanceof EntityPlayer && ((EntityPlayer)rider).field_71075_bZ.field_75100_b) continue;
            double yPos = this.field_70163_u + this.func_70042_X() - rider.field_70121_D.field_72338_b;
            rider.field_70181_x = this.field_70181_x < 0.0 ? this.field_70181_x : Math.max(yPos, rider.field_70181_x);
            rider.field_70160_al = true;
            rider.field_70122_E = true;
            rider.field_70143_R = 0.0f;
            this.confirmedRiders.add(rider.func_145782_y());
        }
    }

    protected boolean isRiding(Entity rider) {
        return rider != null && !rider.func_70115_ae() && rider.field_70121_D.field_72336_d >= this.func_70046_E().field_72340_a && rider.field_70121_D.field_72340_a <= this.func_70046_E().field_72336_d && rider.field_70121_D.field_72334_f >= this.func_70046_E().field_72339_c && rider.field_70121_D.field_72339_c <= this.func_70046_E().field_72334_f && rider.field_70121_D.field_72338_b <= this.field_70163_u + this.func_70042_X() + 2.0;
    }

    protected void updateConfirmedRiders() {
        if (!this.confirmedRiders.isEmpty()) {
            HashSet<Integer> removedRiders = new HashSet<Integer>();
            for (Integer entityID : this.confirmedRiders) {
                Entity rider = this.field_70170_p.func_73045_a(entityID.intValue());
                if (this.isRiding(rider)) {
                    double yPos = this.field_70163_u + this.func_70042_X() - rider.field_70121_D.field_72338_b;
                    double yDif = Math.abs(this.field_70163_u + this.func_70042_X() - rider.field_70121_D.field_72338_b);
                    if (yDif < 1.0) {
                        rider.field_70181_x = this.field_70181_x < 0.0 ? this.field_70181_x : Math.max(yPos, rider.field_70181_x);
                    } else {
                        rider.func_70091_d(0.0, yPos, 0.0);
                        rider.field_70181_x = this.field_70181_x;
                    }
                    rider.field_70160_al = true;
                    rider.field_70122_E = true;
                    rider.field_70143_R = 0.0f;
                    continue;
                }
                removedRiders.add(entityID);
            }
            if (!removedRiders.isEmpty()) {
                this.confirmedRiders.removeAll(removedRiders);
            }
        }
    }

    protected void updateRiders(boolean atDestination) {
        if (this.field_70128_L) {
            return;
        }
        this.updatePotentialRiders();
        if (atDestination) {
            this.unmountRiders();
            return;
        }
        this.updateConfirmedRiders();
    }

    public void func_70043_V() {
        this.updateRiders(false);
    }

    public double func_70042_X() {
        return 0.5;
    }

    public void setProperties(int destination, String destinationName, float elevatorTopSpeed, ChunkCoordinates computer, boolean haltable, int notifierID) {
        this.setDestinationY(destination);
        this.destFloorName = destinationName != null && !destinationName.trim().equals("") ? destinationName : String.valueOf(destination);
        this.computerPos = computer;
        this.canBeHalted = haltable;
        this.isNotifierElevator = notifierID == this.func_145782_y();
        this.setMaximumSpeed(elevatorTopSpeed);
        this.setWaitToAccelerate((byte)0);
        if (!this.isNotifierElevator) {
            this.notifierElevatorID = notifierID;
            this.getNotifier().conjoinedelevators.add(this.func_145782_y());
        }
    }

    protected void removeElevatorBlock(int x, int y, int z) {
        if (this.field_70170_p.func_147439_a(x, y, z) == ConfigurationLib.blockTransportBase && this.field_70170_p.func_72805_g(x, y, z) == 0) {
            TileEntityElevator tile = (TileEntityElevator)((Object)BlockHelper.getTileEntity((IBlockAccess)this.field_70170_p, (int)x, (int)y, (int)z, TileEntityElevator.class));
            if (tile != null) {
                if (tile.getCamoItem() != null) {
                    this.setCamoItem(tile.removeCamoItemWithoutDrop());
                }
                this.setYOffset(tile.getYOffest());
                this.setOverlay(tile.getOverlay());
            }
            this.field_70170_p.func_147468_f(x, y, z);
        }
    }

    protected void setTransitBlocks(int x, int y, int z) {
        if (this.getCamoItem() != null) {
            int blockLightValue = Block.func_149634_a((Item)this.getCamoItem().func_77973_b()).func_149750_m();
            int blockWeakPower = Block.func_149634_a((Item)this.getCamoItem().func_77973_b()).func_149709_b((IBlockAccess)this.field_70170_p, x, y, z, 0) / 2;
            if (this.field_70167_r < this.field_70163_u) {
                if (this.field_70170_p.func_147437_c(x, y - 1, z)) {
                    this.field_70170_p.func_147465_d(x, y, z, (Block)ConfigurationLib.blockPoweredLight[blockLightValue], 1, blockWeakPower);
                }
            } else if (this.field_70170_p.func_147437_c(x, y + 1, z)) {
                this.field_70170_p.func_147465_d(x, y + 1, z, (Block)ConfigurationLib.blockPoweredLight[blockLightValue], 1, blockWeakPower);
            }
        }
    }

    protected void setEmerHalt(boolean newhalt) {
        if (!this.canBeHalted && newhalt) {
            return;
        }
        this.emerHalt = newhalt;
        if (this.emerHalt) {
            this.field_70181_x = 0.0;
        }
        if (this.isNotifier()) {
            for (Integer conjoinedElevator : this.conjoinedelevators) {
                EntityElevatorOld curElevator = (EntityElevatorOld)this.field_70170_p.func_73045_a(conjoinedElevator.intValue());
                if (curElevator == this || curElevator.emerHalt == this.emerHalt) continue;
                curElevator.setEmerHalt(this.emerHalt);
            }
        } else if (this.getNotifier() != null && this.getNotifier().emerHalt != this.emerHalt) {
            this.getNotifier().setEmerHalt(this.emerHalt);
        }
    }

    protected void killAllConjoined() {
        TileEntityElevatorComputer computer;
        for (Integer conjoinedElevator : this.conjoinedelevators) {
            EntityElevatorOld curElevator = (EntityElevatorOld)this.field_70170_p.func_73045_a(conjoinedElevator.intValue());
            if (curElevator == null) continue;
            curElevator.func_70106_y();
        }
        this.func_70106_y();
        if (this.isNotifierElevator && MathHelper.func_76128_c((double)this.field_70163_u) == this.getTargetY() && (computer = this.getParentElevatorComputer()) != null) {
            computer.elevatorArrived(this.getDestinationY());
        }
    }

    protected boolean isNotifier() {
        return this.isNotifierElevator || this.notifierElevatorID == this.func_145782_y();
    }

    protected EntityElevatorOld getNotifier() {
        return (EntityElevatorOld)this.field_70170_p.func_73045_a(this.notifierElevatorID);
    }

    protected TileEntityElevatorComputer getParentElevatorComputer() {
        TileEntityElevatorComputer computer = null;
        if (this.computerPos != null) {
            computer = (TileEntityElevatorComputer)((Object)BlockHelper.getTileEntity((IBlockAccess)this.field_70170_p, (int)this.computerPos.field_71574_a, (int)this.computerPos.field_71572_b, (int)this.computerPos.field_71573_c, TileEntityElevatorComputer.class));
        }
        return computer;
    }
}

