/*
 * Decompiled with CFR 0.152.
 */
package com.jiraiyah.morePistons.tileEntities;

import com.jiraiyah.morePistons.blocks.PistonExtension;
import com.jiraiyah.morePistons.blocks.PistonRod;
import com.jiraiyah.morePistons.init.ModBlocks;
import com.jiraiyah.morePistons.utility.Log;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;

public class TileEntityMorePistons
extends TileEntity {
    public Block storedBlock = null;
    private int storedMetadata = 0;
    public int storedOrientation = 0;
    private boolean extending = false;
    private boolean shouldHeadBeRendered = false;
    public int distance = 0;
    public boolean isBlockPiston = false;
    private float progress = 0.0f;
    private float lastProgress = 0.0f;
    private List pushedObjects = new ArrayList();

    public TileEntityMorePistons() {
    }

    public TileEntityMorePistons(Block block, int metadata, int orientation, boolean extending, boolean shouldHeadBeRendered, int distance, boolean isBlockPiston) {
        if (block == null) {
            Log.fatal("Block strorage in null in creation TileEntiry");
        }
        this.storedBlock = block;
        this.storedMetadata = metadata;
        this.storedOrientation = orientation;
        this.extending = extending;
        this.shouldHeadBeRendered = shouldHeadBeRendered;
        this.distance = distance;
        this.isBlockPiston = isBlockPiston;
    }

    public int getOpened() {
        return 0;
    }

    public float getProgress(float par1) {
        if (par1 > 1.0f) {
            par1 = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * par1;
    }

    public void displayPistonRod(int nb) {
        this.displayPistonRod(nb, nb);
    }

    public void displayPistonRod(int nb, int lenght) {
        int x = this.field_145851_c - Facing.field_71586_b[this.storedOrientation] * lenght;
        int y = this.field_145848_d - Facing.field_71587_c[this.storedOrientation] * lenght;
        int z = this.field_145849_e - Facing.field_71585_d[this.storedOrientation] * lenght;
        Log.debug("displayPistonRod : " + x + ", " + y + ", " + z + " nb=" + nb + " lenght=" + lenght);
        for (int i = 0; i < nb; ++i) {
            Block block = this.field_145850_b.func_147439_a(x += Facing.field_71586_b[this.storedOrientation], y += Facing.field_71587_c[this.storedOrientation], z += Facing.field_71585_d[this.storedOrientation]);
            if (block != null && !(block instanceof BlockAir) && (block instanceof BlockPistonBase || block instanceof BlockPistonMoving)) continue;
            this.field_145850_b.func_147465_d(x, y, z, ModBlocks.Rod, this.storedOrientation, 2);
        }
    }

    public void removePistonRod(int nb) {
        this.removePistonRod(nb, nb);
    }

    public void removePistonRod(int nb, int lenght) {
        int x = this.field_145851_c + Facing.field_71586_b[this.storedOrientation] * (lenght + 1);
        int y = this.field_145848_d + Facing.field_71587_c[this.storedOrientation] * (lenght + 1);
        int z = this.field_145849_e + Facing.field_71585_d[this.storedOrientation] * (lenght + 1);
        for (int i = 0; i <= nb; ++i) {
            Block block = this.field_145850_b.func_147439_a(x -= Facing.field_71586_b[this.storedOrientation], y -= Facing.field_71587_c[this.storedOrientation], z -= Facing.field_71585_d[this.storedOrientation]);
            if (!(block instanceof PistonRod) && !(block instanceof PistonExtension)) continue;
            this.field_145850_b.func_147468_f(x, y, z);
            this.field_145850_b.func_72921_c(x, y, z, 0, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetX(float par1) {
        return this.extending ? (this.getProgress(par1) * (float)this.distance - (float)this.distance) * (float)Facing.field_71586_b[this.storedOrientation] : ((float)this.distance - this.getProgress(par1) * (float)this.distance) * (float)Facing.field_71586_b[this.storedOrientation];
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetY(float par1) {
        return this.extending ? (this.getProgress(par1) * (float)this.distance - (float)this.distance) * (float)Facing.field_71587_c[this.storedOrientation] : ((float)this.distance - this.getProgress(par1) * (float)this.distance) * (float)Facing.field_71587_c[this.storedOrientation];
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetZ(float par1) {
        return this.extending ? (this.getProgress(par1) * (float)this.distance - (float)this.distance) * (float)Facing.field_71585_d[this.storedOrientation] : ((float)this.distance - this.getProgress(par1) * (float)this.distance) * (float)Facing.field_71585_d[this.storedOrientation];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderHead() {
        return this.shouldHeadBeRendered;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public void func_145845_h() {
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.updatePushedObjects(1.0f, 0.25f);
            this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145843_s();
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockPistonMoving) {
                if (this.distance < 0 || this.isBlockPiston && !this.extending) {
                    this.removePistonRod(Math.abs(this.distance));
                } else if (this.isBlockPiston && this.extending) {
                    this.displayPistonRod(this.distance + 1);
                }
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storedBlock);
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storedMetadata, 2);
                if (this.storedBlock != null && (this.storedBlock instanceof PistonExtension || this.storedBlock instanceof BlockPistonBase)) {
                    this.storedBlock.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storedBlock);
                }
            }
        } else {
            this.progress += 0.5f;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
            if (this.extending) {
                this.updatePushedObjects(this.progress, this.progress - this.lastProgress + 0.0625f);
            }
        }
    }

    private void updatePushedObjects(float par1, float par2) {
        par1 = this.extending ? 1.0f - par1 : (par1 -= 1.0f);
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (this.storedBlock == null) {
            Log.fatal("Block Stored in TilEntity is null");
        } else {
            for (int i = 0; i <= this.distance; ++i) {
                this.testCollisionWithOtherEntity(x, y, z, par1, par2);
                x -= Facing.field_71586_b[this.storedOrientation];
                y -= Facing.field_71587_c[this.storedOrientation];
                z -= Facing.field_71585_d[this.storedOrientation];
            }
        }
    }

    private void testCollisionWithOtherEntity(int x, int y, int z, float par1, float par2) {
        List var4;
        if (this.storedBlock == null) {
            Log.fatal("Block strorage in null in creation TileEntiry");
            return;
        }
        AxisAlignedBB var3 = Blocks.field_150326_M.func_149964_a(this.field_145850_b, x, y, z, this.storedBlock, par1, this.storedOrientation);
        if (var3 != null && !(var4 = this.field_145850_b.func_72839_b((Entity)null, var3)).isEmpty() && this.extending) {
            this.pushedObjects.addAll(var4);
            Iterator i = this.pushedObjects.iterator();
            int fX = Facing.field_71586_b[this.storedOrientation];
            int fY = Facing.field_71587_c[this.storedOrientation];
            int fZ = Facing.field_71585_d[this.storedOrientation];
            while (i.hasNext()) {
                Entity entity = (Entity)i.next();
                double xE = entity.field_70165_t;
                double yE = entity.field_70163_u;
                double zE = entity.field_70161_v;
                switch (this.storedOrientation) {
                    case 0: 
                    case 1: {
                        yE = (float)(this.field_145848_d + fY) + par2 * (float)fY;
                        break;
                    }
                    case 2: 
                    case 3: {
                        zE = (float)(this.field_145849_e + fZ) + par2 * (float)fZ;
                        break;
                    }
                    case 4: 
                    case 5: {
                        xE = (float)(this.field_145851_c + fX) + par2 * (float)fX;
                    }
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c + fX, this.field_145848_d + fY, this.field_145849_e + fZ) instanceof BlockPistonMoving) continue;
                entity.func_70107_b(xE, yE, zE);
            }
            this.pushedObjects.clear();
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        try {
            this.storedBlock = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("blockId"));
            this.storedMetadata = par1NBTTagCompound.func_74762_e("blockData");
            this.storedOrientation = par1NBTTagCompound.func_74762_e("facing");
            this.extending = par1NBTTagCompound.func_74767_n("extending");
            this.distance = par1NBTTagCompound.func_74762_e("distance");
            this.isBlockPiston = par1NBTTagCompound.func_74767_n("isBlockPiston");
            this.lastProgress = this.progress = par1NBTTagCompound.func_74760_g("progress");
        }
        catch (Exception e) {
            Log.warn("Not stored tile entity : " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        if (this.storedBlock == null) {
            Log.fatal("Strored Block strored in null in TileEntiry");
            par1NBTTagCompound.func_74768_a("blockId", Block.func_149682_b((Block)Blocks.field_150350_a));
        } else {
            par1NBTTagCompound.func_74768_a("blockId", Block.func_149682_b((Block)this.storedBlock));
        }
        par1NBTTagCompound.func_74768_a("blockData", this.storedMetadata);
        par1NBTTagCompound.func_74768_a("facing", this.storedOrientation);
        par1NBTTagCompound.func_74757_a("extending", this.extending);
        par1NBTTagCompound.func_74768_a("distance", this.distance);
        par1NBTTagCompound.func_74757_a("isBlockPiston", this.isBlockPiston);
        par1NBTTagCompound.func_74776_a("progress", this.lastProgress);
    }
}

