/*
 * Decompiled with CFR 0.152.
 */
package com.jiraiyah.morePistons.blocks;

import com.jiraiyah.morePistons.blocks.GenericPistonBlock;
import com.jiraiyah.morePistons.blocks.PistonExtension;
import com.jiraiyah.morePistons.blocks.PistonRod;
import com.jiraiyah.morePistons.reference.Configurations;
import com.jiraiyah.morePistons.tileEntities.TileEntityMorePistons;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class SuperPiston
extends GenericPistonBlock {
    public SuperPiston(boolean isSticky, String texturePrefixe, int length, String name) {
        super(isSticky, "super_" + texturePrefixe, length, name);
        this.func_149663_c(name.toLowerCase());
    }

    @Override
    public int getMaxBlockMove() {
        return Configurations.SUPER_PISTON_ROW;
    }

    protected ArrayList<GenericPistonBlock.EMoveInfosExtend> getListOrigin(World world, int x, int y, int z, int orientation, int lenghtOpened) {
        int xExtension = x;
        int yExtension = y;
        int zExtension = z;
        ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksOrigin = new ArrayList<GenericPistonBlock.EMoveInfosExtend>();
        int size = lenghtOpened;
        for (int i = 0; i < lenghtOpened + this.getMaxBlockMove() && size > 0; ++i) {
            Block block = world.func_147439_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation]);
            int metadata = world.func_72805_g(xExtension, yExtension, zExtension);
            if (SuperPiston.isEmptyBlock(block)) {
                --size;
                continue;
            }
            if (!this.isMovableBlock(block, world, xExtension, yExtension, zExtension)) break;
            blocksOrigin.add(new GenericPistonBlock.EMoveInfosExtend(xExtension, yExtension, zExtension, size));
        }
        Collections.reverse(blocksOrigin);
        return blocksOrigin;
    }

    protected ArrayList<GenericPistonBlock.EMoveInfosExtend> getListUpBlocks(ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksOrigin, World world, int x, int y, int z, int orientation, int lenghtOpened) {
        int xExtension = x;
        int yExtension = y;
        int zExtension = z;
        ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksTop = new ArrayList<GenericPistonBlock.EMoveInfosExtend>();
        for (GenericPistonBlock.EMoveInfosExtend blockOrigin : blocksOrigin) {
            Block blockNext;
            int moveBlock;
            if (orientation == 0 || orientation == 1) continue;
            int xBlock = blockOrigin.x;
            int yBlock = blockOrigin.y + 1;
            int zBlock = blockOrigin.z;
            Block block = world.func_147439_a(xBlock, yBlock, zBlock);
            int metadata = world.func_72805_g(xBlock, yBlock, zBlock);
            if (block == null || block == Blocks.field_150350_a) continue;
            if (!SuperPiston.isEmptyBlock(block) && !(block instanceof BlockTrapDoor)) {
                moveBlock = 0;
                if (this.isMovableBlock(block, world, xBlock, yBlock, zBlock)) {
                    xExtension = xBlock;
                    yExtension = yBlock;
                    zExtension = zBlock;
                    for (moveBlock = 0; moveBlock < blockOrigin.move; ++moveBlock) {
                        blockNext = world.func_147439_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation]);
                        if (!SuperPiston.isEmptyBlock(blockNext)) break;
                        if (blockNext == null || blockNext == Blocks.field_150350_a) continue;
                        int metadataNext = world.func_72805_g(xExtension, yExtension, zExtension);
                        this.dropMobilityFlag1(blockNext, metadataNext, world, xExtension, yExtension, zExtension);
                    }
                }
                if (moveBlock <= 0) continue;
                world.func_147468_f(xBlock, yBlock, zBlock);
                xExtension = xBlock;
                yExtension = yBlock;
                zExtension = zBlock;
                for (int j = 0; j < moveBlock; ++j) {
                    Block blockNext2 = world.func_147439_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation]);
                    if (blockNext2 == null || block == Blocks.field_150350_a) continue;
                    int metadataNext = world.func_72805_g(xExtension, yExtension, zExtension);
                    this.dropMobilityFlag1(blockNext2, metadataNext, world, xExtension, yExtension, zExtension);
                }
                blocksTop.add(new GenericPistonBlock.EMoveInfosExtend(block, metadata, xExtension, yExtension, zExtension, moveBlock));
                continue;
            }
            if (block instanceof BlockDoor || block instanceof BlockBed) {
                this.dropMobilityFlag1(block, metadata, world, xBlock, yBlock, zBlock);
                continue;
            }
            if (!this.isAttachOnTop(block, metadata)) continue;
            moveBlock = 0;
            xExtension = xBlock;
            yExtension = yBlock;
            zExtension = zBlock;
            for (moveBlock = 0; moveBlock < blockOrigin.move && ((blockNext = world.func_147439_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation])) == null || blockNext == Blocks.field_150350_a); ++moveBlock) {
            }
            if (moveBlock != blockOrigin.move) {
                this.dropMobilityFlag1(block, metadata, world, xBlock, yBlock, zBlock);
                continue;
            }
            world.func_147468_f(xBlock, yBlock, zBlock);
            xExtension = xBlock + Facing.field_71586_b[orientation] * moveBlock;
            yExtension = yBlock + Facing.field_71587_c[orientation] * moveBlock;
            zExtension = zBlock + Facing.field_71585_d[orientation] * moveBlock;
            blocksTop.add(new GenericPistonBlock.EMoveInfosExtend(block, metadata, xExtension, yExtension, zExtension, moveBlock));
        }
        return blocksTop;
    }

    protected ArrayList<GenericPistonBlock.EMoveInfosExtend> getListNextBlocks(ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksOrigin, World world, int x, int y, int z, int orientation, int lenghtOpened) {
        int xExtension = x;
        int yExtension = y;
        int zExtension = z;
        ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksList = new ArrayList<GenericPistonBlock.EMoveInfosExtend>();
        for (GenericPistonBlock.EMoveInfosExtend blockOrigin : blocksOrigin) {
            for (int o = 2; o <= 5; ++o) {
                Block blockNext;
                if (o == orientation || o == Facing.field_71588_a[orientation]) continue;
                int xBlock = blockOrigin.x + Facing.field_71586_b[o];
                int yBlock = blockOrigin.y;
                int zBlock = blockOrigin.z + Facing.field_71585_d[o];
                Block block = world.func_147439_a(xBlock, yBlock, zBlock);
                int metadata = world.func_72805_g(xBlock, yBlock, zBlock);
                if (block != null && (block instanceof BlockDoor || block instanceof BlockBed) || block == null || block == Blocks.field_150350_a) continue;
                if (!SuperPiston.isEmptyBlock(block) && !(block instanceof BlockTrapDoor) || !this.isAttachOnNext(block, metadata, o)) continue;
                int moveBlock = 0;
                xExtension = xBlock;
                yExtension = yBlock;
                zExtension = zBlock;
                for (moveBlock = 0; moveBlock < blockOrigin.move && ((blockNext = world.func_147439_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation])) == null || blockNext == Blocks.field_150350_a); ++moveBlock) {
                }
                if (moveBlock != blockOrigin.move) {
                    this.dropMobilityFlag1(block, metadata, world, xBlock, yBlock, zBlock);
                    continue;
                }
                world.func_147468_f(xBlock, yBlock, zBlock);
                xExtension = xBlock + Facing.field_71586_b[orientation] * moveBlock;
                yExtension = yBlock + Facing.field_71587_c[orientation] * moveBlock;
                zExtension = zBlock + Facing.field_71585_d[orientation] * moveBlock;
                blocksList.add(new GenericPistonBlock.EMoveInfosExtend(block, metadata, xExtension, yExtension, zExtension, moveBlock));
            }
        }
        return blocksList;
    }

    @Override
    protected void retracSticky(World world, int x, int y, int z, int orientation, int length) {
        if (this.field_150082_a) {
            TileEntityMorePistons teBlock;
            int x2 = x + Facing.field_71586_b[orientation] * (length + 1);
            int y2 = y + Facing.field_71587_c[orientation] * (length + 1);
            int z2 = z + Facing.field_71585_d[orientation] * (length + 1);
            ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksOrigin = new ArrayList<GenericPistonBlock.EMoveInfosExtend>();
            blocksOrigin.add(new GenericPistonBlock.EMoveInfosExtend(x2, y2, z2, length));
            ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksTop = this.getListUpBlocks(blocksOrigin, world, x, y, z, Facing.field_71588_a[orientation], length);
            ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksNext = this.getListNextBlocks(blocksOrigin, world, x, y, z, Facing.field_71588_a[orientation], length);
            super.retracSticky(world, x, y, z, orientation, length);
            for (GenericPistonBlock.EMoveInfosExtend blockTop : blocksTop) {
                world.func_147465_d(blockTop.x, blockTop.y, blockTop.z, (Block)Blocks.field_150326_M, blockTop.metadata, 2);
                teBlock = new TileEntityMorePistons(blockTop.block, blockTop.metadata, Facing.field_71588_a[orientation], true, false, blockTop.move, false);
                world.func_147455_a(blockTop.x, blockTop.y, blockTop.z, (TileEntity)teBlock);
            }
            for (GenericPistonBlock.EMoveInfosExtend blockNext : blocksNext) {
                world.func_147465_d(blockNext.x, blockNext.y, blockNext.z, (Block)Blocks.field_150326_M, blockNext.metadata, 2);
                teBlock = new TileEntityMorePistons(blockNext.block, blockNext.metadata, Facing.field_71588_a[orientation], true, false, blockNext.move, false);
                world.func_147455_a(blockNext.x, blockNext.y, blockNext.z, (TileEntity)teBlock);
            }
        }
    }

    @Override
    protected void extend(World world, int x, int y, int z, int orientation, int lenghtOpened) {
        TileEntityMorePistons teBlock;
        ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksOrigin = this.getListOrigin(world, x, y, z, orientation, lenghtOpened);
        ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksTop = this.getListUpBlocks(blocksOrigin, world, x, y, z, orientation, lenghtOpened);
        ArrayList<GenericPistonBlock.EMoveInfosExtend> blocksNext = this.getListNextBlocks(blocksOrigin, world, x, y, z, orientation, lenghtOpened);
        super.extend(world, x, y, z, orientation, lenghtOpened);
        for (GenericPistonBlock.EMoveInfosExtend blockTop : blocksTop) {
            world.func_147465_d(blockTop.x, blockTop.y, blockTop.z, (Block)Blocks.field_150326_M, blockTop.metadata, 2);
            teBlock = new TileEntityMorePistons(blockTop.block, blockTop.metadata, orientation, true, false, blockTop.move, false);
            world.func_147455_a(blockTop.x, blockTop.y, blockTop.z, (TileEntity)teBlock);
        }
        for (GenericPistonBlock.EMoveInfosExtend blockNext : blocksNext) {
            world.func_147465_d(blockNext.x, blockNext.y, blockNext.z, (Block)Blocks.field_150326_M, blockNext.metadata, 2);
            teBlock = new TileEntityMorePistons(blockNext.block, blockNext.metadata, orientation, true, false, blockNext.move, false);
            world.func_147455_a(blockNext.x, blockNext.y, blockNext.z, (TileEntity)teBlock);
        }
    }

    protected boolean isAttachOnTop(Block block, int metadata) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        return !(block instanceof BlockSkull || block instanceof BlockLadder || block instanceof BlockButton || block instanceof BlockTripWireHook || block instanceof BlockTorch && metadata != 5 || block instanceof BlockTrapDoor && (metadata & 8) == 8) && (!(block instanceof BlockLever) || metadata == 5 || metadata == 6);
    }

    protected int convertOrientationFromTorch(int o) {
        switch (o) {
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    protected int convertOrientationFromTripe(int o) {
        switch (o) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    protected boolean isAttachOnNext(Block block, int metadata, int orientation) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        return block instanceof BlockLadder && metadata == orientation || block instanceof BlockTripWireHook && this.convertOrientationFromTripe(metadata) == orientation || block instanceof BlockButton && this.convertOrientationFromTorch(metadata) == orientation || block instanceof BlockTorch && this.convertOrientationFromTorch(metadata) == orientation || block instanceof BlockLever && this.convertOrientationFromTorch(metadata) == orientation || block instanceof BlockTrapDoor && (metadata & 3) + 2 == orientation;
        {
        }
    }

    @Override
    public boolean isMovableBlock(Block block, World world, int x, int y, int z) {
        boolean isPistonClosed = GenericPistonBlock.isPiston(block);
        if (isPistonClosed) {
            BlockPistonBase cfr_ignored_0 = (BlockPistonBase)block;
            isPistonClosed = !BlockPistonBase.func_150075_c((int)world.func_72805_g(x, y, z));
        }
        return GenericPistonBlock.isEmptyBlock(block) || isPistonClosed || block.func_149656_h() != 2 && !(block instanceof PistonRod) && !(block instanceof PistonExtension) && !(block instanceof BlockPistonMoving) && world.func_147438_o(x, y, z) == null && block.func_149712_f(world, x, y, z) != -1.0f;
    }
}

