/*
 * Decompiled with CFR 0.152.
 */
package com.jiraiyah.morePistons.blocks;

import com.jiraiyah.morePistons.MorePistons;
import com.jiraiyah.morePistons.blocks.PistonExtension;
import com.jiraiyah.morePistons.blocks.PistonRod;
import com.jiraiyah.morePistons.init.ModBlocks;
import com.jiraiyah.morePistons.reference.Textures;
import com.jiraiyah.morePistons.tileEntities.TileEntityMorePistons;
import com.jiraiyah.morePistons.utility.Log;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class GenericPistonBlock
extends BlockPistonBase {
    private boolean ignoreUpdates = false;
    private int length = 1;
    protected boolean field_150082_a;
    protected String texturePrefixe;
    protected IIcon textureFileTop;
    protected IIcon textureFileOpen;
    protected IIcon textureFileSide;
    protected IIcon textureFileBottom;

    public GenericPistonBlock(boolean isSticky, String texturePrefixe, int length, String name) {
        super(isSticky);
        this.field_150082_a = isSticky;
        this.texturePrefixe = texturePrefixe;
        this.func_149672_a(field_149769_e);
        this.func_149711_c(0.5f);
        this.setLength(length);
        this.func_149663_c(name.toLowerCase());
        this.func_149647_a(MorePistons.MorePistonsTab);
    }

    public GenericPistonBlock setLength(int length) {
        this.length = length;
        return this;
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", Textures.RESOURCE_REFERENCE, this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        Log.info("Register Icon " + this.func_149739_a().substring(this.func_149739_a().indexOf(".") + 1));
        this.textureFileTop = this.loadTexture(iconRegister, Textures.RESOURCE_REFERENCE + "top" + (this.field_150082_a ? "_sticky" : ""));
        this.textureFileOpen = this.loadTexture(iconRegister, Textures.RESOURCE_REFERENCE + this.texturePrefixe + "top");
        this.textureFileBottom = this.loadTexture(iconRegister, Textures.RESOURCE_REFERENCE + this.texturePrefixe + "bottom");
        this.textureFileSide = this.loadTexture(iconRegister, Textures.RESOURCE_REFERENCE + this.texturePrefixe + "side");
    }

    public int getMaxBlockMove() {
        return 12;
    }

    public IIcon loadTexture(IIconRegister iconRegister, String key) {
        return iconRegister.func_94245_a(key);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_150073_e() {
        return this.textureFileTop;
    }

    public IIcon func_149691_a(int i, int j) {
        int k = GenericPistonBlock.func_150076_b((int)j);
        if (k > 5) {
            return this.textureFileTop;
        }
        if (i == k) {
            if (GenericPistonBlock.func_150075_c((int)j) || this.field_149759_B > 0.0 || this.field_149760_C > 0.0 || this.field_149754_D > 0.0 || this.field_149755_E < 1.0 || this.field_149756_F < 1.0 || this.field_149757_G < 1.0) {
                return this.textureFileOpen;
            }
            return this.textureFileTop;
        }
        return i != Facing.field_71588_a[k] ? this.textureFileSide : this.textureFileBottom;
    }

    public void func_149664_b(World world, int x, int y, int z, int metadata) {
        int orientation = GenericPistonBlock.func_150076_b((int)metadata);
        Block block = ModBlocks.Rod;
        while (block instanceof PistonRod) {
            block = world.func_147439_a(x += Facing.field_71586_b[orientation], y += Facing.field_71587_c[orientation], z += Facing.field_71585_d[orientation]);
            if (!(block instanceof PistonRod) && !(block instanceof PistonExtension)) continue;
            world.func_147480_a(x, y, z, false);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int orientation = GenericPistonBlock.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entityLiving);
        world.func_72921_c(x, y, z, orientation, 2);
        if (!this.ignoreUpdates && !world.field_72995_K) {
            this.func_150078_e(world, x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.ignoreUpdates && !world.field_72995_K) {
            this.func_150078_e(world, x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
    }

    public void func_150078_e(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        int orientation = GenericPistonBlock.func_150076_b((int)metadata);
        if (metadata == 7) {
            return;
        }
        boolean powered = this.func_150072_a(world, x, y, z, orientation);
        boolean extended = GenericPistonBlock.func_150075_c((int)metadata);
        if (!powered && extended) {
            int max = this.getMaximalOpenedLenght(world, x, y, z, orientation);
            if (max == -1) {
                return;
            }
            world.func_72921_c(x, y, z, orientation, 2);
            world.func_147452_c(x, y, z, (Block)this, 0, orientation);
        } else if (powered) {
            int max = this.getMaximalOpenedLenght(world, x, y, z, orientation);
            if (max <= 0) {
                return;
            }
            world.func_72921_c(x, y, z, orientation | 8, 2);
            world.func_147452_c(x, y, z, (Block)this, max, orientation);
        }
    }

    protected boolean func_150072_a(World world, int x, int y, int z, int orientation) {
        if (orientation != 0 && world.func_94574_k(x, y - 1, z, 0)) {
            return true;
        }
        if (orientation != 1 && world.func_94574_k(x, y + 1, z, 1)) {
            return true;
        }
        if (orientation != 2 && world.func_94574_k(x, y, z - 1, 2)) {
            return true;
        }
        if (orientation != 3 && world.func_94574_k(x, y, z + 1, 3)) {
            return true;
        }
        if (orientation != 5 && world.func_94574_k(x + 1, y, z, 5)) {
            return true;
        }
        if (orientation != 4 && world.func_94574_k(x - 1, y, z, 4)) {
            return true;
        }
        if (world.func_94574_k(x, y, z, 0)) {
            return true;
        }
        if (world.func_94574_k(x, y + 2, z, 1)) {
            return true;
        }
        if (world.func_94574_k(x, y + 1, z - 1, 2)) {
            return true;
        }
        if (world.func_94574_k(x, y + 1, z + 1, 3)) {
            return true;
        }
        if (world.func_94574_k(x - 1, y + 1, z, 4)) {
            return true;
        }
        boolean flag = world.func_94574_k(x + 1, y + 1, z, 5);
        return flag;
    }

    public int getMaximalOpenedLenght(World world, int x, int y, int z, int orientation) {
        return this.getMaximalOpenedLenght(world, x, y, z, orientation, true, this.getLengthInWorld(world, x, y, z, orientation));
    }

    public int getLengthInWorld(World world, int x, int y, int z, int orientation) {
        return this.length;
    }

    public int getMaximalOpenedLenght(World world, int x, int y, int z, int orientation, boolean detectMoving, int maxlenght) {
        int lenght = 0;
        for (int i = 0; i < maxlenght; ++i) {
            x += Facing.field_71586_b[orientation];
            z += Facing.field_71585_d[orientation];
            if ((y += Facing.field_71587_c[orientation]) >= 255) break;
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockPistonMoving) {
                if (detectMoving) {
                    return -1;
                }
                return lenght;
            }
            if (!GenericPistonBlock.isEmptyBlock(block)) {
                if (!GenericPistonBlock.isRodInOrientation(block, world, x, y, z, orientation)) {
                    lenght += this.getMoveBlockOnDistance(maxlenght - i, world, block, x, y, z, orientation);
                    break;
                }
            }
            ++lenght;
        }
        return lenght;
    }

    private int getMoveBlockOnDistance(int distance, World world, Block block, int x, int y, int z, int orientation) {
        return this.getMoveBlockOnDistance(distance, world, block, x, y, z, orientation, 1);
    }

    private int getMoveBlockOnDistance(int distance, World world, Block block, int x, int y, int z, int orientation, int nbMoved) {
        if (nbMoved == this.getMaxBlockMove() || !this.isMovableBlock(block, world, x, y, z)) {
            return 0;
        }
        int walking = 0;
        for (int i = 0; i < distance; ++i) {
            x += Facing.field_71586_b[orientation];
            z += Facing.field_71585_d[orientation];
            if ((y += Facing.field_71587_c[orientation]) >= 255) break;
            Block blockNext = world.func_147439_a(x, y, z);
            if (GenericPistonBlock.isEmptyBlock(blockNext)) {
                ++walking;
                continue;
            }
            int moving = this.getMoveBlockOnDistance(distance - i, world, blockNext, x, y, z, orientation, nbMoved + 1);
            walking += moving;
            break;
        }
        return walking;
    }

    private static boolean isRodInOrientation(Block block, World world, int x, int y, int z, int orientation) {
        if (block instanceof PistonExtension || block instanceof PistonRod || block instanceof BlockPistonMoving) {
            return orientation == GenericPistonBlock.func_150076_b((int)world.func_72805_g(x, y, z));
        }
        return false;
    }

    public static boolean isEmptyBlock(Block block) {
        return block == null || block instanceof BlockAir || block.func_149656_h() == 1 || block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    public boolean isMovableBlock(Block block, World world, int x, int y, int z) {
        boolean isPistonClosed = GenericPistonBlock.isPiston(block);
        if (isPistonClosed) {
            BlockPistonBase cfr_ignored_0 = (BlockPistonBase)block;
            isPistonClosed = !BlockPistonBase.func_150075_c((int)world.func_72805_g(x, y, z));
        }
        return GenericPistonBlock.isEmptyBlock(block) || isPistonClosed || block != Blocks.field_150343_Z && block.func_149656_h() != 2 && !(block instanceof PistonRod) && !(block instanceof PistonExtension) && !(block instanceof BlockPistonMoving) && world.func_147438_o(x, y, z) == null && block.func_149712_f(world, x, y, z) != -1.0f;
    }

    public static boolean isPiston(Block block) {
        return block instanceof BlockPistonBase;
    }

    public int getOpenedLenght(World world, int x, int y, int z, int orientation) {
        int lenght = -1;
        Block block = null;
        int metadata = 0;
        int blockOrentation = 0;
        boolean moving = false;
        do {
            Block blockMoving;
            TileEntity tileEntity;
            ++lenght;
            block = world.func_147439_a(x += Facing.field_71586_b[orientation], y += Facing.field_71587_c[orientation], z += Facing.field_71585_d[orientation]);
            metadata = world.func_72805_g(x, y, z);
            blockOrentation = GenericPistonBlock.func_150076_b((int)metadata);
            moving = false;
            if (!(block instanceof BlockPistonMoving) || !((tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityMorePistons) || !((blockMoving = ((TileEntityMorePistons)tileEntity).storedBlock) instanceof PistonRod) && !(blockMoving instanceof PistonExtension)) continue;
            moving = true;
        } while ((moving || block instanceof PistonRod || block instanceof PistonExtension) && orientation == blockOrentation);
        return lenght;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int lenghtOpened, int orientation) {
        if (!this.ignoreUpdates) {
            this.ignoreUpdates = true;
            boolean extendOpen = false;
            boolean extendClose = false;
            int currentOpened = this.getOpenedLenght(world, x, y, z, orientation);
            if (lenghtOpened > 0) {
                if (currentOpened == lenghtOpened) {
                    this.ignoreUpdates = false;
                    return true;
                }
                if (currentOpened == 0) {
                    this.extend(world, x, y, z, orientation, lenghtOpened);
                    extendOpen = true;
                } else if (currentOpened < lenghtOpened) {
                    int x2 = x + Facing.field_71586_b[orientation] * currentOpened;
                    int y2 = y + Facing.field_71587_c[orientation] * currentOpened;
                    int z2 = z + Facing.field_71585_d[orientation] * currentOpened;
                    this.extend(world, x2, y2, z2, orientation, lenghtOpened - currentOpened);
                    extendOpen = true;
                } else {
                    int diff = currentOpened - lenghtOpened;
                    int x2 = x + Facing.field_71586_b[orientation] * lenghtOpened;
                    int y2 = y + Facing.field_71587_c[orientation] * lenghtOpened;
                    int z2 = z + Facing.field_71585_d[orientation] * lenghtOpened;
                    int cX2 = x + Facing.field_71586_b[orientation] * currentOpened;
                    int cY2 = y + Facing.field_71587_c[orientation] * currentOpened;
                    int cZ2 = z + Facing.field_71585_d[orientation] * currentOpened;
                    world.func_147468_f(cX2, cY2, cZ2);
                    world.func_147465_d(x2, y2, z2, (Block)Blocks.field_150326_M, orientation, 2);
                    TileEntityMorePistons teExtension = new TileEntityMorePistons((Block)ModBlocks.Extension, orientation, orientation, true, false, -diff, false);
                    world.func_147455_a(x2, y2, z2, (TileEntity)teExtension);
                    this.retracSticky(world, x2, y2, z2, orientation, diff);
                    extendClose = true;
                }
            } else if (currentOpened == 0) {
                world.func_72921_c(x, y, z, orientation, 2);
            } else {
                TileEntity tileentity = world.func_147438_o(x + Facing.field_71586_b[orientation], y + Facing.field_71587_c[orientation], z + Facing.field_71585_d[orientation]);
                if (tileentity instanceof TileEntityPiston) {
                    ((TileEntityPiston)tileentity).func_145866_f();
                }
                int cX2 = x + Facing.field_71586_b[orientation] * currentOpened;
                int cY2 = y + Facing.field_71587_c[orientation] * currentOpened;
                int cZ2 = z + Facing.field_71585_d[orientation] * currentOpened;
                world.func_147468_f(cX2, cY2, cZ2);
                world.func_147465_d(x, y, z, (Block)Blocks.field_150326_M, orientation, 2);
                world.func_147455_a(x, y, z, (TileEntity)new TileEntityMorePistons((Block)this, orientation, orientation, false, true, currentOpened, true));
                this.retracSticky(world, x, y, z, orientation, currentOpened);
                extendClose = true;
            }
            if (extendOpen) {
                world.func_72921_c(x, y, z, orientation | 8, 2);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
            }
            if (extendClose) {
                world.func_72921_c(x, y, z, orientation | 8, 2);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
            }
            this.ignoreUpdates = false;
        }
        return true;
    }

    protected void retracSticky(World world, int x, int y, int z, int orientation, int length) {
        int z2;
        int y2;
        int x2;
        Block block;
        if (this.field_150082_a && !GenericPistonBlock.isEmptyBlock(block = world.func_147439_a(x2 = x + Facing.field_71586_b[orientation] * (length + 1), y2 = y + Facing.field_71587_c[orientation] * (length + 1), z2 = z + Facing.field_71585_d[orientation] * (length + 1))) && this.isMovableBlock(block, world, x2, y2, z2)) {
            int blockMeta = world.func_72805_g(x2, y2, z2);
            int xPlus1 = x + Facing.field_71586_b[orientation];
            int yPlus1 = y + Facing.field_71587_c[orientation];
            int zPlus1 = z + Facing.field_71585_d[orientation];
            world.func_147468_f(x2, y2, z2);
            world.func_147465_d(xPlus1, yPlus1, zPlus1, (Block)Blocks.field_150326_M, blockMeta, 2);
            TileEntityMorePistons teBlock = new TileEntityMorePistons(block, blockMeta, orientation, false, true, length, false);
            world.func_147455_a(xPlus1, yPlus1, zPlus1, (TileEntity)teBlock);
        }
    }

    protected void dropMobilityFlag1(Block block, int metadata, World world, int x, int y, int z) {
        if (block != null && block != Blocks.field_150350_a && block.func_149656_h() == 1) {
            float chance = block instanceof BlockSnow ? -1.0f : 1.0f;
            block.func_149690_a(world, x, y, z, metadata, chance, 0);
            world.func_147468_f(x, y, z);
        }
    }

    protected ArrayList<EMoveInfosExtend> listBlockExtend(World world, int x, int y, int z, int orientation, int lenghtOpened) {
        int xExtension = x;
        int yExtension = y;
        int zExtension = z;
        ArrayList<EMoveInfosExtend> infosExtend = new ArrayList<EMoveInfosExtend>();
        int size = lenghtOpened;
        for (int i = 0; i < lenghtOpened + this.getMaxBlockMove() && size > 0; ++i) {
            Block block = world.func_147439_a(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation]);
            int metadata = world.func_72805_g(xExtension, yExtension, zExtension);
            this.dropMobilityFlag1(block, metadata, world, xExtension, yExtension, zExtension);
            if (GenericPistonBlock.isEmptyBlock(block)) {
                infosExtend.add(new EMoveInfosExtend());
                --size;
                continue;
            }
            if (!this.isMovableBlock(block, world, xExtension, yExtension, zExtension)) break;
            infosExtend.add(new EMoveInfosExtend(block, metadata, size));
            world.func_147468_f(xExtension, yExtension, zExtension);
        }
        return infosExtend;
    }

    protected void moveBlockExtend(ArrayList<EMoveInfosExtend> infosExtend, World world, int x, int y, int z, int orientation, int lenghtOpened) {
        int xExtension = x + Facing.field_71586_b[orientation] * lenghtOpened;
        int yExtension = y + Facing.field_71587_c[orientation] * lenghtOpened;
        int zExtension = z + Facing.field_71585_d[orientation] * lenghtOpened;
        for (EMoveInfosExtend infos : infosExtend) {
            if (infos.block == null || infos.block == Blocks.field_150350_a || infos.block == Blocks.field_150326_M) continue;
            world.func_147465_d(xExtension += Facing.field_71586_b[orientation], yExtension += Facing.field_71587_c[orientation], zExtension += Facing.field_71585_d[orientation], (Block)Blocks.field_150326_M, infos.metadata, 2);
            TileEntityMorePistons teBlock = new TileEntityMorePistons(infos.block, infos.metadata, orientation, true, false, infos.move, false);
            world.func_147455_a(xExtension, yExtension, zExtension, (TileEntity)teBlock);
        }
        xExtension = x + Facing.field_71586_b[orientation] * lenghtOpened;
        yExtension = y + Facing.field_71587_c[orientation] * lenghtOpened;
        zExtension = z + Facing.field_71585_d[orientation] * lenghtOpened;
        int metadata = orientation | (this.field_150082_a ? 8 : 0);
        world.func_147465_d(xExtension, yExtension, zExtension, (Block)Blocks.field_150326_M, orientation, 2);
        TileEntityMorePistons teExtension = new TileEntityMorePistons((Block)ModBlocks.Extension, metadata, orientation, true, false, lenghtOpened, true);
        world.func_147455_a(xExtension, yExtension, zExtension, (TileEntity)teExtension);
    }

    protected void extend(World world, int x, int y, int z, int orientation, int lenghtOpened) {
        ArrayList<EMoveInfosExtend> infosExtend = this.listBlockExtend(world, x, y, z, orientation, lenghtOpened);
        this.moveBlockExtend(infosExtend, world, x, y, z, orientation, lenghtOpened);
    }

    class EMoveInfosExtend {
        public Block block = null;
        public int metadata = 0;
        public int move = 0;
        public int x = 0;
        public int y = 0;
        public int z = 0;

        public EMoveInfosExtend() {
        }

        public EMoveInfosExtend(Block block, int metadata, int move) {
            this.block = block;
            this.metadata = metadata;
            this.move = move;
        }

        public EMoveInfosExtend(int x, int y, int z, int move) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.move = move;
        }

        public EMoveInfosExtend(Block block, int metadata, int x, int y, int z, int move) {
            this.block = block;
            this.metadata = metadata;
            this.x = x;
            this.y = y;
            this.z = z;
            this.move = move;
        }
    }
}

