/*
 * Decompiled with CFR 0.152.
 */
package ichun.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RendererHelper {
    public static boolean hasStencilBits = MinecraftForgeClient.getStencilBits() > 0;
    public static final ResourceLocation texEnchant = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static ArrayList<Framebuffer> frameBuffers = new ArrayList();

    public static void renderItemIn3d(ItemStack stack) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (textureManager == null) {
            return;
        }
        Item item = stack.func_77973_b();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int passes = item.getRenderPasses(stack.func_77960_j());
        for (int pass = 0; pass < passes; ++pass) {
            textureManager.func_110577_a(stack.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
            IIcon icon = item.getIcon(stack, pass);
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            RendererHelper.setColorFromInt(item.func_82790_a(stack, pass));
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
        if (stack.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            textureManager.func_110577_a(texEnchant);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void drawTextureOnScreen(ResourceLocation resource, double posX, double posY, double width, double height, double zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(posX, posY + height, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(posX + width, posY + height, zLevel, 1.0, 1.0);
        tessellator.func_78374_a(posX + width, posY, zLevel, 1.0, 0.0);
        tessellator.func_78374_a(posX, posY, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawColourOnScreen(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RendererHelper.drawColourOnScreen(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColourOnScreen(int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(r, g, b, alpha);
        tessellator.func_78377_a(posX, posY + height, zLevel);
        tessellator.func_78377_a(posX + width, posY + height, zLevel);
        tessellator.func_78377_a(posX + width, posY, zLevel);
        tessellator.func_78377_a(posX, posY, zLevel);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        double scaleW = (double)mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static void renderTestStencil() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso1 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, 60.0, 60.0, 0.0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, reso1.func_78327_c(), reso1.func_78324_d(), 0.0);
        GL11.glDisable((int)2960);
    }

    public static void renderTestSciccor() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso1 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        RendererHelper.startGlScissor(reso1.func_78326_a() / 2 - 50, reso1.func_78328_b() / 2 - 50, 100, 100);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-15.0f, (float)15.0f, (float)0.0f);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, reso1.func_78327_c(), reso1.func_78324_d(), 0.0);
        GL11.glPopMatrix();
        RendererHelper.endGlScissor();
    }

    public static Framebuffer createFrameBuffer(String modId, boolean useDepth) {
        Framebuffer render = new Framebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, useDepth);
        frameBuffers.add(render);
        return render;
    }

    public static void deleteFrameBuffer(Framebuffer buffer) {
        GL11.glEnable((int)2929);
        if (buffer.field_147616_f >= 0) {
            buffer.func_147608_a();
        }
        frameBuffers.remove(buffer);
    }
}

