/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import romelo333.notenoughwands.varia.Coordinate;

public class PacketReturnProtectedBlocks
implements IMessage {
    private Set<Coordinate> blocks;
    private Set<Coordinate> childBlocks;

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.blocks = new HashSet<Coordinate>(size);
        for (i = 0; i < size; ++i) {
            this.blocks.add(new Coordinate(buf.readInt(), buf.readInt(), buf.readInt()));
        }
        size = buf.readInt();
        this.childBlocks = new HashSet<Coordinate>(size);
        for (i = 0; i < size; ++i) {
            this.childBlocks.add(new Coordinate(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Coordinate block : this.blocks) {
            buf.writeInt(block.getX());
            buf.writeInt(block.getY());
            buf.writeInt(block.getZ());
        }
        buf.writeInt(this.childBlocks.size());
        for (Coordinate block : this.childBlocks) {
            buf.writeInt(block.getX());
            buf.writeInt(block.getY());
            buf.writeInt(block.getZ());
        }
    }

    public Set<Coordinate> getBlocks() {
        return this.blocks;
    }

    public Set<Coordinate> getChildBlocks() {
        return this.childBlocks;
    }

    public PacketReturnProtectedBlocks() {
    }

    public PacketReturnProtectedBlocks(Set<Coordinate> blocks, Set<Coordinate> childBlocks) {
        this.blocks = blocks;
        this.childBlocks = childBlocks;
    }
}

