/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.ForgeDirection;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private float maxHardness = 50.0f;
    private int placeDistance = 4;
    public Map<String, Double> blacklisted = new HashMap<String, Double>();

    public MovingWand() {
        this.setup("MovingWand", "movingWand").xpUsage(3).availability(AVAILABILITY_NORMAL).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_maxHardness", (double)this.maxHardness, "Max hardness this block can move.)").getDouble();
        this.placeDistance = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_placeDistance", this.placeDistance, "Distance at which to place blocks in 'in-air' mode").getInt();
        ConfigCategory category = cfg.getCategory(Config.CATEGORY_MOVINGBLACKLIST);
        if (category.isEmpty()) {
            this.blacklist(cfg, "tile.shieldBlock");
            this.blacklist(cfg, "tile.shieldBlock2");
            this.blacklist(cfg, "tile.shieldBlock3");
            this.blacklist(cfg, "tile.solidShieldBlock");
            this.blacklist(cfg, "tile.invisibleShieldBlock");
            this.setCost(cfg, "tile.mobSpawner", 5.0);
            this.setCost(cfg, "tile.blockAiry", 20.0);
        } else {
            for (Map.Entry entry : category.entrySet()) {
                this.blacklisted.put((String)entry.getKey(), ((Property)entry.getValue()).getDouble());
            }
        }
    }

    private void blacklist(Configuration cfg, String name) {
        this.setCost(cfg, name, -1.0);
    }

    private void setCost(Configuration cfg, String name, double cost) {
        cfg.get(Config.CATEGORY_MOVINGBLACKLIST, name, cost);
        this.blacklisted.put(name, cost);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (!this.hasBlock(compound)) {
            list.add(EnumChatFormatting.RED + "Wand is empty.");
        } else {
            int id = compound.func_74762_e("block");
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            int meta = compound.func_74762_e("meta");
            String name = Tools.getBlockName(block, meta);
            list.add(EnumChatFormatting.GREEN + "Block: " + name);
        }
        list.add("Right click to take a block.");
        list.add("Right click again on block to place it down.");
    }

    private boolean hasBlock(NBTTagCompound compound) {
        return compound != null && compound.func_74764_b("block");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound compound;
        if (!world.field_72995_K && this.hasBlock(compound = stack.func_77978_p())) {
            int distance;
            Vec3 end;
            Vec3 lookVec = player.func_70040_Z();
            Vec3 start = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
            MovingObjectPosition position = world.func_72933_a(start, end = start.func_72441_c(lookVec.field_72450_a * (double)(distance = this.placeDistance), lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance));
            if (position == null) {
                this.place(stack, world, (int)end.field_72450_a, (int)end.field_72448_b, (int)end.field_72449_c, ForgeDirection.UNKNOWN.ordinal());
            }
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            NBTTagCompound compound = stack.func_77978_p();
            if (this.hasBlock(compound)) {
                this.place(stack, world, x, y, z, side);
            } else {
                this.pickup(stack, player, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        return true;
    }

    private void place(ItemStack stack, World world, int x, int y, int z, int side) {
        int xx = x + ForgeDirection.getOrientation((int)side).offsetX;
        int yy = y + ForgeDirection.getOrientation((int)side).offsetY;
        int zz = z + ForgeDirection.getOrientation((int)side).offsetZ;
        NBTTagCompound tagCompound = stack.func_77978_p();
        int id = tagCompound.func_74762_e("block");
        Block block = (Block)Block.field_149771_c.func_148754_a(id);
        int meta = tagCompound.func_74762_e("meta");
        world.func_147465_d(xx, yy, zz, block, meta, 3);
        world.func_72921_c(xx, yy, zz, meta, 3);
        if (tagCompound.func_74764_b("tedata")) {
            NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("tedata");
            TileEntity tileEntity = world.func_147438_o(xx, yy, zz);
            if (tileEntity != null) {
                tc.func_74768_a("x", xx);
                tc.func_74768_a("y", yy);
                tc.func_74768_a("z", zz);
                tileEntity.func_145839_a(tc);
                tileEntity.func_70296_d();
                world.func_147471_g(xx, yy, zz);
            }
        }
        tagCompound.func_82580_o("block");
        tagCompound.func_82580_o("tedata");
        tagCompound.func_82580_o("meta");
        stack.func_77982_d(tagCompound);
    }

    private void pickup(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        double cost = MovingWand.checkPickup(player, world, x, y, z, block, this.maxHardness, this.blacklisted);
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        NBTTagCompound tagCompound = Tools.getTagCompound(stack);
        String name = Tools.getBlockName(block, meta);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            int id = Block.field_149771_c.func_148757_b((Object)block);
            tagCompound.func_74768_a("block", id);
            tagCompound.func_74768_a("meta", meta);
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                NBTTagCompound tc = new NBTTagCompound();
                tileEntity.func_145841_b(tc);
                world.func_147475_p(x, y, z);
                tc.func_82580_o("x");
                tc.func_82580_o("y");
                tc.func_82580_o("z");
                tagCompound.func_74782_a("tedata", (NBTBase)tc);
            }
            world.func_147468_f(x, y, z);
            Tools.notify(player, "You took: " + name);
            this.registerUsage(stack, player, (float)cost);
        }
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"re ", "ew ", "  w", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('w'), wandcore});
    }
}

