/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.NotEnoughWands;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.Coordinate;
import romelo333.notenoughwands.varia.Tools;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI")})
public class GenericWand
extends Item
implements IEnergyContainerItem {
    protected int needsxp = 0;
    protected int needsrf = 0;
    protected int maxrf = 0;
    protected int availability = AVAILABILITY_NORMAL;
    protected int lootRarity = 10;
    public static int AVAILABILITY_NOT = 0;
    public static int AVAILABILITY_CREATIVE = 1;
    public static int AVAILABILITY_ADVANCED = 2;
    public static int AVAILABILITY_NORMAL = 3;
    private static List<GenericWand> wands = new ArrayList<GenericWand>();

    public static double checkPickup(EntityPlayer player, World world, int x, int y, int z, Block block, float maxHardness, Map<String, Double> blacklisted) {
        float hardness = block.func_149712_f(world, x, y, z);
        if (hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        if (!block.canEntityDestroy((IBlockAccess)world, x, y, z, (Entity)player)) {
            Tools.error(player, "You are not allowed to take this block!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, x, y, z)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = 1.0;
        String unlocName = block.func_149739_a();
        if (blacklisted.containsKey(unlocName)) {
            cost = blacklisted.get(unlocName);
        }
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        if (this.needsrf > 0) {
            list.add(EnumChatFormatting.GREEN + "Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack));
        }
    }

    protected GenericWand setup(String name, String texture) {
        if (this.availability > 0) {
            this.func_77625_d(1);
            this.setNoRepair();
            this.func_77655_b(name);
            this.func_77637_a(NotEnoughWands.tabNew);
            this.func_111206_d("NotEnoughWands:" + texture);
            GameRegistry.registerItem((Item)this, (String)name);
            wands.add(this);
        }
        return this;
    }

    GenericWand xpUsage(int xp) {
        this.needsxp = xp;
        return this;
    }

    GenericWand rfUsage(int maxrf, int rf) {
        this.maxrf = maxrf;
        this.needsrf = rf;
        return this;
    }

    GenericWand durabilityUsage(int maxdurability) {
        this.func_77656_e(maxdurability);
        return this;
    }

    GenericWand loot(int rarity) {
        this.lootRarity = rarity;
        return this;
    }

    GenericWand availability(int availability) {
        this.availability = availability;
        return this;
    }

    public void initConfig(Configuration cfg) {
        this.needsxp = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
        this.needsrf = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
        this.maxrf = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
        this.func_77656_e(cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_maxdurability", this.func_77612_l(), "Maximum durability for this wand").getInt());
        this.availability = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_availability", this.availability, "Is this wand available? (0=no, 1=not craftable, 2=craftable advanced, 3=craftable normal)").getInt();
        this.lootRarity = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_lootRarity", this.lootRarity, "How rare should this wand be in chests? Lower is more rare (0 is not in chests)").getInt();
    }

    protected boolean checkUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        int experience;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.needsxp > 0 && (experience = Tools.getPlayerXP(player) - (int)((float)this.needsxp * difficultyScale)) <= 0) {
            Tools.error(player, "Not enough experience!");
            return false;
        }
        if (this.func_77645_m() && stack.func_77960_j() >= stack.func_77958_k()) {
            Tools.error(player, "This wand can no longer be used!");
            return false;
        }
        if (this.needsrf > 0 && this.getEnergyStored(stack) < (int)((float)this.needsrf * difficultyScale)) {
            Tools.error(player, "Not enough energy to use this wand!");
            return false;
        }
        return true;
    }

    protected void registerUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.needsxp > 0) {
            Tools.addPlayerXP(player, -((int)((float)this.needsxp * difficultyScale)));
        }
        if (this.func_77645_m()) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        if (this.needsrf > 0) {
            this.extractEnergy(stack, (int)((float)this.needsrf * difficultyScale), false);
        }
    }

    public void toggleMode(EntityPlayer player, ItemStack stack) {
    }

    public static void setupCrafting() {
        for (GenericWand wand : wands) {
            if (wand.availability == AVAILABILITY_NORMAL) {
                wand.setupCraftingInt(ModItems.wandCore);
                continue;
            }
            if (wand.availability != AVAILABILITY_ADVANCED) continue;
            wand.setupCraftingInt(ModItems.advancedWandCore);
        }
    }

    public static void setupConfig(Configuration cfg) {
        for (GenericWand wand : wands) {
            wand.initConfig(cfg);
        }
    }

    protected void setupCraftingInt(Item wandcore) {
    }

    public static void setupChestLoot() {
        for (GenericWand wand : wands) {
            wand.setupChestLootInt();
        }
    }

    public void setupChestLootInt() {
        if (this.lootRarity > 0 && this.availability > 0) {
            this.setupChestLootInt("dungeonChest");
            this.setupChestLootInt("mineshaftCorridor");
            this.setupChestLootInt("pyramidDesertyChest");
            this.setupChestLootInt("pyramidJungleChest");
            this.setupChestLootInt("strongholdCorridor");
            this.setupChestLootInt("villageBlacksmith");
        }
    }

    private void setupChestLootInt(String category) {
        ChestGenHooks chest = ChestGenHooks.getInfo((String)category);
        chest.addItem(new WeightedRandomChestContent((Item)this, 0, 1, 1, this.lootRarity));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityClientPlayerMP player, ItemStack wand) {
    }

    protected static void renderOutlines(RenderWorldLastEvent evt, EntityClientPlayerMP p, Set<Coordinate> coordinates, int r, int g, int b) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.partialTicks;
        GL11.glPushAttrib((int)270657);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GenericWand.renderOutlines(coordinates, r, g, b, 4);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private static void renderOutlines(Set<Coordinate> coordinates, int r, int g, int b, int thickness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(1);
        tessellator.func_78376_a(r, g, b);
        tessellator.func_78380_c(240);
        GL11.glColor3ub((byte)((byte)r), (byte)((byte)g), (byte)((byte)b));
        GL11.glLineWidth((float)thickness);
        for (Coordinate coordinate : coordinates) {
            float x = coordinate.getX();
            float y = coordinate.getY();
            float z = coordinate.getZ();
            GenericWand.renderBlockOutline(tessellator, x, y, z, 0.0f);
        }
        tessellator.func_78381_a();
    }

    private static void renderBlockOutline(Tessellator tessellator, float mx, float my, float mz, float o) {
        tessellator.func_78377_a((double)(mx - o), (double)(my - o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my - o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx - o), (double)(my - o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx - o), (double)(my + 1.0f + o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx - o), (double)(my - o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx - o), (double)(my - o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx - o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my - o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx - o), (double)(my + 1.0f + o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx - o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx - o), (double)(my + 1.0f + o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my - o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my - o), (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my - o), (double)(mz - o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz - o));
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)(mx + 1.0f + o), (double)my, (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f + o));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f + o), (double)(mz + 1.0f + o));
    }

    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.needsrf, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.maxrf - energy, Math.min(this.maxrf, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxrf;
    }
}

