/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.varia.Coordinate;
import romelo333.notenoughwands.varia.Tools;

public class DisplacementWand
extends GenericWand {
    private float maxHardness = 50.0f;
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] descriptions = new String[]{"3x3", "5x5", "7x7", "single"};
    public static final int[] amount = new int[]{9, 9, 25, 1};

    public DisplacementWand() {
        this.setup("DisplacementWand", "displacementWand").xpUsage(4).availability(AVAILABILITY_NORMAL).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_maxHardness", (double)this.maxHardness, "Max hardness this block can move.)").getDouble();
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(EnumChatFormatting.GREEN + "Mode: " + descriptions[this.getMode(stack)]);
        list.add("Right click to push blocks forward.");
        list.add("Sneak right click to pull blocks.");
        list.add("Mode key (default '=') to switch mode.");
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.pullBlocks(stack, player, world, x, y, z, side);
            } else {
                this.pushBlocks(stack, player, world, x, y, z, side);
            }
            return true;
        }
        return false;
    }

    private void pullBlocks(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        ForgeDirection direction;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<Coordinate> coordinates = this.findSuitableBlocks(stack, world, side, x, y, z);
        int cnt = this.moveBlocks(player, world, coordinates, direction = ForgeDirection.getOrientation((int)side));
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private void pushBlocks(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        ForgeDirection direction;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<Coordinate> coordinates = this.findSuitableBlocks(stack, world, side, x, y, z);
        int cnt = this.moveBlocks(player, world, coordinates, direction = ForgeDirection.getOrientation((int)side).getOpposite());
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private int moveBlocks(EntityPlayer player, World world, Set<Coordinate> coordinates, ForgeDirection direction) {
        int cnt = 0;
        for (Coordinate coordinate : coordinates) {
            double cost;
            int xx = coordinate.getX();
            int yy = coordinate.getY();
            int zz = coordinate.getZ();
            Block block = world.func_147439_a(xx, yy, zz);
            Coordinate otherC = coordinate.add(direction);
            Block otherBlock = world.func_147439_a(otherC.getX(), otherC.getY(), otherC.getZ());
            if (!otherBlock.isReplaceable((IBlockAccess)world, otherC.getX(), otherC.getY(), otherC.getZ()) || !((cost = GenericWand.checkPickup(player, world, xx, yy, zz, block, this.maxHardness, ModItems.movingWand.blacklisted)) >= 0.0)) continue;
            ++cnt;
            int meta = world.func_72805_g(xx, yy, zz);
            Tools.playSound(world, block.field_149762_H.func_150495_a(), coordinate.getX(), coordinate.getY(), coordinate.getZ(), 1.0, 1.0);
            TileEntity tileEntity = world.func_147438_o(xx, yy, zz);
            NBTTagCompound tc = null;
            if (tileEntity != null) {
                tc = new NBTTagCompound();
                tileEntity.func_145841_b(tc);
                world.func_147475_p(xx, yy, zz);
            }
            world.func_147468_f(xx, yy, zz);
            xx = otherC.getX();
            yy = otherC.getY();
            zz = otherC.getZ();
            world.func_147465_d(xx, yy, zz, block, meta, 3);
            world.func_72921_c(xx, yy, zz, meta, 3);
            if (tc == null || (tileEntity = world.func_147438_o(xx, yy, zz)) == null) continue;
            tc.func_74768_a("x", xx);
            tc.func_74768_a("y", yy);
            tc.func_74768_a("z", zz);
            tileEntity.func_145839_a(tc);
            tileEntity.func_70296_d();
            world.func_147471_g(xx, yy, zz);
        }
        return cnt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityClientPlayerMP player, ItemStack wand) {
        int z;
        int y;
        int x;
        World world;
        Block block;
        MovingObjectPosition mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && (block = (world = player.field_70170_p).func_147439_a(x = mouseOver.field_72311_b, y = mouseOver.field_72312_c, z = mouseOver.field_72309_d)) != null && block.func_149688_o() != Material.field_151579_a) {
            Set<Coordinate> coordinates = this.findSuitableBlocks(wand, world, mouseOver.field_72310_e, x, y, z);
            DisplacementWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
        }
    }

    private Set<Coordinate> findSuitableBlocks(ItemStack stack, World world, int sideHit, int x, int y, int z) {
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(new Coordinate(x, y, z));
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        switch (ForgeDirection.getOrientation((int)sideHit)) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(World world, int x, int y, int z, Set<Coordinate> coordinates) {
        if (!world.func_147437_c(x, y, z)) {
            coordinates.add(new Coordinate(x, y, z));
        }
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"eb ", "bw ", "  w", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('w'), wandcore});
    }
}

