/*
 * Decompiled with CFR 0.152.
 */
package Nanashi.AdvancedTools.item;

import Nanashi.AdvancedTools.AdvancedTools;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ItemUGTool
extends ItemTool {
    public String BaseName;
    protected int cDestroyRange;
    private int[] rangeArray = new int[]{2, 4, 7, 9, 9};
    private int saftyCount;
    private int breakcount;
    public int side;

    protected ItemUGTool(int var2, Item.ToolMaterial var3, Set var4, float var5) {
        super((float)var2, var3, var4);
        this.cDestroyRange = AdvancedTools.UGTools_SafetyCounter;
        this.saftyCount = AdvancedTools.UGTools_SafetyCounter;
        this.func_77656_e((int)(var5 * (float)this.func_77612_l()));
    }

    public abstract boolean doChainDestruction(Block var1, int var2);

    public abstract boolean isProperTool(Block var1, int var2);

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.getRange(par1ItemStack);
    }

    public Item func_77655_b(String var1) {
        super.func_77655_b(var1);
        if (this.BaseName == null) {
            this.BaseName = var1;
        }
        return this;
    }

    public boolean func_150894_a(ItemStack item, World world, Block block, int x, int y, int z, EntityLivingBase breaker) {
        if (!world.field_72995_K) {
            item.func_77972_a(1, breaker);
            this.breakcount = 0;
            int range = this.getRange(item);
            int meta = world.func_72805_g(x, y, z);
            if (range != 0 && breaker instanceof EntityPlayer && ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)((EntityPlayer)breaker), (int)meta)) {
                this.destroyAroundBlock(item, world, block, meta, x, y, z, (EntityPlayer)breaker, range);
                item.func_77972_a(this.breakcount, breaker);
            }
            return true;
        }
        return false;
    }

    private boolean destroyAroundBlock(ItemStack var1, World world, Block block, int meta, int x, int y, int z, EntityPlayer var6, int range) {
        this.searchAndDestroyBlock(world, x, y, z, this.side, block, meta, var1, var6, range);
        return true;
    }

    protected void searchAndDestroyBlock(World world, int x, int y, int z, int side, Block block, int meta, ItemStack var6, EntityPlayer var7, int range) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        ArrayList<Object> var8 = new ArrayList<Object>();
        var8.add(new ChunkPosition(x, y, z));
        if (!this.doChainDestruction(block, meta)) {
            minX = x - range;
            minY = y - range;
            minZ = z - range;
            maxX = x + range;
            maxY = y + range;
            maxZ = z + range;
            if (side == 0 || side == 1) {
                minY = y;
                maxY = y;
            }
            if (side == 2 || side == 3) {
                minZ = z;
                maxZ = z;
                minY += range - AdvancedTools.digUnder;
                maxY += range - AdvancedTools.digUnder;
            }
            if (side == 4 || side == 5) {
                minX = x;
                maxX = x;
                minY += range - AdvancedTools.digUnder;
                maxY += range - AdvancedTools.digUnder;
            }
        } else {
            minX = x - this.cDestroyRange;
            minY = y - this.cDestroyRange;
            minZ = z - this.cDestroyRange;
            maxX = x + this.cDestroyRange;
            maxY = y + this.cDestroyRange;
            maxZ = z + this.cDestroyRange;
        }
        ChunkPosition minChunkPos = new ChunkPosition(minX, minY, minZ);
        ChunkPosition maxChunkPos = new ChunkPosition(maxX, maxY, maxZ);
        for (int var17 = 0; var17 < this.saftyCount; ++var17) {
            ArrayList<ChunkPosition> var18 = new ArrayList<ChunkPosition>();
            for (ChunkPosition chunkPosition : var8) {
                var18.addAll(this.searchAroundBlock(world, chunkPosition, minChunkPos, maxChunkPos, block, var6, var7));
            }
            if (var18.isEmpty()) break;
            var8.clear();
            var8.addAll(var18);
        }
    }

    protected ArrayList<ChunkPosition> searchAroundBlock(World world, ChunkPosition var1, ChunkPosition minChunkPos, ChunkPosition maxChunkPos, Block var4, ItemStack var5, EntityPlayer var6) {
        ArrayList<ChunkPosition> var7 = new ArrayList<ChunkPosition>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            ChunkPosition chunkpos;
            int directionIndex = direction.ordinal();
            if (!this.checkBlockPositionInRange(var1, minChunkPos, maxChunkPos, directionIndex) || !this.destroyBlock(world, chunkpos = new ChunkPosition(var1.field_151329_a + direction.offsetX, var1.field_151327_b + direction.offsetY, var1.field_151328_c + direction.offsetZ), var4, var5, var6)) continue;
            var7.add(chunkpos);
        }
        return var7;
    }

    public boolean checkBlockPositionInRange(ChunkPosition check, ChunkPosition min, ChunkPosition max, int index) {
        switch (index) {
            case 0: {
                return check.field_151327_b > min.field_151327_b;
            }
            case 1: {
                return check.field_151327_b < max.field_151327_b;
            }
            case 2: {
                return check.field_151328_c > min.field_151328_c;
            }
            case 3: {
                return check.field_151328_c < max.field_151328_c;
            }
            case 4: {
                return check.field_151329_a > min.field_151329_a;
            }
            case 5: {
                return check.field_151329_a < max.field_151329_a;
            }
        }
        return false;
    }

    protected boolean destroyBlock(World world, ChunkPosition var1, Block block, ItemStack var3, EntityPlayer var4) {
        Block var5 = world.func_147439_a(var1.field_151329_a, var1.field_151327_b, var1.field_151328_c);
        if (var5 == Blocks.field_150350_a) {
            return false;
        }
        List<Block> rsList = Arrays.asList(Blocks.field_150450_ax, Blocks.field_150439_ay);
        List<Block> dirtList = Arrays.asList(Blocks.field_150346_d, Blocks.field_150349_c);
        if (rsList.contains(block) && !rsList.contains(var5)) {
            return false;
        }
        if (dirtList.contains(block) && !dirtList.contains(var5)) {
            return false;
        }
        if (!rsList.contains(block) && !dirtList.contains(block) && var5 != block) {
            return false;
        }
        return this.checkAndDestroy(world, var1, var5, var3, var4);
    }

    private boolean checkAndDestroy(World world, ChunkPosition var1, Block var2, ItemStack var3, EntityPlayer var4) {
        int var5 = world.func_72805_g(var1.field_151329_a, var1.field_151327_b, var1.field_151328_c);
        var2.func_149681_a(world, var1.field_151329_a, var1.field_151327_b, var1.field_151328_c, var5, var4);
        if (var2.removedByPlayer(world, var4, var1.field_151329_a, var1.field_151327_b, var1.field_151328_c, true)) {
            var2.func_149664_b(world, var1.field_151329_a, var1.field_151327_b, var1.field_151328_c, var5);
            if (AdvancedTools.dropGather) {
                var2.func_149636_a(world, var4, MathHelper.func_76143_f((double)var4.field_70165_t), MathHelper.func_76143_f((double)var4.field_70163_u), MathHelper.func_76143_f((double)var4.field_70161_v), var5);
            } else {
                var2.func_149636_a(world, var4, var1.field_151329_a, var1.field_151327_b, var1.field_151328_c, var5);
            }
            if (!this.isSilkTouch(var3)) {
                int exp = var2.getExpDrop((IBlockAccess)world, var5, EnchantmentHelper.func_77517_e((EntityLivingBase)var4));
                var2.func_149657_c(world, MathHelper.func_76143_f((double)var4.field_70165_t), MathHelper.func_76143_f((double)var4.field_70163_u), MathHelper.func_76143_f((double)var4.field_70161_v), exp);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)var3) <= 0) {
                ++this.breakcount;
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack var1, World var2, EntityPlayer var3) {
        if (!var2.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)var3;
            int range = this.setRange(var1, var3);
            String chat = range == 0 ? this.BaseName + " will harvest only one." : this.BaseName + "'s range was changed to " + (range * 2 + 1) + "x" + (range * 2 + 1);
            player.func_145747_a((IChatComponent)new ChatComponentText(chat));
        }
        return var1;
    }

    private int setRange(ItemStack var1, EntityPlayer var3) {
        int range = this.getRange(var1);
        int toolMaterialOrd = this.field_77862_b.ordinal();
        range = !var3.func_70093_af() ? (range + 1) % (this.rangeArray[toolMaterialOrd] + 1) : (this.rangeArray[toolMaterialOrd] + 1 + range - 1) % (this.rangeArray[toolMaterialOrd] + 1);
        var1.func_77978_p().func_74768_a("range", range);
        return range;
    }

    private int getRange(ItemStack item) {
        int range;
        NBTTagCompound nbt;
        if (!item.func_77942_o()) {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        if ((nbt = item.func_77978_p()).func_74764_b("range")) {
            range = item.func_77978_p().func_74762_e("range");
        } else {
            range = AdvancedTools.UGTools_DestroyRangeLV;
            nbt.func_74768_a("range", range);
        }
        return range;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List par3List, boolean par4) {
        super.func_77624_a(item, player, par3List, par4);
        int range = this.getRange(item);
        if (range == 0) {
            par3List.add("Range: Only one");
        } else {
            par3List.add("Range: " + (range * 2 + 1) + "x" + (range * 2 + 1));
        }
    }

    public boolean checkArrays(Block block, String[] blockList) {
        String uIdName = AdvancedTools.getUniqueStrings(block);
        return Arrays.asList(blockList).contains(uIdName);
    }

    public boolean isSilkTouch(ItemStack itemStack) {
        return itemStack.func_77948_v() && EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)itemStack) > 0;
    }
}

