/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartRenderHelper;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartBasicState
extends AEBasePart
implements IPowerChannelState {
    protected final int POWERED_FLAG = 1;
    protected final int CHANNEL_FLAG = 2;
    protected int clientFlags = 0;

    public PartBasicState(ItemStack is) {
        super(is);
        this.proxy.setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderLights(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.normalRendering();
        this.setColors((this.clientFlags & (this.POWERED_FLAG | this.CHANNEL_FLAG)) == (this.POWERED_FLAG | this.CHANNEL_FLAG), (this.clientFlags & this.POWERED_FLAG) == this.POWERED_FLAG);
        rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.EAST, renderer);
        rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.WEST, renderer);
        rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.UP, renderer);
        rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.DOWN, renderer);
    }

    public void setColors(boolean hasChan, boolean hasPower) {
        if (hasChan) {
            int l = 14;
            Tessellator.field_78398_a.func_78380_c(l << 20 | l << 4);
            Tessellator.field_78398_a.func_78378_d(this.getColor().blackVariant);
        } else if (hasPower) {
            int l = 9;
            Tessellator.field_78398_a.func_78380_c(l << 20 | l << 4);
            Tessellator.field_78398_a.func_78378_d(this.getColor().whiteVariant);
        } else {
            Tessellator.field_78398_a.func_78380_c(0);
            Tessellator.field_78398_a.func_78378_d(0);
        }
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.clientFlags = 0;
        try {
            if (this.proxy.getEnergy().isNetworkPowered()) {
                this.clientFlags |= this.POWERED_FLAG;
            }
            if (this.proxy.getNode().meetsChannelRequirements()) {
                this.clientFlags |= this.CHANNEL_FLAG;
            }
            this.clientFlags = this.populateFlags(this.clientFlags);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.clientFlags));
    }

    protected int populateFlags(int cf) {
        return cf;
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean eh = super.readFromStream(data);
        int old = this.clientFlags;
        this.clientFlags = data.readByte();
        return eh || old != this.clientFlags;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingTexture() {
        return CableBusTextures.PartTransitionPlaneBack.getIcon();
    }

    @Override
    public boolean isPowered() {
        return (this.clientFlags & this.POWERED_FLAG) == this.POWERED_FLAG;
    }

    @Override
    public boolean isActive() {
        return (this.clientFlags & this.CHANNEL_FLAG) == this.CHANNEL_FLAG;
    }
}

