/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.networking.IGridHost;
import appeng.api.util.DimensionalCoord;
import appeng.me.cluster.IAECluster;
import appeng.tile.spatial.TileSpatialPylon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpatialPylonCluster
implements IAECluster {
    public final DimensionalCoord min;
    public final DimensionalCoord max;
    final List<TileSpatialPylon> line = new ArrayList<TileSpatialPylon>();
    public boolean isDestroyed = false;
    public Axis currentAxis = Axis.UNFORMED;
    public boolean isValid;
    public boolean hasPower;
    public boolean hasChannel;

    public SpatialPylonCluster(DimensionalCoord _min, DimensionalCoord _max) {
        this.min = _min.copy();
        this.max = _max.copy();
        this.currentAxis = this.min.x != this.max.x ? Axis.X : (this.min.y != this.max.y ? Axis.Y : (this.min.z != this.max.z ? Axis.Z : Axis.UNFORMED));
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (TileSpatialPylon r : this.line) {
            r.recalculateDisplay();
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        for (TileSpatialPylon r : this.line) {
            r.updateStatus(null);
        }
    }

    @Override
    public Iterator<IGridHost> getTiles() {
        return this.line.iterator();
    }

    public int tileCount() {
        return this.line.size();
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNFORMED;

    }
}

