/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialattack;

import java.util.EnumSet;
import java.util.List;
import mods.flammpfeil.slashblade.EntityDrive;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.ability.UntouchableTime;
import mods.flammpfeil.slashblade.entity.EntityJudgmentCutManager;
import mods.flammpfeil.slashblade.entity.EntitySlashDimension;
import mods.flammpfeil.slashblade.specialattack.IJustSpecialAttack;
import mods.flammpfeil.slashblade.specialattack.ISuperSpecialAttack;
import mods.flammpfeil.slashblade.specialattack.SpecialAttackBase;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SlashDimension
extends SpecialAttackBase
implements IJustSpecialAttack,
ISuperSpecialAttack {
    @Override
    public String toString() {
        return "slashdimension";
    }

    @Override
    public void doSpacialAttack(ItemStack stack, EntityPlayer player) {
        Entity tmp;
        World world = player.field_70170_p;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        Entity target = null;
        int entityId = ItemSlashBlade.TargetEntityId.get(tag);
        if (entityId != 0 && (tmp = world.func_73045_a(entityId)) != null && tmp.func_70032_d((Entity)player) < 30.0f) {
            target = tmp;
        }
        if (target == null) {
            target = this.getEntityToWatch(player);
        }
        if (target == null) {
            ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.SlashDim);
            player.func_85030_a("mob.endermen.portal", 0.5f, 1.0f);
            int cost = -20;
            if (!ItemSlashBlade.ProudSoul.tryAdd(tag, -20, false)) {
                ItemSlashBlade.damageItem(stack, 10, (EntityLivingBase)player);
            }
            if (!player.field_70170_p.field_72995_K) {
                int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
                float magicDamage = 1.0f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * (0.5f + (float)level / 5.0f);
                EntitySlashDimension dim = new EntitySlashDimension(world, (EntityLivingBase)player, magicDamage);
                if (dim != null) {
                    Vec3 tmppos;
                    Block block;
                    Vec3 pos = player.func_70040_Z();
                    float scale = 5.0f;
                    pos.field_72450_a *= (double)scale;
                    pos.field_72448_b *= (double)scale;
                    pos.field_72449_c *= (double)scale;
                    pos = pos.func_72441_c(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    pos = pos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                    Vec3 offset = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                    Vec3 look = player.func_70040_Z();
                    Vec3 offsettedLook = offset.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
                    MovingObjectPosition movingobjectposition = world.func_72933_a(offset, offsettedLook);
                    if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = world.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d)) != null && block.func_149703_v() && 1.0 < (tmppos = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c)).func_72438_d(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) {
                        pos = tmppos;
                    }
                    dim.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    dim.setLifeTime(10);
                    dim.setIsSlashDimension(true);
                    world.func_72838_d((Entity)dim);
                }
            }
        } else {
            ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.SlashDim);
            this.spawnParticle(world, target);
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.endermen.portal", 0.5f, 1.0f);
            int cost = -20;
            if (!ItemSlashBlade.ProudSoul.tryAdd(tag, -20, false)) {
                ItemSlashBlade.damageItem(stack, 10, (EntityLivingBase)player);
            }
            AxisAlignedBB bb = target.field_70121_D.func_72329_c();
            bb = bb.func_72314_b(2.0, 0.25, 2.0);
            List list = world.func_94576_a((Entity)player, bb, ItemSlashBlade.AttackableSelector);
            if (!ItemSlashBlade.AttackableSelector.func_82704_a(target)) {
                list.add(target);
            }
            ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
            for (Entity curEntity : list) {
                StylishRankManager.setNextAttackType((Entity)player, StylishRankManager.AttackTypes.SlashDim);
                blade.attackTargetEntity(stack, curEntity, player, true);
            }
            if (!target.field_70170_p.field_72995_K) {
                int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
                float magicDamage = 0.5f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * ((float)level / 5.0f);
                EntitySlashDimension dim = new EntitySlashDimension(world, (EntityLivingBase)player, magicDamage);
                if (dim != null) {
                    dim.func_70107_b(target.field_70165_t, target.field_70163_u + (double)target.field_70131_O / 2.0, target.field_70161_v);
                    dim.setLifeTime(10);
                    world.func_72838_d((Entity)dim);
                }
            }
        }
    }

    private Entity getEntityToWatch(EntityPlayer player) {
        World world = player.field_70170_p;
        Entity target = null;
        for (int dist = 2; dist < 20; dist += 2) {
            AxisAlignedBB bb = player.field_70121_D.func_72329_c();
            Vec3 vec = player.func_70040_Z();
            vec = vec.func_72432_b();
            bb = bb.func_72314_b(2.0, 0.25, 2.0);
            bb = bb.func_72317_d(vec.field_72450_a * (double)dist, vec.field_72448_b * (double)dist, vec.field_72449_c * (double)dist);
            List list = world.func_94576_a((Entity)player, bb, ItemSlashBlade.AttackableSelector);
            float distance = 30.0f;
            for (Entity curEntity : list) {
                float curDist = curEntity.func_70032_d((Entity)player);
                if (!(curDist < distance)) continue;
                target = curEntity;
                distance = curDist;
            }
            if (target != null) break;
        }
        return target;
    }

    private void spawnParticle(World world, Entity target) {
        world.func_72869_a("largeexplode", target.field_70165_t, target.field_70163_u + (double)target.field_70131_O, target.field_70161_v, 3.0, 3.0, 3.0);
        world.func_72869_a("largeexplode", target.field_70165_t + 1.0, target.field_70163_u + (double)target.field_70131_O + 1.0, target.field_70161_v, 3.0, 3.0, 3.0);
        world.func_72869_a("largeexplode", target.field_70165_t, target.field_70163_u + (double)target.field_70131_O + 0.5, target.field_70161_v + 1.0, 3.0, 3.0, 3.0);
    }

    @Override
    public void doJustSpacialAttack(ItemStack stack, EntityPlayer player) {
        Entity tmp;
        World world = player.field_70170_p;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        Entity target = null;
        int entityId = ItemSlashBlade.TargetEntityId.get(tag);
        if (entityId != 0 && (tmp = world.func_73045_a(entityId)) != null && tmp.func_70032_d((Entity)player) < 30.0f) {
            target = tmp;
        }
        if (target == null) {
            target = this.getEntityToWatch(player);
        }
        if (target == null) {
            ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.SlashDim);
            player.func_85030_a("mob.endermen.portal", 0.5f, 1.0f);
            int cost = -20;
            if (!ItemSlashBlade.ProudSoul.tryAdd(tag, -20, false)) {
                ItemSlashBlade.damageItem(stack, 10, (EntityLivingBase)player);
            }
            if (!player.field_70170_p.field_72995_K) {
                Vec3 tmppos;
                Block block;
                Vec3 pos = player.func_70040_Z();
                float scale = 5.0f;
                pos.field_72450_a *= (double)scale;
                pos.field_72448_b *= (double)scale;
                pos.field_72449_c *= (double)scale;
                pos = pos.func_72441_c(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                pos = pos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
                Vec3 offset = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                Vec3 look = player.func_70040_Z();
                Vec3 offsettedLook = offset.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
                MovingObjectPosition movingobjectposition = world.func_72933_a(offset, offsettedLook);
                if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = world.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d)) != null && block.func_149703_v() && 1.0 < (tmppos = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c)).func_72438_d(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) {
                    pos = tmppos;
                }
                int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
                float magicDamage = 1.0f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * (0.5f + (float)level / 5.0f);
                EntitySlashDimension dim = new EntitySlashDimension(world, (EntityLivingBase)player, magicDamage);
                if (dim != null) {
                    dim.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    dim.setLifeTime(10);
                    dim.setIsSlashDimension(true);
                    world.func_72838_d((Entity)dim);
                }
                magicDamage = 1.0f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * ((float)level / 5.0f);
                for (int i = 0; i < 5; ++i) {
                    EntityDrive entityDrive = new EntityDrive(world, (EntityLivingBase)player, Math.min(1.0f, magicDamage / 3.0f), false, 0.0f);
                    float rotationYaw = (float)(60 * i) + (entityDrive.getRand().nextFloat() - 0.5f) * 60.0f;
                    float rotationPitch = (entityDrive.getRand().nextFloat() - 0.5f) * 60.0f;
                    float fYawDtoR = rotationYaw / 180.0f * (float)Math.PI;
                    float fPitDtoR = rotationPitch / 180.0f * (float)Math.PI;
                    float fYVecOfst = 0.5f;
                    float motionX = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst * 2.0f;
                    float motionY = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
                    float motionZ = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst * 2.0f;
                    entityDrive.func_70012_b(pos.field_72450_a - (double)motionX, pos.field_72448_b - (double)motionY, pos.field_72449_c - (double)motionZ, rotationYaw, rotationPitch);
                    entityDrive.setDriveVector(fYVecOfst);
                    entityDrive.setLifeTime(8);
                    entityDrive.setIsMultiHit(false);
                    int rank = StylishRankManager.getStylishRank((Entity)player);
                    if (5 <= rank) {
                        EnumSet<ItemSlashBlade.SwordType> type = blade.getSwordType(stack);
                        entityDrive.setIsSlashDimension(type.contains((Object)ItemSlashBlade.SwordType.FiercerEdge));
                    }
                    entityDrive.setRoll(90.0f + 120.0f * (entityDrive.getRand().nextFloat() - 0.5f));
                    if (entityDrive == null) continue;
                    world.func_72838_d((Entity)entityDrive);
                }
            }
        } else {
            EntitySlashDimension dim;
            ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.SlashDim);
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.endermen.portal", 0.5f, 1.0f);
            int cost = -20;
            if (!ItemSlashBlade.ProudSoul.tryAdd(tag, -20, false)) {
                ItemSlashBlade.damageItem(stack, 10, (EntityLivingBase)player);
            }
            AxisAlignedBB bb = target.field_70121_D.func_72329_c();
            bb = bb.func_72314_b(2.0, 0.25, 2.0);
            List list = world.func_94576_a((Entity)player, bb, ItemSlashBlade.AttackableSelector);
            if (!ItemSlashBlade.AttackableSelector.func_82704_a(target)) {
                list.add(target);
            }
            ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
            for (Entity curEntity : list) {
                StylishRankManager.setNextAttackType((Entity)player, StylishRankManager.AttackTypes.SlashDim);
                blade.attackTargetEntity(stack, curEntity, player, true);
                player.func_71047_c(curEntity);
            }
            int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
            float magicDamage = 1.0f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * ((float)level / 5.0f);
            if (0 < level) {
                for (int i = 0; i < 5; ++i) {
                    EntityDrive entityDrive = new EntityDrive(world, (EntityLivingBase)player, Math.min(1.0f, magicDamage / 3.0f), false, 0.0f);
                    float rotationYaw = target.field_70177_z + (float)(60 * i) + (entityDrive.getRand().nextFloat() - 0.5f) * 60.0f;
                    float rotationPitch = (entityDrive.getRand().nextFloat() - 0.5f) * 60.0f;
                    float fYawDtoR = rotationYaw / 180.0f * (float)Math.PI;
                    float fPitDtoR = rotationPitch / 180.0f * (float)Math.PI;
                    float fYVecOfst = 0.5f;
                    float motionX = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst * 2.0f;
                    float motionY = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
                    float motionZ = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst * 2.0f;
                    entityDrive.func_70012_b(target.field_70165_t - (double)motionX, target.field_70163_u + (double)target.func_70047_e() / 2.0 - (double)motionY, target.field_70161_v - (double)motionZ, rotationYaw, rotationPitch);
                    entityDrive.setDriveVector(fYVecOfst);
                    entityDrive.setLifeTime(8);
                    entityDrive.setIsMultiHit(false);
                    int rank = StylishRankManager.getStylishRank((Entity)player);
                    if (5 <= rank) {
                        EnumSet<ItemSlashBlade.SwordType> type = blade.getSwordType(stack);
                        entityDrive.setIsSlashDimension(type.contains((Object)ItemSlashBlade.SwordType.FiercerEdge));
                    }
                    entityDrive.setRoll(90.0f + 120.0f * (entityDrive.getRand().nextFloat() - 0.5f));
                    if (entityDrive == null) continue;
                    world.func_72838_d((Entity)entityDrive);
                }
            }
            if (!target.field_70170_p.field_72995_K && (dim = new EntitySlashDimension(world, (EntityLivingBase)player, magicDamage)) != null) {
                dim.func_70107_b(target.field_70165_t, target.field_70163_u + (double)target.field_70131_O / 2.0, target.field_70161_v);
                dim.setLifeTime(10);
                dim.setIsSlashDimension(true);
                world.func_72838_d((Entity)dim);
            }
        }
    }

    @Override
    public void doSuperSpecialAttack(ItemStack stack, EntityPlayer player) {
        EntityJudgmentCutManager entityDA = new EntityJudgmentCutManager(player.field_70170_p, (EntityLivingBase)player);
        if (entityDA != null) {
            player.field_70170_p.func_72838_d((Entity)entityDA);
        }
        UntouchableTime.setUntouchableTime((Entity)player, 30, true);
    }
}

