/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.entity.EntityEx;
import mods.flammpfeil.slashblade.entity.EntityGrimGrip;
import mods.flammpfeil.slashblade.util.BlockPos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityGrimGripKey
extends EntityEx {
    EntityGrimGrip grip = null;
    int interval = 0;
    public int active = 0;
    private static final int LIFETIME = 7;
    private static final int GRIM_GRIP_POS = 8;
    private static final int INVISIBLE = 9;

    public EntityGrimGripKey(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(7, (Object)60);
        this.func_70096_w().func_75682_a(8, (Object)"");
        this.func_70096_w().func_75682_a(9, (Object)0);
    }

    public int getLifeTime() {
        return this.func_70096_w().func_75679_c(7);
    }

    public void setLifeTime(int lifetime) {
        this.func_70096_w().func_75692_b(7, (Object)lifetime);
    }

    public void setGrimGripPos(@Nullable BlockPos grimGripPos) {
        this.func_70096_w().func_75692_b(8, (Object)(grimGripPos == null ? "" : grimGripPos.toString()));
    }

    public BlockPos getGrimGripPos() {
        String str = this.func_70096_w().func_75681_e(8);
        BlockPos result = null;
        if (str != null && str.length() != 0) {
            try {
                str = str.substring(1, str.length() - 1);
                String[] strs = str.split(",");
                result = new BlockPos(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]), Integer.parseInt(strs[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        }
        return result;
    }

    public boolean isHide() {
        return this.func_70096_w().func_75683_a(9) != 0;
    }

    public void setHide(boolean hide) {
        this.func_70096_w().func_75692_b(9, (Object)(hide ? 1 : 0));
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("GPX")) {
            int i = compound.func_74762_e("GPX");
            int j = compound.func_74762_e("GPY");
            int k = compound.func_74762_e("GPZ");
            this.setGrimGripPos(new BlockPos(i, j, k));
        } else {
            this.setGrimGripPos(null);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        BlockPos blockpos = this.getGrimGripPos();
        if (blockpos != null) {
            compound.func_74768_a("GPX", blockpos.getX());
            compound.func_74768_a("GPY", blockpos.getY());
            compound.func_74768_a("GPZ", blockpos.getZ());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (0 < this.interval) {
            --this.interval;
        }
        if (0 < this.active) {
            --this.active;
        }
        if (this.grip != null && !this.grip.func_70089_S()) {
            this.removeGrip();
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70694_bm() == null && entityIn.func_70093_af() && !entityIn.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return true;
        }
        return super.func_85031_j(entityIn);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        this.summonGrimGrip((Entity)entityIn);
    }

    private void summonGrimGrip(Entity entityIn) {
        NBTTagCompound tag;
        ItemStack stack;
        this.active = 60;
        if (this.grip != null) {
            if (this.grip.func_70089_S()) {
                this.grip.field_70173_aa = 0;
            } else {
                this.removeGrip();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.grip == null && this.interval <= 0) {
            EntityGrimGrip newGrip = new EntityGrimGrip(this.field_70170_p);
            BlockPos pos = this.getGrimGripPos();
            newGrip.func_70080_a((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, newGrip.field_70177_z, newGrip.field_70125_A);
            newGrip.setLifeTime(this.getLifeTime());
            newGrip.field_70173_aa = 0;
            newGrip.setGlowing(true);
            if (this.field_70170_p.func_72838_d((Entity)newGrip)) {
                this.grip = newGrip;
            }
        }
        if (this.grip != null && entityIn instanceof EntityLivingBase && 0 < (entityIn.getEntityData().func_74771_c("SB.MCS") & 0x10) && (stack = ((EntityLivingBase)entityIn).func_70694_bm()) != null && stack.func_77973_b() instanceof ItemSlashBlade && ItemSlashBlade.TargetEntityId.get(tag = ItemSlashBlade.getItemTagCompound(stack)).intValue() != this.grip.func_145782_y()) {
            ItemSlashBlade.TargetEntityId.set(tag, this.grip.func_145782_y());
        }
    }

    private void removeGrip() {
        this.grip = null;
        this.interval = 10;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return this.active <= 0;
    }
}

