/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.IThrowableEntity;
import java.util.List;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.entity.EntityPhantomSwordBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;

public class ProjectileBarrier {
    public static boolean isAvailable(EntityLivingBase owner, ItemStack stack, int duration) {
        if (owner == null) {
            return false;
        }
        if (owner.func_70694_bm() == null) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return false;
        }
        if (!stack.func_77948_v()) {
            return false;
        }
        if (!owner.field_70122_E) {
            return false;
        }
        if (!owner.func_70093_af()) {
            return false;
        }
        if (!(owner instanceof EntityPlayer)) {
            return false;
        }
        if (!((EntityPlayer)owner).func_71039_bw()) {
            return false;
        }
        int ticks = stack.func_77988_m() - duration;
        if (ticks < ItemSlashBlade.RequiredChargeTick) {
            return false;
        }
        if (((ItemSlashBlade)stack.func_77973_b()).getSwordType(stack).contains((Object)ItemSlashBlade.SwordType.Broken)) {
            return false;
        }
        int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_92091_k.field_77352_x, (ItemStack)stack);
        return level > 0;
    }

    @SubscribeEvent
    public void onUpdate(PlayerUseItemEvent.Tick event) {
        if (ProjectileBarrier.isAvailable(event.entityLiving, event.item, event.duration)) {
            this.expandBarrier(event.entityLiving);
        }
    }

    private void expandBarrier(EntityLivingBase player) {
        if (player.field_70173_aa % 7 == 0) {
            player.func_85030_a("flammpfeil.slashblade:swingblade", 1.0f, 0.75f + player.func_70681_au().nextFloat() * 0.05f);
        }
        AxisAlignedBB bb = player.field_70121_D.func_72314_b(2.0, 2.0, 2.0);
        List list = player.field_70170_p.func_94576_a((Entity)player, bb, ItemSlashBlade.DestructableSelector);
        for (Entity target : list) {
            if (target instanceof EntityPhantomSwordBase || target instanceof IThrowableEntity && ((IThrowableEntity)target).getThrower() == player) continue;
            this.destructEntity(player, target);
        }
    }

    private void destructEntity(EntityLivingBase player, Entity target) {
        if (player instanceof EntityPlayer) {
            ((EntityPlayer)player).func_71047_c(target);
            player.func_85030_a("random.anvil_land", 0.8f, 1.5f + player.func_70681_au().nextFloat() * 0.5f);
        }
        ItemSlashBlade.damageItem(player.func_70694_bm(), 1, player);
        target.field_70159_w = 0.0;
        target.field_70181_x = 0.0;
        target.field_70179_y = 0.0;
        target.func_70106_y();
    }
}

