/*
 * Decompiled with CFR 0.152.
 */
package extracells.util.inventory;

import extracells.util.inventory.IInventoryUpdateReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ECPrivateInventory
implements IInventory {
    public ItemStack[] slots;
    public String customName;
    private int stackLimit;
    private IInventoryUpdateReceiver receiver;

    public ECPrivateInventory(String _customName, int _size, int _stackLimit) {
        this(_customName, _size, _stackLimit, null);
    }

    public ECPrivateInventory(String _customName, int _size, int _stackLimit, IInventoryUpdateReceiver _receiver) {
        this.slots = new ItemStack[_size];
        this.customName = _customName;
        this.stackLimit = _stackLimit;
        this.receiver = _receiver;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        if (this.slots[slotId] == null) {
            return null;
        }
        if (this.slots[slotId].field_77994_a <= amount) {
            ItemStack itemstack = this.slots[slotId];
            this.slots[slotId] = null;
            this.func_70296_d();
            return itemstack;
        }
        ItemStack temp = this.slots[slotId];
        ItemStack itemstack = temp.func_77979_a(amount);
        this.slots[slotId] = temp;
        this.slots[slotId] = temp.field_77994_a == 0 ? null : temp;
        this.func_70296_d();
        return itemstack;
    }

    public String func_145825_b() {
        return this.customName;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int slotId) {
        return this.slots[slotId];
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack incrStackSize(int slotId, int amount) {
        ItemStack slot = this.slots[slotId];
        if (slot == null) {
            return null;
        }
        int stackLimit = this.func_70297_j_();
        if (stackLimit > slot.func_77976_d()) {
            stackLimit = slot.func_77976_d();
        }
        ItemStack added = slot.func_77946_l();
        added.field_77994_a = slot.field_77994_a + amount > stackLimit ? stackLimit : amount;
        slot.field_77994_a += added.field_77994_a;
        return added;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70296_d() {
        if (this.receiver != null) {
            this.receiver.onInventoryChanged();
        }
    }

    public void func_70295_k_() {
    }

    public void readFromNBT(NBTTagList nbtList) {
        if (nbtList == null) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = null;
            }
            return;
        }
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbtList.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.slots[slotId] = itemstack;
        this.func_70296_d();
    }

    public NBTTagList writeToNBT() {
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound);
            nbtList.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbtList;
    }
}

