/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.config.RedstoneMode;
import extracells.gui.GuiBusFluidIO;
import extracells.network.AbstractPacket;
import extracells.part.PartFluidIO;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;

public class PacketBusFluidIO
extends AbstractPacket {
    private List<Fluid> filterFluids;
    private PartFluidIO part;
    private byte action;
    private byte ordinal;
    private byte filterSize;
    private boolean redstoneControlled;

    public PacketBusFluidIO() {
    }

    public PacketBusFluidIO(boolean _redstoneControlled) {
        this.mode = (byte)4;
        this.redstoneControlled = _redstoneControlled;
    }

    public PacketBusFluidIO(byte _filterSize) {
        this.mode = (byte)3;
        this.filterSize = _filterSize;
    }

    public PacketBusFluidIO(EntityPlayer _player, byte _action, PartFluidIO _part) {
        super(_player);
        this.mode = 0;
        this.action = _action;
        this.part = _part;
    }

    public PacketBusFluidIO(EntityPlayer _player, PartFluidIO _part) {
        super(_player);
        this.mode = (byte)2;
        this.part = _part;
    }

    public PacketBusFluidIO(RedstoneMode _redstoneMode) {
        this.mode = 1;
        this.ordinal = (byte)_redstoneMode.ordinal();
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.part.loopRedstoneMode(this.player);
                break;
            }
            case 1: {
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                if (!(gui instanceof GuiBusFluidIO)) break;
                GuiBusFluidIO partGui = (GuiBusFluidIO)gui;
                partGui.updateRedstoneMode(RedstoneMode.values()[this.ordinal]);
                break;
            }
            case 2: {
                this.part.sendInformation(this.player);
                break;
            }
            case 3: {
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                if (!(gui instanceof GuiBusFluidIO)) break;
                GuiBusFluidIO partGui = (GuiBusFluidIO)gui;
                partGui.changeConfig(this.filterSize);
                break;
            }
            case 4: {
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                if (!(gui instanceof GuiBusFluidIO)) break;
                GuiBusFluidIO partGui = (GuiBusFluidIO)gui;
                partGui.setRedstoneControlled(this.redstoneControlled);
            }
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.part = (PartFluidIO)PacketBusFluidIO.readPart(in);
                this.action = in.readByte();
                break;
            }
            case 1: {
                this.ordinal = in.readByte();
                break;
            }
            case 2: {
                this.part = (PartFluidIO)PacketBusFluidIO.readPart(in);
                break;
            }
            case 3: {
                this.filterSize = in.readByte();
                break;
            }
            case 4: {
                this.redstoneControlled = in.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                PacketBusFluidIO.writePart(this.part, out);
                out.writeByte((int)this.action);
                break;
            }
            case 1: {
                out.writeByte((int)this.ordinal);
                break;
            }
            case 2: {
                PacketBusFluidIO.writePart(this.part, out);
                break;
            }
            case 3: {
                out.writeByte((int)this.filterSize);
                break;
            }
            case 4: {
                out.writeBoolean(this.redstoneControlled);
            }
        }
    }
}

