/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.waila;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import extracells.part.PartECBase;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PartWailaDataProvider
implements IWailaDataProvider {
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        IPart part;
        MovingObjectPosition mop = this.retraceBlock(world, player, x, y, z);
        if (mop != null && (part = this.getPart(te, mop)) != null && part instanceof PartECBase) {
            tag.func_74782_a("partEC", (NBTBase)((PartECBase)part).getWailaTag(new NBTTagCompound()));
        }
        return tag;
    }

    private IPart getPart(TileEntity tile, MovingObjectPosition pos) {
        if (tile instanceof IPartHost) {
            Vec3 position = pos.field_72307_f.func_72441_c((double)(-pos.field_72311_b), (double)(-pos.field_72312_c), (double)(-pos.field_72309_d));
            IPartHost host = (IPartHost)tile;
            SelectedPart sp2 = host.selectPart(position);
            if (sp2.part != null) {
                return sp2.part;
            }
        }
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        IPart part = this.getPart(tile, accessor.getPosition());
        if (part != null && part instanceof PartECBase) {
            NBTTagCompound tag = accessor.getNBTData() != null && accessor.getNBTData().func_74764_b("partEC") ? accessor.getNBTData().func_74775_l("partEC") : new NBTTagCompound();
            return ((PartECBase)part).getWailaBodey(tag, currenttip);
        }
        return currenttip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    private MovingObjectPosition retraceBlock(World world, EntityPlayerMP player, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Vec3 head = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        head.field_72448_b += (double)player.func_70047_e();
        if (player.func_70093_af()) {
            head.field_72448_b -= 0.08;
        }
        Vec3 look = player.func_70676_i(1.0f);
        double reach = player.field_71134_c.getBlockReachDistance();
        Vec3 endVec = head.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        return block.func_149731_a(world, x, y, z, head, endVec);
    }
}

