/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.node;

import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.render.BBRenderElement;

public class BBColorNode
extends BBNode {
    protected int color;

    public BBColorNode(String tag) {
        super(tag);
    }

    public BBColorNode(String tag, int color) {
        this(tag);
        this.setColor(color);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(String hexColor) {
        this.setColor(Integer.decode(hexColor));
    }

    @Override
    public BBColorNode copy() {
        return new BBColorNode(this.tag, this.color);
    }

    @Override
    public void apply(BBRenderElement element) {
        if (this.tag.equals("color")) {
            element.color = this.color;
        } else if (this.tag.equals("bgcolor")) {
            element.bgColor = this.color;
        }
    }

    public void setColor(int color) {
        this.color = color;
        this.attribute = "#" + Integer.toHexString(color);
    }
}

