/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class Scale
extends Transformation<Scale, ITransformable.Scale> {
    protected float fromX = 1.0f;
    protected float fromY = 1.0f;
    protected float fromZ = 1.0f;
    protected float toX = 1.0f;
    protected float toY = 1.0f;
    protected float toZ = 1.0f;
    protected float offsetX = 0.0f;
    protected float offsetY = 0.0f;
    protected float offsetZ = 0.0f;

    public Scale() {
    }

    public Scale(float x, float y, float z) {
        this.to(x, y, z);
    }

    public Scale(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        this.from(fromX, fromY, fromZ);
        this.to(toX, toY, toZ);
    }

    protected Scale from(float x, float y, float z) {
        this.fromX = x;
        this.fromY = y;
        this.fromZ = z;
        return this;
    }

    protected Scale to(float x, float y, float z) {
        this.toX = x;
        this.toY = y;
        this.toZ = z;
        return this;
    }

    public Scale offset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    @Override
    protected void doTransform(ITransformable.Scale transformable, float comp) {
        float fromX = this.reversed ? this.toX : this.fromX;
        float toX = this.reversed ? this.fromX : this.toX;
        float fromY = this.reversed ? this.toY : this.fromY;
        float toY = this.reversed ? this.fromY : this.toY;
        float fromZ = this.reversed ? this.toZ : this.fromZ;
        float toZ = this.reversed ? this.fromZ : this.toZ;
        transformable.scale(fromX + (toX - fromX) * comp, fromY + (toY - fromY) * comp, fromZ + (toZ - fromZ) * comp, this.offsetX, this.offsetY, this.offsetZ);
    }
}

