/*
 * Decompiled with CFR 0.152.
 */
package fyber.redstonepastemod;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fyber.redstonepastemod.CommonProxy;
import fyber.redstonepastemod.RedstonePasteMod;
import fyber.redstonepastemod.RedstonePasteUtils;
import fyber.redstonepastemod.TileEntityRedstonePaste;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRedstonePaste
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    public IIcon pasteIcon;
    public IIcon repeaterIcon_Active;
    public IIcon repeaterIcon_Idle;
    public IIcon comparatorIcon_Active;
    public IIcon comparatorIcon_Idle;
    private boolean pasteProvidesPower;
    public static boolean rayTracing;
    public static int rayTracing2;

    public BlockRedstonePaste(int par1, Material mat) {
        super(mat);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149663_c("redstonePaste");
        this.pasteProvidesPower = true;
        rayTracing = false;
        rayTracing2 = -1;
        this.func_149711_c(-1.0f);
        this.func_149658_d("redstonepastemod:redstonepaste_block");
    }

    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return 0x88BB00;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.renderRedstonePasteID;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.func_149709_b(par1IBlockAccess, par2, par3, par4, par5);
    }

    public boolean pasteConnectedTo_OnFace(int[] terpfaces, int dir, int face) {
        return this.pasteConnectedTo_OnFace(terpfaces, dir, face, true);
    }

    public boolean pasteConnectedTo_OnFace(int[] terpfaces, int dir, int face, boolean includefaces) {
        switch (dir) {
            case 1: {
                if (terpfaces[1] > 0 && face == 1 && includefaces) {
                    return true;
                }
                if ((terpfaces[2] & 2) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 2) > 0 && face == 3) {
                    return true;
                }
                if ((terpfaces[4] & 2) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 2) <= 0 || face != 5) break;
                return true;
            }
            case 0: {
                if (terpfaces[0] > 0 && face == 0 && includefaces) {
                    return true;
                }
                if ((terpfaces[2] & 1) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 1) > 0 && face == 3) {
                    return true;
                }
                if ((terpfaces[4] & 1) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 1) <= 0 || face != 5) break;
                return true;
            }
            case 2: {
                if (terpfaces[2] > 0 && face == 2 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 1) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 1) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[4] & 4) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 4) <= 0 || face != 5) break;
                return true;
            }
            case 3: {
                if (terpfaces[3] > 0 && face == 3 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 2) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 2) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[4] & 8) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 8) <= 0 || face != 5) break;
                return true;
            }
            case 4: {
                if (terpfaces[4] > 0 && face == 4 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 4) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 4) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[2] & 4) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 4) <= 0 || face != 3) break;
                return true;
            }
            case 5: {
                if (terpfaces[5] > 0 && face == 5 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 8) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 8) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[2] & 8) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 8) <= 0 || face != 3) break;
                return true;
            }
            case -1: {
                return true;
            }
        }
        return false;
    }

    public boolean pasteConnectedTo(int[] terpfaces, int dir) {
        switch (dir) {
            case 1: {
                if (terpfaces[1] > 0) {
                    return true;
                }
                if ((terpfaces[2] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 2) <= 0) break;
                return true;
            }
            case 0: {
                if (terpfaces[0] > 0) {
                    return true;
                }
                if ((terpfaces[2] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 1) <= 0) break;
                return true;
            }
            case 2: {
                if (terpfaces[2] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 4) <= 0) break;
                return true;
            }
            case 3: {
                if (terpfaces[3] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 8) <= 0) break;
                return true;
            }
            case 4: {
                if (terpfaces[4] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[2] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 4) <= 0) break;
                return true;
            }
            case 5: {
                if (terpfaces[5] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[2] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 8) <= 0) break;
                return true;
            }
            case -1: {
                return true;
            }
        }
        return false;
    }

    public boolean pasteConnectedTo(IBlockAccess world, int x, int y, int z, int dir) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return false;
        }
        return this.pasteConnectedTo(terp.faces, dir);
    }

    public static int repeaterDirectionToWorldDirection(int face, int data) {
        data &= 3;
        switch (face) {
            case 0: 
            case 1: {
                switch (data) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 5;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                switch (data) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 5;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                switch (data) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 3;
                    }
                }
            }
        }
        return -1;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        int opposite;
        TileEntity te = par1IBlockAccess.func_147438_o(par2, par3, par4);
        if (!(te instanceof TileEntityRedstonePaste)) {
            return 0;
        }
        int powerout = 0;
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        if (par5 >= 0 && par5 <= 5) {
            int oppositeFace = Facing.field_71588_a[par5];
            if (terp.facetype[oppositeFace] == 0 && terp.faces[oppositeFace] > 0) {
                powerout = terp.facedata[oppositeFace];
            }
            for (int dir = 0; dir < 6; ++dir) {
                if (dir == par5 || dir == oppositeFace || terp.facetype[dir] != 0 || terp.faces[dir] == 0 || terp.facedata[dir] <= powerout || !this.pasteConnectedTo_OnFace(terp.faces, oppositeFace, dir, false)) continue;
                powerout = terp.facedata[dir];
            }
        }
        if (par5 >= 0 && par5 <= 5 && par1IBlockAccess.func_147439_a(par2 + Facing.field_71586_b[opposite = Facing.field_71588_a[par5]], par3 + Facing.field_71587_c[opposite], par4 + Facing.field_71585_d[opposite]) == Blocks.field_150488_af) {
            --powerout;
        }
        boolean foundRepeater = false;
        for (int n = 0; n < 6; ++n) {
            int comparatorpower;
            if (par5 == -1) continue;
            int opposite2 = Facing.field_71588_a[par5];
            int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(n, terp.facedata[n]);
            if (worlddir != opposite2) continue;
            if (terp.facetype[n] == 2) {
                if ((terp.facedata[n] & 4) <= 0) continue;
                powerout = 15;
                foundRepeater = true;
                continue;
            }
            if (terp.facetype[n] != 3 || (comparatorpower = (terp.facedata[n] & 0x78) >> 3) <= 0) continue;
            powerout = comparatorpower;
            foundRepeater = true;
        }
        if (powerout < 0) {
            powerout = 0;
        }
        if (powerout > 15) {
            powerout = 15;
        }
        return !this.pasteProvidesPower && !foundRepeater ? 0 : powerout;
    }

    public void notifyNeighborCube(World world, int x, int y, int z, Block block) {
        world.func_147459_d(x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        world.func_147459_d(x - 1, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        world.func_147459_d(x + 1, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        world.func_147459_d(x, y - 1, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        world.func_147459_d(x, y + 1, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        world.func_147459_d(x, y, z - 1, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        world.func_147459_d(x, y, z + 1, (Block)RedstonePasteMod.instance.blockRedstonePaste);
    }

    private void dropPasteFace(World world, int x, int y, int z, int faceclicked) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return;
        }
        int face = terp.faces[faceclicked];
        int pieces = 0;
        if ((face & 1) > 0) {
            ++pieces;
        }
        if ((face & 2) > 0) {
            ++pieces;
        }
        if ((face & 4) > 0) {
            ++pieces;
        }
        if ((face & 8) > 0) {
            ++pieces;
        }
        terp.faces[faceclicked] = 0;
        ItemStack stack = new ItemStack((Block)this, pieces);
        this.func_149642_a(world, x, y, z, stack);
        if (!BlockRedstonePaste.destroyBlockIfEmpty(world, x, y, z)) {
            world.func_147471_g(x, y, z);
        }
        this.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
    }

    private void dropFace(World world, int x, int y, int z, int faceclicked) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return;
        }
        switch (terp.facetype[faceclicked]) {
            case 0: {
                int face = terp.faces[faceclicked];
                int pieces = 0;
                if ((face & 1) > 0) {
                    ++pieces;
                }
                if ((face & 2) > 0) {
                    ++pieces;
                }
                if ((face & 4) > 0) {
                    ++pieces;
                }
                if ((face & 8) > 0) {
                    ++pieces;
                }
                terp.faces[faceclicked] = 0;
                ItemStack stack = new ItemStack((Block)this, pieces);
                this.func_149642_a(world, x, y, z, stack);
                break;
            }
            case 2: {
                terp.facetype[faceclicked] = 0;
                terp.facedata[faceclicked] = 0;
                ItemStack stack = new ItemStack((Item)RedstonePasteMod.instance.itemStickyRepeater, 1);
                this.func_149642_a(world, x, y, z, stack);
                break;
            }
            case 3: {
                terp.facetype[faceclicked] = 0;
                terp.facedata[faceclicked] = 0;
                ItemStack stack = new ItemStack((Item)RedstonePasteMod.instance.itemStickyComparator, 1);
                this.func_149642_a(world, x, y, z, stack);
            }
        }
        if (!BlockRedstonePaste.destroyBlockIfEmpty(world, x, y, z)) {
            world.func_147471_g(x, y, z);
        }
        this.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
    }

    public boolean getWeakChanges(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void neighborChange(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
            if (terp != null) {
                boolean repeaterActive = false;
                for (int n = 0; n < 6; ++n) {
                    int x = par2 + Facing.field_71586_b[n];
                    int y = par3 + Facing.field_71587_c[n];
                    int z = par4 + Facing.field_71585_d[n];
                    boolean solid = par1World.isSideSolid(x, y, z, ForgeDirection.getOrientation((int)Facing.field_71588_a[n]));
                    if (!solid && terp.faces[n] > 0) {
                        this.dropPasteFace(par1World, par2, par3, par4, n);
                    }
                    if (!solid && terp.facetype[n] == 2) {
                        this.dropFace(par1World, par2, par3, par4, n);
                    }
                    if (solid || terp.facetype[n] != 3) continue;
                    this.dropFace(par1World, par2, par3, par4, n);
                }
            }
            this.propagateSignal(par1World, par2, par3, par4);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == this) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null) {
                return;
            }
            World w = world.func_147438_o(x, y, z).func_145831_w();
            if (w == null) {
                return;
            }
            this.neighborChange(w, x, y, z);
        }
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        this.neighborChange(par1World, par2, par3, par4);
        super.func_149695_a(par1World, par2, par3, par4, par5);
    }

    private int getMaxCurrentStrength(World par1World, int par2, int par3, int par4, int par5, int dir) {
        Block bID = par1World.func_147439_a(par2, par3, par4);
        if (bID == RedstonePasteMod.instance.blockRedstonePaste) {
            int pwr = this.func_149709_b((IBlockAccess)par1World, par2, par3, par4, dir);
            return pwr > par5 ? pwr : par5;
        }
        if (bID == Blocks.field_150488_af && (dir == -1 || dir >= 2)) {
            int i1 = par1World.func_72805_g(par2, par3, par4);
            return i1 > par5 ? i1 : par5;
        }
        return par5;
    }

    private int isBlockProvidingPowerTo_NoWire(World world, int par1, int par2, int par3, int par4) {
        Block i1 = world.func_147439_a(par1, par2, par3);
        if (i1 == Blocks.field_150488_af) {
            return 0;
        }
        return i1 == null || i1 == Blocks.field_150350_a ? 0 : i1.func_149748_c((IBlockAccess)world, par1, par2, par3, par4);
    }

    private int getBlockPowerInput_NoWire(World world, int par1, int par2, int par3) {
        int b0 = 0;
        int l = Math.max(b0, this.isBlockProvidingPowerTo_NoWire(world, par1, par2 - 1, par3, 0));
        if (l >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1, par2 + 1, par3, 1))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1, par2, par3 - 1, 2))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1, par2, par3 + 1, 3))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1 - 1, par2, par3, 4))) >= 15) {
            return l;
        }
        return (l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1 + 1, par2, par3, 5))) >= 15 ? l : l;
    }

    private int getIndirectPowerLevelTo_NoWire(World par1World, int par1, int par2, int par3, int par4) {
        if (par1World.func_147445_c(par1, par2, par3, false)) {
            return this.getBlockPowerInput_NoWire(par1World, par1, par2, par3);
        }
        Block i1 = par1World.func_147439_a(par1, par2, par3);
        if (i1 == this || i1 == Blocks.field_150488_af) {
            return 0;
        }
        return i1 == null || i1 == Blocks.field_150350_a ? 0 : i1.func_149709_b((IBlockAccess)par1World, par1, par2, par3, par4);
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        int newdata;
        int repeaterinput;
        int dir;
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return;
        }
        for (dir = 0; dir < 6; ++dir) {
            if (terp.facetype[dir] != 2 || this.isRepeaterLocked((IBlockAccess)world, x, y, z)) continue;
            repeaterinput = this.getRepeaterInput(world, dir, terp.facedata[dir], x, y, z);
            boolean repeaterActive = (terp.facedata[dir] & 4) > 1;
            int previousdata = terp.facedata[dir];
            newdata = terp.facedata[dir];
            newdata = repeaterinput > 0 ? (newdata |= 4) : (newdata &= 0xFFFFFFFB);
            if (!repeaterActive) {
                int[] delays = new int[]{2, 4, 6, 8};
                int delay = delays[((newdata |= 4) & 0x18) >> 3];
                world.func_147454_a(x, y, z, (Block)this, delay, -1);
            }
            if (previousdata == newdata) continue;
            terp.facedata[dir] = newdata;
            world.func_147471_g(x, y, z);
            this.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
        for (dir = 0; dir < 6; ++dir) {
            if (terp.facetype[dir] != 3) continue;
            repeaterinput = this.getRepeaterInput(world, dir, terp.facedata[dir], x, y, z, true);
            int sideinput = this.getSideInput(world, dir, terp.facedata[dir], x, y, z);
            int comparatormode = (terp.facedata[dir] & 4) >> 2;
            if (comparatormode == 0) {
                if (repeaterinput < sideinput) {
                    repeaterinput = 0;
                }
            } else if ((repeaterinput -= sideinput) < 0) {
                repeaterinput = 0;
            }
            int previousdata = newdata = terp.facedata[dir];
            newdata &= 0xFFFFFF87;
            if (previousdata == (newdata |= repeaterinput << 3)) continue;
            terp.facedata[dir] = newdata;
            world.func_147471_g(x, y, z);
            this.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public boolean isRepeaterLocked(IBlockAccess world, int x, int y, int z) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return false;
        }
        int repeaterFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] != 2) continue;
            repeaterFace = n;
            break;
        }
        if (repeaterFace == -1) {
            return false;
        }
        int repeaterDir = terp.facedata[repeaterFace] & 3;
        int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace]);
        int worldside = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace] + 1);
        for (int n = 0; n < 2; ++n) {
            int worlddir2;
            TileEntityRedstonePaste terp2;
            int z2;
            int y2;
            int currentside = n == 0 ? worldside : Facing.field_71588_a[worldside];
            int x2 = x + Facing.field_71586_b[currentside];
            Block bID = world.func_147439_a(x2, y2 = y + Facing.field_71587_c[currentside], z2 = z + Facing.field_71585_d[currentside]);
            if (bID == Blocks.field_150416_aS && repeaterFace == 0) {
                int metadir = world.func_72805_g(x2, y2, z2) & 3;
                int metaworlddir = Direction.field_71582_c[metadir];
                if (currentside != metaworlddir) continue;
                return true;
            }
            if (bID != this || (terp2 = (TileEntityRedstonePaste)world.func_147438_o(x2, y2, z2)) == null || terp2.facetype[repeaterFace] != 2 || (terp2.facedata[repeaterFace] & 4) == 0 || (worlddir2 = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp2.facedata[repeaterFace])) == -1 || currentside != Facing.field_71588_a[worlddir2]) continue;
            return true;
        }
        return false;
    }

    private int getRepeaterInput(World world, int dir, int facedata, int x, int y, int z) {
        return this.getRepeaterInput2(world, dir, BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, facedata), x, y, z, false);
    }

    private int getRepeaterInput(World world, int dir, int facedata, int x, int y, int z, boolean isComparator) {
        return this.getRepeaterInput2(world, dir, BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, facedata), x, y, z, isComparator);
    }

    private int getRepeaterInput2(World world, int dir, int worlddir, int x, int y, int z, boolean isComparator) {
        int newx = x + Facing.field_71586_b[Facing.field_71588_a[worlddir]];
        int newy = y + Facing.field_71587_c[Facing.field_71588_a[worlddir]];
        int newz = z + Facing.field_71585_d[Facing.field_71588_a[worlddir]];
        int repeaterinput = 0;
        Block bID = world.func_147439_a(newx, newy, newz);
        if (bID != this) {
            Block b = bID;
            if (b != null && b.func_149740_M() && isComparator) {
                repeaterinput = b.func_149736_g(world, newx, newy, newz, worlddir);
            } else {
                repeaterinput = world.func_72878_l(newx, newy, newz, Facing.field_71588_a[worlddir]);
                repeaterinput = this.getMaxCurrentStrength(world, newx, newy, newz, repeaterinput, Facing.field_71588_a[worlddir]);
            }
        } else {
            TileEntityRedstonePaste terp2 = (TileEntityRedstonePaste)world.func_147438_o(newx, newy, newz);
            if (terp2 != null) {
                int worlddir2;
                if (terp2.facetype[dir] == 0) {
                    repeaterinput = this.getPasteStrengthToDir_OnFace(terp2, worlddir, dir);
                } else if (terp2.facetype[dir] == 2) {
                    int worlddir22 = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir]);
                    if (worlddir22 == worlddir && (terp2.facedata[dir] & 4) > 0) {
                        repeaterinput = 15;
                    }
                } else if (terp2.facetype[dir] == 3 && (worlddir2 = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir])) == worlddir) {
                    repeaterinput = (terp2.facedata[dir] & 0x78) >> 3;
                }
            }
        }
        return repeaterinput;
    }

    private int getSideInput(World world, int dir, int facedata, int x, int y, int z) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return 0;
        }
        int repeaterFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] != 3) continue;
            repeaterFace = n;
            break;
        }
        if (repeaterFace == -1) {
            return 0;
        }
        int repeaterDir = terp.facedata[repeaterFace] & 3;
        int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace]);
        int worldside = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace] + 1);
        int sideinput = 0;
        for (int n = 0; n < 2; ++n) {
            int currentside = n == 0 ? worldside : Facing.field_71588_a[worldside];
            int x2 = x + Facing.field_71586_b[currentside];
            int y2 = y + Facing.field_71587_c[currentside];
            int z2 = z + Facing.field_71585_d[currentside];
            int thisinput = this.getRepeaterInput2(world, dir, Facing.field_71588_a[currentside], x, y, z, true);
            if (thisinput <= sideinput) continue;
            sideinput = thisinput;
        }
        return sideinput;
    }

    private int getPasteStrengthToDir_OnFace(TileEntityRedstonePaste terp, int dir, int face) {
        int powerout = 0;
        if (terp.facetype[dir] == 0 && terp.faces[dir] > 0) {
            powerout = terp.facedata[dir];
        }
        if (this.pasteConnectedTo_OnFace(terp.faces, dir, face, false)) {
            powerout = Math.max(powerout, terp.facedata[face]);
        }
        return powerout;
    }

    private void propagateSignal(World world, int x, int y, int z) {
        int dir;
        int repeaterinput;
        int dir2;
        boolean power = false;
        int indirectpower = 0;
        int newstrength = 0;
        int outstrength = 0;
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return;
        }
        for (dir2 = 0; dir2 < 6; ++dir2) {
            if (terp.facetype[dir2] != 2 || this.isRepeaterLocked((IBlockAccess)world, x, y, z)) continue;
            repeaterinput = this.getRepeaterInput(world, dir2, terp.facedata[dir2], x, y, z);
            int previousdata = terp.facedata[dir2];
            int newdata = terp.facedata[dir2];
            newdata = repeaterinput > 0 ? (newdata |= 4) : (newdata &= 0xFFFFFFFB);
            int[] delays = new int[]{2, 4, 6, 8};
            int delay = delays[(newdata & 0x18) >> 3];
            if (previousdata == newdata || world.func_147477_a(x, y, z, (Block)this)) continue;
            world.func_147454_a(x, y, z, (Block)this, delay, -1);
        }
        for (dir2 = 0; dir2 < 6; ++dir2) {
            if (terp.facetype[dir2] != 3) continue;
            repeaterinput = this.getRepeaterInput(world, dir2, terp.facedata[dir2], x, y, z, true);
            int sideinput = this.getSideInput(world, dir2, terp.facedata[dir2], x, y, z);
            int comparatormode = (terp.facedata[dir2] & 4) >> 2;
            if (comparatormode == 0) {
                if (repeaterinput < sideinput) {
                    repeaterinput = 0;
                }
            } else if ((repeaterinput -= sideinput) < 0) {
                repeaterinput = 0;
            }
            int previousdata = terp.facedata[dir2];
            int newdata = terp.facedata[dir2];
            newdata &= 0xFFFFFF87;
            int delay = 2;
            if (previousdata == (newdata |= repeaterinput << 3) || world.func_147477_a(x, y, z, (Block)this)) continue;
            world.func_147454_a(x, y, z, (Block)this, delay, -1);
        }
        boolean facestrengthchanged = false;
        NeighborBlock[] neighbors = new NeighborBlock[6];
        for (dir = 0; dir < 6; ++dir) {
            int newx = x + Facing.field_71586_b[dir];
            int newy = y + Facing.field_71587_c[dir];
            int newz = z + Facing.field_71585_d[dir];
            neighbors[dir] = new NeighborBlock(world, newx, newy, newz);
        }
        for (dir = 0; dir < 6; ++dir) {
            if (terp.facetype[dir] != 0 || terp.faces[dir] == 0) continue;
            newstrength = 0;
            indirectpower = 0;
            NeighborBlock neighbor = neighbors[dir];
            if (neighbor.blockID != this) {
                indirectpower = neighbor.getMaxIndirectPower(indirectpower, Facing.field_71588_a[dir]);
                newstrength = neighbor.getMaxPower(newstrength, Facing.field_71588_a[dir]);
            }
            for (int thisdir = 0; thisdir < 6; ++thisdir) {
                int worlddir;
                if (thisdir == dir || thisdir == Facing.field_71588_a[dir] || !this.pasteConnectedTo_OnFace(terp.faces, thisdir, dir, false)) continue;
                if (this.pasteConnectedTo_OnFace(terp.faces, dir, thisdir, false)) {
                    newstrength = Math.max(newstrength, terp.facedata[thisdir]);
                }
                if (neighbors[thisdir].blockID != this) {
                    indirectpower = neighbors[thisdir].getMaxIndirectPower(indirectpower, Facing.field_71588_a[thisdir]);
                    newstrength = neighbors[thisdir].getMaxPower(newstrength, Facing.field_71588_a[thisdir]);
                    continue;
                }
                TileEntityRedstonePaste terp2 = neighbors[thisdir].terp;
                if (terp2.facetype[dir] == 0) {
                    newstrength = Math.max(newstrength, this.getPasteStrengthToDir_OnFace(terp2, Facing.field_71588_a[thisdir], dir));
                    continue;
                }
                if (terp2.facetype[dir] == 2) {
                    worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir]);
                    if (worlddir != Facing.field_71588_a[thisdir] || (terp2.facedata[dir] & 4) <= 0) continue;
                    indirectpower = 15;
                    continue;
                }
                if (terp2.facetype[dir] != 3 || (worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir])) != Facing.field_71588_a[thisdir]) continue;
                indirectpower = Math.max(indirectpower, (terp2.facedata[dir] & 0x78) >> 3);
            }
            for (int dir22 = 0; dir22 < 6; ++dir22) {
                TileEntityRedstonePaste terp2;
                int sidez;
                int sidey;
                int sidex;
                if (dir22 == dir || dir22 == ForgeDirection.OPPOSITES[dir] || world.func_147445_c(neighbors[dir22].x, neighbors[dir22].y, neighbors[dir22].z, false) || !this.pasteConnectedTo_OnFace(terp.faces, dir22, dir) || world.func_147439_a(sidex = neighbor.x + Facing.field_71586_b[dir22], sidey = neighbor.y + Facing.field_71587_c[dir22], sidez = neighbor.z + Facing.field_71585_d[dir22]) != this || (terp2 = (TileEntityRedstonePaste)world.func_147438_o(sidex, sidey, sidez)) == null || !this.pasteConnectedTo_OnFace(terp2.faces, ForgeDirection.OPPOSITES[dir], ForgeDirection.OPPOSITES[dir22])) continue;
                newstrength = Math.max(newstrength, this.getPasteStrengthToDir_OnFace(terp2, Facing.field_71588_a[dir], Facing.field_71588_a[dir22]));
            }
            outstrength = newstrength > indirectpower ? newstrength - 1 : indirectpower;
            if (outstrength < 0) {
                outstrength = 0;
            }
            if (outstrength > 15) {
                outstrength = 15;
            }
            if (terp.facedata[dir] == outstrength) continue;
            terp.facedata[dir] = outstrength;
            facestrengthchanged = true;
        }
        if (facestrengthchanged) {
            world.func_147471_g(x, y, z);
            this.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public boolean func_149744_f() {
        return this.pasteProvidesPower;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRedstonePaste) {
            boolean powerout = false;
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            if (terp.facetype[0] == 2 || terp.facetype[0] == 3) {
                int worldside;
                int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(0, terp.facedata[0]);
                int n = worldside = side == -1 ? 1 : Direction.field_71582_c[side];
                return worlddir == worldside || Facing.field_71588_a[worlddir] == worldside;
            }
            switch (side) {
                case 0: {
                    if ((terp.faces[0] & 1) != 1) break;
                    powerout = true;
                    break;
                }
                case 2: {
                    if ((terp.faces[0] & 2) != 2) break;
                    powerout = true;
                    break;
                }
                case 3: {
                    if ((terp.faces[0] & 4) != 4) break;
                    powerout = true;
                    break;
                }
                case 1: {
                    if ((terp.faces[0] & 8) != 8) break;
                    powerout = true;
                }
            }
            return powerout;
        }
        return false;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.repeaterIcon_Active = par1IconRegister.func_94245_a("redstonepastemod:stickyrepeater_on");
        this.repeaterIcon_Idle = par1IconRegister.func_94245_a("redstonepastemod:stickyrepeater_off");
        this.comparatorIcon_Active = par1IconRegister.func_94245_a("redstonepastemod:stickycomparator_on");
        this.comparatorIcon_Idle = par1IconRegister.func_94245_a("redstonepastemod:stickycomparator_off");
        super.func_149651_a(par1IconRegister);
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        if (!par1World.field_72995_K) {
            this.notifyNeighborCube(par1World, par2, par3, par4, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return BlockRedstonePaste.getPasteObjectCount(world, x, y, z) == 0;
    }

    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack item) {
        return super.func_149705_a(world, x, y, z, side, item);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
        if (te != null) {
            boolean fullBlock = false;
            for (int n = 0; n < 6; ++n) {
                if (te.facetype[n] != 1) continue;
                fullBlock = true;
            }
            if (fullBlock) {
                this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
                super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
            }
        }
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1IBlockAccess.func_147438_o(par2, par3, par4);
        if (terp != null) {
            boolean fullBlock = false;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] != 1 || rayTracing2 != -1 && rayTracing2 != n) continue;
                switch (n) {
                    case 0: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                        return;
                    }
                    case 1: {
                        this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                        return;
                    }
                    case 2: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                        return;
                    }
                    case 3: {
                        this.func_149676_a(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                        return;
                    }
                    case 4: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                        return;
                    }
                    case 5: {
                        this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        return;
                    }
                }
                return;
            }
        }
        if (rayTracing) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float z1 = 0.0f;
        float z2 = 0.0f;
        float thickness = 0.0625f;
        thickness = 1.0E-4f;
        if (rayTracing2 >= 0 && rayTracing2 <= 5) {
            switch (rayTracing2) {
                case 0: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = thickness;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 1: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 1.0f - thickness;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 2: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = thickness;
                    break;
                }
                case 3: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 1.0f - thickness;
                    z2 = 1.0f;
                    break;
                }
                case 4: {
                    x1 = 0.0f;
                    x2 = thickness;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 5: {
                    x1 = 1.0f - thickness;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                }
            }
            this.func_149676_a(x1, y1, z1, x2, y2, z2);
            return;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 par5Vec3, Vec3 par6Vec3) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return null;
        }
        MovingObjectPosition shortestmop = null;
        double shortestdistance = 0.0;
        Vec3 xyzVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        for (int f = 0; f < 6; ++f) {
            if (terp.faces[f] < 1 && terp.facetype[f] == 0) continue;
            rayTracing2 = f;
            MovingObjectPosition mop = super.func_149731_a(world, x, y, z, par5Vec3, par6Vec3);
            rayTracing2 = -1;
            if (mop == null) continue;
            double distance = mop.field_72307_f.func_72438_d(par5Vec3);
            mop.subHit = terp.facetype[f];
            if (!(distance <= shortestdistance) && shortestmop != null) continue;
            shortestmop = mop;
            shortestdistance = distance;
        }
        if (shortestmop != null) {
            return shortestmop;
        }
        return null;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + 1.62 - (double)par2EntityPlayer.field_70129_M;
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        double d3 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
            if (par2EntityPlayer.func_70093_af()) {
                d1 -= 0.08;
            }
        }
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_72901_a(vec3, vec31, par3);
    }

    public static int getPasteBlockType(World world, EntityPlayer player) {
        MovingObjectPosition mop = BlockRedstonePaste.getMovingObjectPositionFromPlayer(world, player, true);
        if (mop == null) {
            return -1;
        }
        return mop.subHit;
    }

    public static boolean destroyBlockIfEmpty(World world, int x, int y, int z) {
        int pasteobjects = BlockRedstonePaste.getPasteObjectCount((IBlockAccess)world, x, y, z);
        if (pasteobjects == 0) {
            world.func_147475_p(x, y, z);
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public void func_149699_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.field_72995_K) {
            return;
        }
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(par1World, par5EntityPlayer);
        if (pasteBlockType == 1) {
            return;
        }
        MovingObjectPosition mop = RedstonePasteUtils.traceBlockExit(par5EntityPlayer, par2, par3, par4);
        if (mop == null) {
            return;
        }
        if (pasteBlockType == 2) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
            terp.faces[mop.field_72310_e] = 0;
            terp.facetype[mop.field_72310_e] = 0;
            terp.facedata[mop.field_72310_e] = 0;
            if (!BlockRedstonePaste.destroyBlockIfEmpty(par1World, par2, par3, par4)) {
                par1World.func_147471_g(par2, par3, par4);
            }
            if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                ItemStack dropstack = new ItemStack((Item)RedstonePasteMod.instance.itemStickyRepeater, 1, 0);
                this.func_149642_a(par1World, par2, par3, par4, dropstack);
                par1World.func_72926_e(2001, par2, par3, par4, Block.func_149682_b((Block)this));
            }
            this.notifyNeighborCube(par1World, par2, par3, par4, (Block)this);
            return;
        }
        if (pasteBlockType == 3) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
            terp.faces[mop.field_72310_e] = 0;
            terp.facetype[mop.field_72310_e] = 0;
            terp.facedata[mop.field_72310_e] = 0;
            if (!BlockRedstonePaste.destroyBlockIfEmpty(par1World, par2, par3, par4)) {
                par1World.func_147471_g(par2, par3, par4);
            }
            if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                ItemStack dropstack = new ItemStack((Item)RedstonePasteMod.instance.itemStickyComparator, 1, 0);
                this.func_149642_a(par1World, par2, par3, par4, dropstack);
                par1World.func_72926_e(2001, par2, par3, par4, Block.func_149682_b((Block)this));
            }
            this.notifyNeighborCube(par1World, par2, par3, par4, (Block)this);
            return;
        }
        int faceclicked = -1;
        faceclicked = mop.field_72310_e;
        double hitX = mop.field_72307_f.field_72450_a - (double)mop.field_72311_b;
        double hitY = mop.field_72307_f.field_72448_b - (double)mop.field_72312_c;
        double hitZ = mop.field_72307_f.field_72449_c - (double)mop.field_72309_d;
        int segmentclicked = -1;
        if (faceclicked == 0 || faceclicked == 1) {
            segmentclicked = RedstonePasteUtils.testSegmentHit(hitX, hitZ);
        } else if (faceclicked == 2 || faceclicked == 3) {
            segmentclicked = RedstonePasteUtils.testSegmentHit(hitX, hitY);
        } else if (faceclicked == 4 || faceclicked == 5) {
            segmentclicked = RedstonePasteUtils.testSegmentHit(hitZ, hitY);
        }
        if (par5EntityPlayer.func_70093_af()) {
            switch (segmentclicked) {
                case 1: {
                    segmentclicked |= 2;
                    break;
                }
                case 2: {
                    segmentclicked |= 1;
                    break;
                }
                case 4: {
                    segmentclicked |= 8;
                    break;
                }
                case 8: {
                    segmentclicked |= 4;
                }
            }
        }
        if (segmentclicked < 1) {
            return;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
        int[] segmentvalues = new int[]{1, 2, 4, 8};
        int segmentsdropped = 0;
        for (int seg = 0; seg < 4; ++seg) {
            if ((segmentclicked & segmentvalues[seg]) == 0 || (terp.faces[faceclicked] & segmentvalues[seg]) <= 0) continue;
            ++segmentsdropped;
            int n = faceclicked;
            terp.faces[n] = terp.faces[n] & ~segmentvalues[seg];
        }
        if (segmentsdropped > 0) {
            int x = par2;
            int y = par3;
            int z = par4;
            ItemStack stack = new ItemStack((Block)this, segmentsdropped);
            if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                this.func_149642_a(par1World, par2, par3, par4, stack);
                par1World.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)this));
            }
            if (!BlockRedstonePaste.destroyBlockIfEmpty(par1World, x, y, z)) {
                par1World.func_147471_g(x, y, z);
            }
            this.notifyNeighborCube(par1World, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public static int getPasteObjectCount(IBlockAccess world, int x, int y, int z) {
        Block bID = world.func_147439_a(x, y, z);
        if (bID != RedstonePasteMod.instance.blockRedstonePaste) {
            return 0;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        return BlockRedstonePaste.getPasteObjectCount(terp);
    }

    public static int getPasteObjectCount(TileEntityRedstonePaste terp) {
        if (terp == null) {
            return 0;
        }
        int pasteobjects = 0;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] == 0 && terp.faces[n] > 0) {
                ++pasteobjects;
            }
            if (terp.facetype[n] <= 0) continue;
            ++pasteobjects;
        }
        return pasteobjects;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
        if (terp == null) {
            return;
        }
        for (int side = 0; side < 6; ++side) {
            int l = terp.facedata[side];
            int facetype = terp.facetype[side];
            if (facetype == 0 && (terp.faces[side] == 0 || l == 0) || facetype != 0 && facetype != 2 || facetype == 2 && (terp.facedata[side] & 4) == 0) continue;
            double d0 = (double)par2 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            double d1 = (double)par3 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            double d2 = (double)par4 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.2;
            float offset = 0.0625f;
            if (facetype == 2) {
                offset = (float)((double)offset + 0.2);
                l = 15;
            }
            switch (side) {
                case 0: {
                    d1 = (float)par3 + offset;
                    break;
                }
                case 1: {
                    d1 = (float)par3 + (1.0f - offset);
                    break;
                }
                case 2: {
                    d2 = (float)par4 + offset;
                    break;
                }
                case 3: {
                    d2 = (float)par4 + (1.0f - offset);
                    break;
                }
                case 4: {
                    d0 = (float)par2 + offset;
                    break;
                }
                case 5: {
                    d0 = (float)par2 + (1.0f - offset);
                }
            }
            float f = (float)l / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            par1World.func_72869_a("reddust", d0, d1, d2, (double)f1, (double)f2, (double)f3);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(world, player);
        if (pasteBlockType == 1) {
            this.removeSlab(world, x, y, z, !player.field_71075_bZ.field_75098_d);
            BlockRedstonePaste.destroyBlockIfEmpty(world, x, y, z);
            world.func_147471_g(x, y, z);
            this.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        } else {
            this.func_149699_a(world, x, y, z, player);
        }
        return false;
    }

    private void removeSlab(World world, int x, int y, int z, boolean dropItem) {
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        int slabData = 0;
        for (int n = 0; n < 6; ++n) {
            if (te.facetype[n] != 1) continue;
            slabData = te.facedata[n];
            te.facetype[n] = 0;
            te.facedata[n] = 0;
            if (!dropItem) continue;
            Block slabID = Block.func_149729_e((int)(slabData & 0xFFFF));
            int damage = slabData >> 16;
            Item dropID = slabID.func_149650_a(damage, world.field_73012_v, 0);
            int dropdamage = slabID.func_149692_a(damage);
            ItemStack dropstack = new ItemStack(dropID, 1, dropdamage);
            this.func_149642_a(world, x, y, z, dropstack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public boolean func_149727_a(World par1World, int x, int y, int z, EntityPlayer entityPlayer, int face, float par7, float par8, float par9) {
        Block bID = par1World.func_147439_a(x, y, z);
        if (bID != this) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)par1World.func_147438_o(x, y, z);
        if (terp == null) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        if (entityPlayer == null) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        ItemStack heldItem = entityPlayer.func_71045_bC();
        boolean isHoldingSlab = heldItem != null && heldItem.func_77973_b() instanceof ItemSlab;
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(par1World, entityPlayer);
        if (pasteBlockType == 2) {
            if (!isHoldingSlab) {
                int repeaterface = 0;
                for (int n = 0; n < 6; ++n) {
                    if (terp.facetype[n] != 2) continue;
                    repeaterface = n;
                    break;
                }
                int delay = (terp.facedata[repeaterface] & 0x18) >> 3;
                ++delay;
                delay &= 3;
                if (!par1World.field_72995_K) {
                    int n = repeaterface;
                    terp.facedata[n] = terp.facedata[n] & 0xFFFFFFE7;
                    int n2 = repeaterface;
                    terp.facedata[n2] = terp.facedata[n2] | delay << 3;
                }
                par1World.func_147471_g(x, y, z);
                this.notifyNeighborCube(par1World, x, y, z, (Block)this);
                return true;
            }
        } else if (pasteBlockType == 3 && !isHoldingSlab) {
            int comparatorface = 0;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] != 3) continue;
                comparatorface = n;
                break;
            }
            int toggle = terp.facedata[comparatorface] & 4;
            par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, toggle > 0 ? 0.4f : 0.55f);
            toggle = ~toggle & 4;
            if (!par1World.field_72995_K) {
                int n = comparatorface;
                terp.facedata[n] = terp.facedata[n] & 0xFFFFFFFB;
                int n3 = comparatorface;
                terp.facedata[n3] = terp.facedata[n3] | toggle;
            }
            par1World.func_147471_g(x, y, z);
            this.notifyNeighborCube(par1World, x, y, z, (Block)this);
            return true;
        }
        if (heldItem == null) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        if (!(heldItem.func_77973_b() instanceof ItemSlab)) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        int pasteFaces = 0;
        int slabFaces = 0;
        int pasteObjects = 0;
        for (int n = 0; n < 6; ++n) {
            if (terp.faces[n] > 0) {
                ++pasteFaces;
            }
            if (terp.facetype[n] == 1) {
                ++slabFaces;
            }
            if (terp.facetype[n] == 0 && terp.faces[n] > 0) {
                ++pasteObjects;
            }
            if (terp.facetype[n] <= 0) continue;
            ++pasteObjects;
        }
        if (pasteObjects > 1) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        if (terp.facetype[face] != 0) {
            return super.func_149727_a(par1World, x, y, z, entityPlayer, face, par7, par8, par9);
        }
        if (!par1World.field_72995_K) {
            terp.facetype[face] = 1;
            terp.facedata[face] = Block.func_149682_b((Block)Block.func_149634_a((Item)heldItem.func_77973_b())) | heldItem.func_77960_j() << 16;
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
            }
            par1World.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150334_T.field_149762_H.field_150501_a, (Blocks.field_150334_T.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150334_T.field_149762_H.func_150494_d() * 0.8f);
        }
        par1World.func_147471_g(x, y, z);
        this.notifyNeighborCube(par1World, x, y, z, (Block)this);
        return true;
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)par1World.func_147438_o(par2, par3, par4);
        if (te != null) {
            boolean fullBlock = false;
            for (int n = 0; n < 6; ++n) {
                if (te.facetype[n] != 1) continue;
                fullBlock = true;
            }
            if (fullBlock) {
                return 0.34f;
            }
        }
        return this.field_149782_v;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (te != null) {
            int face = side.ordinal();
            if (face < 0 || face > 5) {
                return false;
            }
            if (te.facetype[face] == 1) {
                return true;
            }
        }
        return false;
    }

    private int getPasteFaceCount(World world, int x, int y, int z) {
        Block bID = world.func_147439_a(x, y, z);
        if (bID != this) {
            return 0;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return 0;
        }
        int pasteFaces = 0;
        for (int n = 0; n < 6; ++n) {
            if (terp.faces[n] <= 0) continue;
            ++pasteFaces;
        }
        return pasteFaces;
    }

    public static int getSlabFace(World world, int x, int y, int z) {
        Block bID = world.func_147439_a(x, y, z);
        if (bID != RedstonePasteMod.instance.blockRedstonePaste) {
            return -1;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return -1;
        }
        int slabFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] != 1) continue;
            slabFace = n;
        }
        return slabFace;
    }

    public static int getRepeaterComparatorFace(World world, int x, int y, int z) {
        Block bID = world.func_147439_a(x, y, z);
        if (bID != RedstonePasteMod.instance.blockRedstonePaste) {
            return -1;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp == null) {
            return -1;
        }
        int slabFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] == 2) {
                slabFace = n;
            }
            if (terp.facetype[n] != 3) continue;
            slabFace = n;
        }
        return slabFace;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (terp != null) {
            boolean hasSlab = false;
            boolean activeRepeater = false;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] == 2 && (terp.facedata[n] & 4) > 0) {
                    activeRepeater = true;
                }
                if (terp.facetype[n] != 1) continue;
                hasSlab = true;
            }
            if (!hasSlab && activeRepeater) {
                return 9;
            }
        }
        return 0;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityRedstonePaste();
    }

    private class NeighborBlock {
        public int x;
        public int y;
        public int z;
        public Block blockID;
        public TileEntityRedstonePaste terp;
        private byte[] strengths = new byte[6];
        private byte[] indirects = new byte[6];
        private NeighborBlock[] neighbors = new NeighborBlock[6];
        private World world;

        public NeighborBlock(World world, int x1, int y1, int z1) {
            this.x = x1;
            this.y = y1;
            this.z = z1;
            this.world = world;
            this.blockID = world.func_147439_a(this.x, this.y, this.z);
            this.terp = null;
            if (this.blockID == RedstonePasteMod.instance.blockRedstonePaste) {
                this.terp = (TileEntityRedstonePaste)world.func_147438_o(this.x, this.y, this.z);
            }
            for (int n = 0; n < 6; ++n) {
                this.strengths[n] = -1;
                this.indirects[n] = -1;
            }
        }

        public int getMaxPower(int oldpower, int dir) {
            int str = 0;
            if (this.strengths[dir] > -1) {
                str = this.strengths[dir];
            } else {
                str = BlockRedstonePaste.this.getMaxCurrentStrength(this.world, this.x, this.y, this.z, 0, Facing.field_71588_a[dir]);
                this.strengths[dir] = (byte)str;
            }
            return Math.max(oldpower, str);
        }

        public int getMaxIndirectPower(int oldindirect, int dir) {
            int indirect = 0;
            if (this.indirects[dir] > -1) {
                indirect = this.indirects[dir];
            } else {
                BlockRedstonePaste.this.pasteProvidesPower = false;
                indirect = BlockRedstonePaste.this.getIndirectPowerLevelTo_NoWire(this.world, this.x, this.y, this.z, Facing.field_71588_a[dir]);
                BlockRedstonePaste.this.pasteProvidesPower = true;
                this.indirects[dir] = (byte)indirect;
            }
            return Math.max(oldindirect, indirect);
        }

        public NeighborBlock getNeighborBlock(int dir) {
            NeighborBlock newneighbor;
            if (this.neighbors[dir] != null) {
                return this.neighbors[dir];
            }
            int newx = this.x + Facing.field_71586_b[dir];
            int newy = this.y + Facing.field_71587_c[dir];
            int newz = this.z + Facing.field_71585_d[dir];
            this.neighbors[dir] = newneighbor = new NeighborBlock(this.world, newx, newy, newz);
            return newneighbor;
        }
    }
}

