/*
 * Decompiled with CFR 0.152.
 */
package com.tsoft_web.IntelliInput.asm;

import com.tsoft_web.IntelliInput.IntelliInput;
import com.tsoft_web.IntelliInput.asm.IntelliInputCorePlugin;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Opcodes;

public class IntelliInputTransformer
implements IClassTransformer,
Opcodes {
    private static final String[] requiredClass = new String[]{"net.minecraft.client.gui.GuiTextField", "net.minecraft.client.gui.GuiScreenBook", "net.minecraft.client.gui.GuiRepair", "net.minecraft.client.gui.GuiChat", "net.minecraft.client.gui.inventory.GuiEditSign", "net.minecraft.util.ChatAllowedCharacters"};

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (FMLLaunchHandler.side().equals((Object)Side.CLIENT) && Arrays.asList(requiredClass).contains(transformedName) && IntelliInput.isWindows()) {
            try {
                FMLLog.info((String)("[IntelliInput] Replacing : " + name + " " + transformedName), (Object[])new Object[]{""});
                return this.replaceClass(bytes, name, transformedName);
            }
            catch (Exception e) {
                throw new RuntimeException("failed : IntelliInput loading", e);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] replaceClass(byte[] bytes, String name, String transformedName) throws IOException {
        ZipFile zf = null;
        InputStream zi = null;
        if (IntelliInputCorePlugin.location == null) {
            FMLLog.severe((String)("[IntelliInput][ERROR] ReplaceClass failed: " + transformedName), (Object[])new Object[]{""});
            return bytes;
        }
        String readClass = transformedName.replace('.', '/') + ".class";
        try {
            zf = new ZipFile(IntelliInputCorePlugin.location);
            Enumeration<? extends ZipEntry> ents = zf.entries();
            ZipEntry ze = null;
            while (ents.hasMoreElements()) {
                ZipEntry text = ents.nextElement();
                if (!text.getName().equals(readClass)) continue;
                ze = text;
                break;
            }
            if (ze == null) {
                throw new FileNotFoundException("\u52d5\u4f5c\u306b\u5fc5\u8981\u306a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            }
            zi = zf.getInputStream(ze);
            bytes = new byte[(int)ze.getSize()];
            zi.read(bytes);
            FMLLog.info((String)("[IntelliInput] Replace Complete: " + ze.getName()), (Object[])new Object[]{""});
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception ex) {
            FMLLog.severe((String)("[IntelliInput] Class replace failed! " + ex.getMessage() + " Class:" + readClass + " (" + transformedName + ")"), (Object[])new Object[]{""});
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (zi != null) {
                zi.close();
            }
            if (zf != null) {
                zf.close();
            }
        }
    }
}

