/*
 * Decompiled with CFR 0.152.
 */
package com.tsoft_web.IntelliInput.asm;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.tsoft_web.IntelliInput.IntelliInput;
import com.tsoft_web.IntelliInput.TickHandler;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class IntelliInputModContainer
extends DummyModContainer {
    public IntelliInputModContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "intelliinput";
        meta.name = "IntelliInput for 1.7.10";
        meta.version = "2.6";
        meta.authorList = Arrays.asList("TSoft");
        meta.description = "Minecraft\u4e0a\u3067IMM32\u306b\u5bfe\u5fdc\u3057\u305fIME\u3092\u5229\u7528\u53ef\u80fd\u306b\u3059\u308bMOD\u3067\u3059\u3002IntelliInput\u306f\u3001Apache Software License version 2.0\u306eJava Native Access\u3092\u5229\u7528\u30fb\u540c\u68b1\u3057\u3066\u3044\u307e\u3059\u3002";
        meta.url = "http://mcc.mcsv.jp/IntelliInput";
        meta.logoFile = "/IntelliInput2_logo.png";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void init(FMLInitializationEvent evt) {
        if (evt.getSide() == Side.SERVER) {
            this.setEnabledState(false);
            FMLLog.severe((String)"[IntelliInput] IntelliInput is disabled. Don't install to Server!", (Object[])new Object[]{new Object()});
            return;
        }
        if (!IntelliInput.isWindows()) {
            this.setEnabledState(false);
            FMLLog.severe((String)"[IntelliInput] IntelliInput is disabled. Works on Windows only!", (Object[])new Object[]{new Object()});
            return;
        }
        IntelliInput.SearchhWnd();
        IntelliInput.DisableIME();
        FMLCommonHandler.instance().bus().register((Object)this);
        Configuration config = new Configuration(new File(this.getMinecraftDir(), "config/IntelliInput.cfg"));
        Property sanitizing = config.get("fix", "sanitizing", true);
        IntelliInput.sanitizing = sanitizing.getBoolean(true);
        sanitizing.set(IntelliInput.sanitizing);
        Property extendedEndComposition = config.get("fix", "extendedEndComposition", true);
        IntelliInput.extendedEndComposition = extendedEndComposition.getBoolean(true);
        sanitizing.set(IntelliInput.extendedEndComposition);
        Property legacyLengthLimit = config.get("sign", "LegacyLengthLimit", false);
        IntelliInput.legacyLengthLimit = legacyLengthLimit.getBoolean(false);
        legacyLengthLimit.set(IntelliInput.legacyLengthLimit);
        config.save();
        FMLLog.info((String)"-IntelliInput Initialization-", (Object[])new Object[]{new Object()});
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.RenderTickEvent event) {
        TickHandler.run();
    }

    private File getMinecraftDir() {
        return new File(".");
    }
}

