/*
 * Decompiled with CFR 0.152.
 */
package com.tsoft_web.IntelliInput;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import com.tsoft_web.IntelliInput.IMEAttribute;
import com.tsoft_web.IntelliInput.IMEInputText;
import com.tsoft_web.IntelliInput.Imm32;
import com.tsoft_web.IntelliInput.NativeStructure.CandidateList;
import com.tsoft_web.IntelliInput.RedirectWindowProc;
import com.tsoft_web.IntelliInput.User32_Callback;
import cpw.mods.fml.common.FMLLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.settings.KeyBinding;

public class IntelliInput {
    static final User32 user32 = User32.INSTANCE;
    static final User32_Callback user32_cb = User32_Callback.INSTANCE;
    static final Imm32 imm32 = Imm32.INSTANCE;
    static final RedirectWindowProc redirectWindowProc = new RedirectWindowProc();
    static final boolean IS_DEBUG = false;
    private static WinDef.HWND hWnd;
    private static int ProcessId;
    private static Pointer lastHIMC;
    public static boolean lastIMEOpenStatus;
    public static boolean sanitizing;
    public static boolean legacyLengthLimit;
    public static boolean extendedEndComposition;
    public static Integer prevSentence;
    public static Integer prevConversion;
    public static ArrayList<Object> inputFields;

    public static void wakeUp() {
    }

    private static Pointer ImmGetContext() {
        Pointer tmpPointer = imm32.ImmGetContext(hWnd);
        if (tmpPointer == null) {
            // empty if block
        }
        return tmpPointer;
    }

    private static void ImmReleaseContext(Pointer hImc) {
        imm32.ImmReleaseContext(hWnd, hImc);
    }

    public static void DisableIME() {
        IntelliInput.SearchhWnd();
        if (lastHIMC != null) {
            return;
        }
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            lastHIMC = imm32.ImmAssociateContext(hWnd, 0);
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
    }

    public static void EnableIME() {
        IntelliInput.SearchhWnd();
        if (lastHIMC == null) {
            return;
        }
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            imm32.ImmAssociateContext(hWnd, lastHIMC);
            lastHIMC = null;
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
        IntelliInput.resumeConversionStatus();
    }

    public static boolean getOpenIME() {
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            if (imm32.ImmGetOpenStatus(hImc) != 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
    }

    public static void setOpenIME(boolean isEnable) {
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            imm32.ImmSetOpenStatus(hImc, isEnable);
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
    }

    public static void setLastOpenIME() {
        lastIMEOpenStatus = IntelliInput.getOpenIME();
    }

    public static Pointer getHImc() {
        Pointer hImc = IntelliInput.ImmGetContext();
        IntelliInput.ImmReleaseContext(hImc);
        return hImc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OnIMEStartComposition(WinDef.WPARAM RawwParam, WinDef.LPARAM RawlParam) {
        int wParam = RawwParam.intValue();
        int lParam = RawlParam.intValue();
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            for (Object textbox : inputFields) {
                GuiScreenBook guiScreenBook;
                if (textbox instanceof GuiTextField) {
                    GuiTextField guiTextField = (GuiTextField)((Object)textbox);
                    if (!guiTextField.func_146206_l()) continue;
                    return;
                }
                if (textbox instanceof GuiEditSign) {
                    return;
                }
                if (!(textbox instanceof GuiScreenBook) || !(guiScreenBook = (GuiScreenBook)((Object)textbox)).isBookIsUnsigned()) continue;
                return;
            }
            imm32.ImmNotifyIME(hImc, 21, 4, 0);
        }
        catch (Exception ex) {
            IntelliInput.printStacktrace(ex);
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CommitIMEComposition(WinDef.WPARAM RawwParam, WinDef.LPARAM RawlParam) {
        int wParam = RawwParam.intValue();
        int lParam = RawlParam.intValue();
        Pointer hIMC = IntelliInput.ImmGetContext();
        try {
            int bufferLen = imm32.ImmGetCompositionString(hIMC, 2048, null, 0).intValue();
            char[] commitChar = new char[bufferLen];
            imm32.ImmGetCompositionString(hIMC, 2048, commitChar, bufferLen);
            String commitString = IntelliInput.Sanitizing(Native.toString(commitChar));
            for (Object textbox : inputFields) {
                if (textbox instanceof GuiTextField) {
                    GuiTextField guiTextField = (GuiTextField)((Object)textbox);
                    if (!guiTextField.func_146206_l()) continue;
                    guiTextField.imeInputTexts = null;
                    guiTextField.func_146191_b(commitString);
                    break;
                }
                if (textbox instanceof GuiEditSign) {
                    GuiEditSign guiEditSign = (GuiEditSign)((Object)textbox);
                    guiEditSign.commitText(commitString);
                    break;
                }
                if (!(textbox instanceof GuiScreenBook)) continue;
                GuiScreenBook guiScreenBook = (GuiScreenBook)((Object)textbox);
                guiScreenBook.commitText(commitString);
                break;
            }
            IntelliInput.sendNullKeydown();
        }
        catch (Exception ex) {
            IntelliInput.printStacktrace(ex);
        }
        finally {
            IntelliInput.ImmReleaseContext(hIMC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UpdateIMEComposition(WinDef.WPARAM RawwParam, WinDef.LPARAM RawlParam) {
        int wParam = RawwParam.intValue();
        int lParam = RawlParam.intValue();
        Pointer hIMC = IntelliInput.ImmGetContext();
        try {
            int bufferLen = imm32.ImmGetCompositionString(hIMC, 8, null, 0).intValue();
            char[] commitChar = new char[bufferLen];
            imm32.ImmGetCompositionString(hIMC, 8, commitChar, bufferLen);
            String inputText = Native.toString(commitChar);
            IMEAttribute[] imeAttributes = IntelliInput.getCharAttribute();
            if (imeAttributes == null) {
                return;
            }
            ArrayList<IMEInputText> inputTexts = new ArrayList<IMEInputText>();
            for (int i = 0; i < imeAttributes.length; ++i) {
                IMEAttribute imeAttribute = imeAttributes[i];
                char Text = commitChar[i];
                if (i == 0) {
                    inputTexts.add(new IMEInputText(imeAttribute, String.valueOf(Text)));
                    continue;
                }
                IMEInputText lastInputText = (IMEInputText)inputTexts.get(inputTexts.size() - 1);
                if (lastInputText.attribute != imeAttribute) {
                    inputTexts.add(new IMEInputText(imeAttribute, String.valueOf(Text)));
                    continue;
                }
                lastInputText.text = lastInputText.text + IntelliInput.Sanitizing(String.valueOf(Text));
            }
            for (Object textbox : inputFields) {
                if (textbox instanceof GuiTextField) {
                    GuiTextField guiTextField = (GuiTextField)((Object)textbox);
                    if (!guiTextField.func_146206_l()) continue;
                    guiTextField.imeInputTexts = inputTexts;
                } else if (textbox instanceof GuiEditSign) {
                    GuiEditSign guiEditSign = (GuiEditSign)((Object)textbox);
                    guiEditSign.imeInputTexts = inputTexts;
                } else {
                    if (!(textbox instanceof GuiScreenBook)) continue;
                    GuiScreenBook guiScreenBook = (GuiScreenBook)((Object)textbox);
                    guiScreenBook.imeInputTexts = inputTexts;
                }
                break;
            }
        }
        catch (Exception ex) {
            IntelliInput.printStacktrace(ex);
        }
        finally {
            IntelliInput.ImmReleaseContext(hIMC);
        }
    }

    public static void ClearIMEComposition() {
        for (Object textbox : inputFields) {
            if (textbox instanceof GuiTextField) {
                GuiTextField guiTextField = (GuiTextField)((Object)textbox);
                if (!guiTextField.func_146206_l()) continue;
                guiTextField.imeInputTexts = null;
                break;
            }
            if (textbox instanceof GuiEditSign) {
                GuiEditSign guiEditSign = (GuiEditSign)((Object)textbox);
                guiEditSign.imeInputTexts = null;
                break;
            }
            if (!(textbox instanceof GuiScreenBook)) continue;
            GuiScreenBook guiScreenBook = (GuiScreenBook)((Object)textbox);
            guiScreenBook.imeInputTexts = null;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OpenCandidateList(WinDef.WPARAM RawwParam, WinDef.LPARAM RawlParam) {
        int wParam = RawwParam.intValue();
        int lParam = RawlParam.intValue();
        Pointer hIMC = IntelliInput.ImmGetContext();
        try {
            int bufferLen = imm32.ImmGetCandidateListW(hIMC, 0, null, 0);
            if (bufferLen == 0) {
                return;
            }
            char[] tempByte = new char[bufferLen / 2];
            imm32.ImmGetCandidateListW(hIMC, 0, tempByte, bufferLen);
            CandidateList candidateList = new CandidateList(tempByte);
            for (Object textbox : inputFields) {
                if (textbox instanceof GuiTextField) {
                    GuiTextField guiTextField = (GuiTextField)((Object)textbox);
                    if (!guiTextField.func_146206_l()) continue;
                    guiTextField.candidateList = candidateList;
                } else if (textbox instanceof GuiEditSign) {
                    GuiEditSign guiEditSign = (GuiEditSign)((Object)textbox);
                    guiEditSign.candidateList = candidateList;
                } else {
                    if (!(textbox instanceof GuiScreenBook)) continue;
                    GuiScreenBook guiScreenBook = (GuiScreenBook)((Object)textbox);
                    guiScreenBook.candidateList = candidateList;
                }
                break;
            }
        }
        catch (Exception ex) {
            IntelliInput.printStacktrace(ex);
        }
        finally {
            IntelliInput.ImmReleaseContext(hIMC);
        }
    }

    public static void closeCandidateList() {
        for (Object textbox : inputFields) {
            if (textbox instanceof GuiTextField) {
                GuiTextField guiTextField = (GuiTextField)((Object)textbox);
                if (!guiTextField.func_146206_l()) continue;
                guiTextField.candidateList = null;
                break;
            }
            if (textbox instanceof GuiEditSign) {
                GuiEditSign guiEditSign = (GuiEditSign)((Object)textbox);
                guiEditSign.candidateList = null;
                break;
            }
            if (!(textbox instanceof GuiScreenBook)) continue;
            GuiScreenBook guiScreenBook = (GuiScreenBook)((Object)textbox);
            guiScreenBook.candidateList = null;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMEAttribute[] getCharAttribute() {
        Pointer hIMC = IntelliInput.ImmGetContext();
        try {
            int bufferLen = imm32.ImmGetCompositionStringW(hIMC, 16, null, 0).intValue();
            if (bufferLen == 0) {
                IMEAttribute[] iMEAttributeArray = null;
                return iMEAttributeArray;
            }
            byte[] tempChar = new byte[bufferLen];
            imm32.ImmGetCompositionStringW(hIMC, 16, tempChar, bufferLen);
            IMEAttribute[] retValue = new IMEAttribute[bufferLen];
            String teString = "";
            for (int i = 0; i < tempChar.length; ++i) {
                retValue[i] = IMEAttribute.setInt(tempChar[i]);
                teString = teString + retValue[i].toString() + " , ";
            }
            IMEAttribute[] iMEAttributeArray = retValue;
            return iMEAttributeArray;
        }
        catch (Exception ex) {
            IntelliInput.printStacktrace(ex);
        }
        finally {
            IntelliInput.ImmReleaseContext(hIMC);
        }
        return null;
    }

    public static void SearchhWnd() {
        if (hWnd != null) {
            return;
        }
        user32.EnumWindows(new WinUser.WNDENUMPROC(){

            @Override
            public boolean callback(WinDef.HWND hWnd, Pointer userData) {
                char[] windowText = new char[128];
                user32.GetWindowText(hWnd, windowText, 128);
                String wText = Native.toString(windowText);
                String string = wText = wText.isEmpty() ? "" : wText;
                if (wText.contains("Minecraft")) {
                    char[] classText = new char[128];
                    user32.GetClassName(hWnd, classText, 128);
                    String cText = Native.toString(classText);
                    String string2 = cText = cText.isEmpty() ? "" : cText;
                    if (cText.equalsIgnoreCase("LWJGL")) {
                        IntByReference retPID = new IntByReference();
                        user32.GetWindowThreadProcessId(hWnd, retPID);
                        if (retPID.getValue() == IntelliInput.getProcessId()) {
                            hWnd = hWnd;
                            IntelliInput.ToSubclass();
                            user32_cb.SetActiveWindow(hWnd);
                            IntelliInput.sendNullKeydown();
                            IntelliInput.DisableIME();
                            return false;
                        }
                    }
                }
                return true;
            }
        }, null);
    }

    private static void ToSubclass() {
        if (IntelliInput.getOsBit() == 32) {
            RedirectWindowProc.prevWndProcInteger = user32.GetWindowLong(hWnd, -4);
            user32_cb.SetWindowLong(hWnd, -4, redirectWindowProc);
        } else {
            RedirectWindowProc.prevWndProc = user32.GetWindowLongPtr(hWnd, -4);
            user32_cb.SetWindowLongPtr(hWnd, -4, redirectWindowProc);
        }
    }

    public static int getProcessId() {
        if (ProcessId == 0) {
            int pid;
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            String vmName = bean.getName();
            ProcessId = pid = Integer.valueOf(vmName.split("@")[0]).intValue();
        }
        return ProcessId;
    }

    public static WinDef.HWND gethWnd() {
        if (hWnd == null) {
            IntelliInput.SearchhWnd();
        }
        return hWnd;
    }

    public static void sethWnd(WinDef.HWND value) {
        hWnd = value;
    }

    public static void sendNullKeydown() {
        block5: {
            block4: {
                if (RedirectWindowProc.prevWndProc != null) break block4;
                if (RedirectWindowProc.prevWndProcInteger == null) break block5;
            }
            if (!hWnd.equals(user32_cb.GetForegroundWindow())) {
                return;
            }
            WinUser.INPUT input = new WinUser.INPUT();
            input.type = new WinDef.DWORD(1L);
            input.input = new WinUser.INPUT.INPUT_UNION();
            input.input.setType("ki");
            input.input.ki.wVk = new WinDef.WORD(168L);
            input.input.ki.wScan = new WinDef.WORD((long)user32_cb.MapVirtualKeyA(168, 0));
            input.input.ki.dwFlags = new WinDef.DWORD(1L);
            WinUser.INPUT[] inArray = new WinUser.INPUT[]{input};
            int n = user32.SendInput(new WinDef.DWORD(1L), inArray, inArray[0].size()).intValue();
        }
    }

    public static void checkHandler() {
        if (hWnd != null && !user32_cb.IsWindow(hWnd)) {
            hWnd = null;
            IntelliInput.SearchhWnd();
        }
    }

    private static final int getOsBit() {
        String os = System.getProperty("sun.arch.data.mode");
        if (os != null && (os = os.trim()).length() > 0) {
            if ("32".equals(os)) {
                return 32;
            }
            if ("64".equals(os)) {
                return 64;
            }
        }
        if ((os = System.getProperty("os.arch")) == null || (os = os.trim()).length() <= 0) {
            return -1;
        }
        if (os.endsWith("32")) {
            return 32;
        }
        if (os.endsWith("64")) {
            return 64;
        }
        return 32;
    }

    public static String Sanitizing(String string) {
        if (sanitizing) {
            return string.replace("\uff08", "(").replace("\uff09", ")").replace("\uff5b", "{").replace("\uff5d", "}");
        }
        return string;
    }

    public static void changeToAlphabetInput() {
        IntelliInput.SearchhWnd();
        if (lastHIMC != null) {
            return;
        }
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            IntByReference sentence = new IntByReference();
            IntByReference conversion = new IntByReference();
            if (imm32.ImmGetConversionStatus(hImc, conversion, sentence)) {
                prevSentence = sentence.getValue();
                prevConversion = conversion.getValue();
                imm32.ImmSetConversionStatus(hImc, 0, sentence.getValue());
            }
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
    }

    public static void resumeConversionStatus() {
        IntelliInput.SearchhWnd();
        if (lastHIMC != null) {
            return;
        }
        Pointer hImc = IntelliInput.ImmGetContext();
        try {
            if (prevSentence != null && prevConversion != null) {
                imm32.ImmSetConversionStatus(hImc, prevConversion, prevSentence);
                prevConversion = null;
                prevSentence = null;
            }
        }
        finally {
            IntelliInput.ImmReleaseContext(hImc);
        }
    }

    public static boolean canTextboxInput(GuiTextField guiTextField) {
        return guiTextField.func_146206_l() && guiTextField.isEnabled();
    }

    public static boolean isKeyBindingPressed(KeyBinding keybinding) {
        return keybinding.func_151468_f();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static void printStacktrace(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String trace = sw.toString();
        FMLLog.warning((String)trace, (Object[])new Object[]{new Object()});
    }

    static {
        sanitizing = false;
        legacyLengthLimit = false;
        extendedEndComposition = false;
        prevSentence = null;
        prevConversion = null;
        inputFields = new ArrayList();
    }
}

