/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.PlayerChunkViewerTracker;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerManager {
    public LinkedList<PlayerChunkViewerTracker> playerViewers = new LinkedList();
    public HashMap<ForgeChunkManager.Ticket, Integer> ticketIDs = new HashMap();
    private int ticketID = 0;
    private int time = 0;
    private HashMap<Integer, HashSet<ChunkCoordIntPair>> lastLoadedChunkMap = new HashMap();
    public LinkedList<ChunkChange> chunkChanges = new LinkedList();
    public LinkedList<TicketChange> ticketChanges = new LinkedList();
    public LinkedList<DimensionChange> dimChanges = new LinkedList();
    public LinkedList<String> logouts = new LinkedList();
    public LinkedList<String> addViewers = new LinkedList();
    private static PlayerChunkViewerManager instance;

    public static PlayerChunkViewerManager instance() {
        if (instance == null) {
            instance = new PlayerChunkViewerManager();
        }
        return instance;
    }

    public void update() {
        ++this.time;
        for (String string : this.logouts) {
            Iterator iterator = this.playerViewers.iterator();
            while (iterator.hasNext()) {
                if (!((PlayerChunkViewerTracker)iterator.next()).owner.func_70005_c_().equals(string)) continue;
                iterator.remove();
            }
        }
        for (String string : this.logouts) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.removePlayer(string);
            }
        }
        for (DimensionChange dimensionChange : this.dimChanges) {
            if (!dimensionChange.add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.loadDimension(dimensionChange.world);
            }
        }
        for (ChunkChange chunkChange : this.chunkChanges) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.sendChunkChange(chunkChange);
            }
        }
        for (TicketChange ticketChange : this.ticketChanges) {
            if (this.ticketIDs.containsKey(ticketChange.ticket)) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.sendTicketChange(ticketChange);
                }
                continue;
            }
            this.ticketIDs.put(ticketChange.ticket, this.ticketID++);
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.addTicket(CommonUtils.getDimension((World)ticketChange.ticket.world), ticketChange.ticket);
            }
        }
        for (DimensionChange dimensionChange : this.dimChanges) {
            if (dimensionChange.add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.unloadDimension(CommonUtils.getDimension((World)dimensionChange.world));
            }
        }
        if (this.time % 10 == 0) {
            for (EntityPlayer entityPlayer : ServerUtils.getPlayers()) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.updatePlayer(entityPlayer);
                }
            }
        }
        for (String string : this.addViewers) {
            EntityPlayerMP player = ServerUtils.getPlayer((String)string);
            if (player == null) continue;
            if (this.playerViewers.isEmpty()) {
                this.updateChunkChangeMap();
            }
            this.playerViewers.add(new PlayerChunkViewerTracker((EntityPlayer)player, this));
        }
        this.addViewers.clear();
        this.dimChanges.clear();
        this.logouts.clear();
        this.chunkChanges.clear();
        this.ticketChanges.clear();
    }

    private void updateChunkChangeMap() {
        for (WorldServer world : DimensionManager.getWorlds()) {
            HashSet<ChunkCoordIntPair> allChunks = new HashSet<ChunkCoordIntPair>();
            ArrayList loadedChunkCopy = new ArrayList(world.field_73059_b.field_73245_g);
            for (Chunk chunk : loadedChunkCopy) {
                allChunks.add(chunk.func_76632_l());
            }
            this.lastLoadedChunkMap.put(CommonUtils.getDimension((World)world), allChunks);
        }
    }

    public void calculateChunkChanges(WorldServer world) {
        if (this.playerViewers.isEmpty()) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        HashSet<Object> wasLoadedChunks = this.lastLoadedChunkMap.get(dimension);
        if (wasLoadedChunks == null) {
            wasLoadedChunks = new HashSet();
        }
        HashSet<ChunkCoordIntPair> allChunks = new HashSet<ChunkCoordIntPair>();
        ArrayList loadedChunkCopy = new ArrayList(world.field_73059_b.field_73245_g);
        for (Chunk chunk : loadedChunkCopy) {
            ChunkCoordIntPair coord = chunk.func_76632_l();
            allChunks.add(coord);
            if (wasLoadedChunks.remove(coord)) continue;
            this.chunkChanges.add(new ChunkChange(dimension, coord, true));
        }
        for (ChunkCoordIntPair chunkCoordIntPair : wasLoadedChunks) {
            this.chunkChanges.add(new ChunkChange(dimension, chunkCoordIntPair, false));
        }
        this.lastLoadedChunkMap.put(dimension, allChunks);
    }

    public boolean isViewerOpen(String username) {
        for (PlayerChunkViewerTracker tracker : this.playerViewers) {
            if (!tracker.owner.func_70005_c_().equals(username)) continue;
            return true;
        }
        return false;
    }

    public static void serverShutdown() {
        instance = null;
    }

    public void closeViewer(String username) {
        Iterator iterator = this.playerViewers.iterator();
        while (iterator.hasNext()) {
            if (!((PlayerChunkViewerTracker)iterator.next()).owner.func_70005_c_().equals(username)) continue;
            iterator.remove();
        }
    }

    public static class DimensionChange {
        public final WorldServer world;
        public final boolean add;

        public DimensionChange(WorldServer world, boolean add) {
            this.world = world;
            this.add = add;
        }
    }

    public static class ChunkChange {
        public final ChunkCoordIntPair chunk;
        public final boolean add;
        public final int dimension;

        public ChunkChange(int dimension, ChunkCoordIntPair chunk, boolean add) {
            this.dimension = dimension;
            this.chunk = chunk;
            this.add = add;
        }
    }

    public static class TicketChange {
        public final ForgeChunkManager.Ticket ticket;
        public final ChunkCoordIntPair chunk;
        public final boolean force;
        public final int dimension;

        public TicketChange(ForgeChunkManager.Ticket ticket, ChunkCoordIntPair chunk, boolean force) {
            this.ticket = ticket;
            this.dimension = CommonUtils.getDimension((World)ticket.world);
            this.chunk = chunk;
            this.force = force;
        }
    }
}

