/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.ISerializable;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import io.netty.buffer.ByteBuf;

public class PipeRenderState
implements ISerializable {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    private boolean glassColorDirty = false;
    private byte glassColor = (byte)-127;
    private boolean dirty = true;

    public void clean() {
        this.dirty = false;
        this.glassColorDirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.wireMatrix.clean();
    }

    public byte getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(byte color) {
        if (this.glassColor != color) {
            this.glassColor = color;
            this.glassColorDirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.glassColorDirty || this.textureMatrix.isDirty() || this.wireMatrix.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.glassColorDirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty();
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.glassColor < -1 ? -1 : (int)this.glassColor);
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
    }

    @Override
    public void readData(ByteBuf data) {
        byte g = data.readByte();
        if (g != this.glassColor) {
            this.glassColor = g;
            this.glassColorDirty = true;
        }
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
    }
}

