/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.power.ILaserTarget;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.AverageInt;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileLaserTableBase
extends TileBuildCraft
implements ILaserTarget,
IInventory,
IHasWork {
    public int clientRequiredEnergy = 0;
    protected SimpleInventory inv = new SimpleInventory(this.func_70302_i_(), "inv", 64);
    private int energy = 0;
    private int recentEnergyAverage;
    private AverageInt recentEnergyAverageUtil = new AverageInt(20);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.recentEnergyAverageUtil.tick();
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void addEnergy(int energy) {
        this.energy += energy;
    }

    public void subtractEnergy(int energy) {
        this.energy -= energy;
    }

    public abstract int getRequiredEnergy();

    public int getProgressScaled(int ratio) {
        if (this.clientRequiredEnergy == 0) {
            return 0;
        }
        if (this.energy >= this.clientRequiredEnergy) {
            return ratio;
        }
        return (int)((double)this.energy / (double)this.clientRequiredEnergy * (double)ratio);
    }

    public int getRecentEnergyAverage() {
        return this.recentEnergyAverage;
    }

    public abstract boolean canCraft();

    @Override
    public boolean requiresLaserEnergy() {
        return this.canCraft() && (float)this.energy < (float)this.getRequiredEnergy() * 5.0f;
    }

    @Override
    public void receiveLaserEnergy(int energy) {
        this.energy += energy;
        this.recentEnergyAverageUtil.push(energy);
    }

    @Override
    public boolean isInvalidTarget() {
        return this.func_145837_r();
    }

    @Override
    public double getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public double getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public double getZCoord() {
        return this.field_145849_e;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && !this.func_145837_r();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt, "inv");
        nbt.func_74768_a("energy", this.energy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt, "inv");
        this.energy = nbt.func_74762_e("energy");
    }

    protected void outputStack(ItemStack remaining, boolean autoEject) {
        this.outputStack(remaining, null, 0, autoEject);
    }

    protected void outputStack(ItemStack remaining, IInventory inv, int slot, boolean autoEject) {
        if (autoEject) {
            if (remaining != null && remaining.field_77994_a > 0) {
                remaining.field_77994_a -= Utils.addToRandomInventoryAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, remaining);
            }
            if (remaining != null && remaining.field_77994_a > 0) {
                remaining.field_77994_a -= Utils.addToRandomInjectableAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN, remaining);
            }
        }
        if (inv != null && remaining != null && remaining.field_77994_a > 0) {
            ItemStack inside = inv.func_70301_a(slot);
            if (inside == null || inside.field_77994_a <= 0) {
                inv.func_70299_a(slot, remaining);
                return;
            }
            if (StackHelper.canStacksMerge(inside, remaining)) {
                remaining.field_77994_a -= StackHelper.mergeStacks(remaining, inside, true);
            }
        }
        if (remaining != null && remaining.field_77994_a > 0) {
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, remaining);
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public void getGUINetworkData(int id, int data) {
        int currentStored = this.energy;
        int requiredEnergy = this.clientRequiredEnergy;
        switch (id) {
            case 0: {
                this.clientRequiredEnergy = requiredEnergy = requiredEnergy & 0xFFFF0000 | data & 0xFFFF;
                break;
            }
            case 1: {
                this.energy = currentStored = currentStored & 0xFFFF0000 | data & 0xFFFF;
                break;
            }
            case 2: {
                this.clientRequiredEnergy = requiredEnergy = requiredEnergy & 0xFFFF | (data & 0xFFFF) << 16;
                break;
            }
            case 3: {
                this.energy = currentStored = currentStored & 0xFFFF | (data & 0xFFFF) << 16;
                break;
            }
            case 4: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF0000 | data & 0xFFFF;
                break;
            }
            case 5: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF | (data & 0xFFFF) << 16;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int requiredEnergy = this.getRequiredEnergy();
        int currentStored = this.energy;
        int lRecentEnergy = (int)(this.recentEnergyAverageUtil.getAverage() * 100.0);
        iCrafting.func_71112_a(container, 0, requiredEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 1, currentStored & 0xFFFF);
        iCrafting.func_71112_a(container, 2, requiredEnergy >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 3, currentStored >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 5, lRecentEnergy >>> 16 & 0xFFFF);
    }
}

