/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.common.recipe.inputs.MachineInput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidInput
extends MachineInput<FluidInput> {
    public FluidStack ingredient;

    public FluidInput(FluidStack stack) {
        this.ingredient = stack;
    }

    public FluidInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.ingredient = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("input"));
    }

    @Override
    public FluidInput copy() {
        return new FluidInput(this.ingredient.copy());
    }

    @Override
    public boolean isValid() {
        return this.ingredient != null;
    }

    public boolean useFluid(FluidTank fluidTank, boolean deplete, int scale) {
        if (fluidTank.getFluid() != null && fluidTank.getFluid().containsFluid(this.ingredient)) {
            fluidTank.drain(this.ingredient.amount * scale, deplete);
            return true;
        }
        return false;
    }

    @Override
    public int hashIngredients() {
        return this.ingredient.getFluid() != null ? this.ingredient.getFluid().hashCode() : 0;
    }

    @Override
    public boolean testEquality(FluidInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return this.ingredient.equals((Object)other.ingredient);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof FluidInput;
    }
}

