/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Tier;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderEnergyCube
extends TileEntitySpecialRenderer {
    public static int[][] COLORS = new int[][]{{100, 210, 125}, {215, 85, 70}, {80, 125, 230}, {154, 120, 200}, {0, 0, 0}};
    private ModelEnergyCube model = new ModelEnergyCube();
    private ModelEnergyCube.ModelEnergyCore core = new ModelEnergyCube.ModelEnergyCore();
    public static Map<Tier.EnergyCubeTier, ResourceLocation> resources = new HashMap<Tier.EnergyCubeTier, ResourceLocation>();
    public static ResourceLocation baseTexture = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "EnergyCube.png");
    public static ResourceLocation coreTexture = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "EnergyCore.png");

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityEnergyCube)tileEntity, x, y, z, partialTick);
    }

    private void renderAModelAt(TileEntityEnergyCube tileEntity, double x, double y, double z, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(baseTexture);
        switch (tileEntity.facing) {
            case 0: {
                GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)-1.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f, tileEntity.tier, this.field_147501_a.field_147553_e);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.func_147499_a(baseTexture);
            this.model.renderSide(0.0625f, side, tileEntity.configComponent.getOutput((TransmissionType)TransmissionType.ENERGY, (int)side.ordinal()).ioState, tileEntity.tier, this.field_147501_a.field_147553_e);
        }
        GL11.glPopMatrix();
        if (tileEntity.getEnergy() / tileEntity.getMaxEnergy() > 0.1) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            this.func_147499_a(coreTexture);
            MekanismRenderer.blendOn();
            MekanismRenderer.glowOn();
            int[] c = COLORS[tileEntity.tier.getBaseTier().ordinal()];
            GL11.glPushMatrix();
            GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
            GL11.glColor4f((float)((float)c[0] / 255.0f), (float)((float)c[1] / 255.0f), (float)((float)c[2] / 255.0f), (float)((float)(tileEntity.getEnergy() / tileEntity.getMaxEnergy())));
            GL11.glTranslatef((float)0.0f, (float)((float)Math.sin(Math.toRadians(((float)MekanismClient.ticksPassed + partialTick) * 3.0f)) / 7.0f), (float)0.0f);
            GL11.glRotatef((float)(((float)MekanismClient.ticksPassed + partialTick) * 4.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(36.0f + ((float)MekanismClient.ticksPassed + partialTick) * 4.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            this.core.render(0.0625f);
            GL11.glPopMatrix();
            MekanismRenderer.glowOff();
            MekanismRenderer.blendOff();
            GL11.glPopMatrix();
        }
        MekanismRenderer.machineRenderer.renderAModelAt(tileEntity, x, y, z, partialTick);
    }

    static {
        if (resources.isEmpty()) {
            for (Tier.EnergyCubeTier tier : Tier.EnergyCubeTier.values()) {
                resources.put(tier, MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "EnergyCube" + tier.getBaseTier().getName() + ".png"));
            }
        }
    }
}

