/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.TileEntityDigitalMiner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import org.lwjgl.opengl.GL11;

public final class MinerVisualRenderer {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static Map<MinerRenderData, MekanismRenderer.DisplayInteger> cachedVisuals = new HashMap<MinerRenderData, MekanismRenderer.DisplayInteger>();
    private static final double offset = 0.01;

    public static void render(TileEntityDigitalMiner miner) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)MinerVisualRenderer.getX(miner.field_145851_c), (double)MinerVisualRenderer.getY(miner.field_145848_d), (double)MinerVisualRenderer.getZ(miner.field_145849_e));
        MekanismRenderer.blendOn();
        MekanismRenderer.glowOn();
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        mc.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
        MinerVisualRenderer.getList(new MinerRenderData(miner)).render();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private static MekanismRenderer.DisplayInteger getList(MinerRenderData data) {
        if (cachedVisuals.containsKey(data)) {
            return cachedVisuals.get(data);
        }
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        cachedVisuals.put(data, display);
        ArrayList<MekanismRenderer.Model3D> models = new ArrayList<MekanismRenderer.Model3D>();
        for (int x = -data.radius; x <= data.radius; ++x) {
            for (int y = data.minY - data.yCoord; y <= data.maxY - data.yCoord; ++y) {
                for (int z = -data.radius; z <= data.radius; ++z) {
                    if (x != -data.radius && x != data.radius && y != data.minY - data.yCoord && y != data.maxY - data.yCoord && z != -data.radius && z != data.radius) continue;
                    models.add(MinerVisualRenderer.createModel(new Coord4D(x, y, z, MinerVisualRenderer.mc.field_71441_e.field_73011_w.field_76574_g)));
                }
            }
        }
        for (MekanismRenderer.Model3D model : models) {
            MekanismRenderer.renderObject(model);
        }
        display.endList();
        return display;
    }

    private static MekanismRenderer.Model3D createModel(Coord4D rel) {
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.setBlockBounds((double)rel.xCoord + 0.4, (double)rel.yCoord + 0.4, (double)rel.zCoord + 0.4, (double)rel.xCoord + 0.6, (double)rel.yCoord + 0.6, (double)rel.zCoord + 0.6);
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getColorIcon(EnumColor.WHITE));
        return toReturn;
    }

    private static double getX(int x) {
        return (double)x - TileEntityRendererDispatcher.field_147554_b;
    }

    private static double getY(int y) {
        return (double)y - TileEntityRendererDispatcher.field_147555_c;
    }

    private static double getZ(int z) {
        return (double)z - TileEntityRendererDispatcher.field_147552_d;
    }

    public static class MinerRenderData {
        public int minY;
        public int maxY;
        public int radius;
        public int yCoord;

        public MinerRenderData(int min, int max, int rad, int y) {
            this.minY = min;
            this.maxY = max;
            this.radius = rad;
            this.yCoord = y;
        }

        public MinerRenderData(TileEntityDigitalMiner miner) {
            this(miner.minY, miner.maxY, miner.radius, miner.field_145848_d);
        }

        public boolean equals(Object data) {
            return data instanceof MinerRenderData && ((MinerRenderData)data).minY == this.minY && ((MinerRenderData)data).maxY == this.maxY && ((MinerRenderData)data).radius == this.radius && ((MinerRenderData)data).yCoord == this.yCoord;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.minY;
            code = 31 * code + this.maxY;
            code = 31 * code + this.radius;
            code = 31 * code + this.yCoord;
            return code;
        }
    }
}

