/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import openmods.gui.listener.IKeyTypedListener;
import openmods.gui.listener.IMouseDownListener;
import openmods.gui.listener.IMouseDragListener;
import openmods.gui.listener.IMouseUpListener;
import openmods.utils.TextureUtils;
import org.lwjgl.opengl.GL11;

public abstract class BaseComponent
extends Gui {
    protected static final RenderItem ITEM_RENDERER = new RenderItem();
    private static final int CRAZY_1 = 0x505000FF;
    private static final int CRAZY_2 = 2621567;
    private static final int CRAZY_3 = -267386864;
    public static final ResourceLocation TEXTURE_SHEET = new ResourceLocation("openmodslib", "textures/gui/components.png");
    protected int x;
    protected int y;
    protected boolean enabled = true;
    private IKeyTypedListener keyListener;
    private IMouseDownListener mouseDownListener;
    private IMouseUpListener mouseUpListener;
    private IMouseDragListener mouseDragListener;

    public static void bindComponentsSheet() {
        TextureUtils.bindTextureToClient(TEXTURE_SHEET);
    }

    public BaseComponent(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.getWidth() && mouseY >= this.y && mouseY < this.y + this.getHeight();
    }

    public void setListener(IKeyTypedListener keyListener) {
        this.keyListener = keyListener;
    }

    public void setListener(IMouseDownListener mouseDownListener) {
        this.mouseDownListener = mouseDownListener;
    }

    public void setListener(IMouseUpListener mouseUpListener) {
        this.mouseUpListener = mouseUpListener;
    }

    public void setListener(IMouseDragListener mouseDragListener) {
        this.mouseDragListener = mouseDragListener;
    }

    public abstract void render(Minecraft var1, int var2, int var3, int var4, int var5);

    public abstract void renderOverlay(Minecraft var1, int var2, int var3, int var4, int var5);

    public void keyTyped(char keyChar, int keyCode) {
        if (this.keyListener != null) {
            this.keyListener.componentKeyTyped(this, keyChar, keyCode);
        }
    }

    public void mouseDown(int mouseX, int mouseY, int button) {
        if (this.mouseDownListener != null) {
            this.mouseDownListener.componentMouseDown(this, mouseX, mouseY, button);
        }
    }

    public void mouseUp(int mouseX, int mouseY, int button) {
        if (this.mouseUpListener != null) {
            this.mouseUpListener.componentMouseUp(this, mouseX, mouseY, button);
        }
    }

    public void mouseDrag(int mouseX, int mouseY, int button, long time) {
        if (this.mouseDragListener != null) {
            this.mouseDragListener.componentMouseDrag(this, mouseX, mouseY, button, time);
        }
    }

    public boolean isTicking() {
        return false;
    }

    public void tick() {
    }

    private void drawFancyBox(int width, int left, int top, int height) {
        this.func_73733_a(left - 3, top - 4, left + width + 3, top - 3, -267386864, -267386864);
        this.func_73733_a(left - 3, top + height + 3, left + width + 3, top + height + 4, -267386864, -267386864);
        this.func_73733_a(left - 3, top - 3, left + width + 3, top + height + 3, -267386864, -267386864);
        this.func_73733_a(left - 4, top - 3, left - 3, top + height + 3, -267386864, -267386864);
        this.func_73733_a(left + width + 3, top - 3, left + width + 4, top + height + 3, -267386864, -267386864);
        this.func_73733_a(left - 3, top - 3 + 1, left - 3 + 1, top + height + 3 - 1, 0x505000FF, 2621567);
        this.func_73733_a(left + width + 2, top - 3 + 1, left + width + 3, top + height + 3 - 1, 0x505000FF, 2621567);
        this.func_73733_a(left - 3, top - 3, left + width + 3, top - 3 + 1, 0x505000FF, 0x505000FF);
        this.func_73733_a(left - 3, top + height + 2, left + width + 3, top + height + 3, 2621567, 2621567);
    }

    protected void drawHoveringText(String line, int x, int y, FontRenderer font) {
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        this.field_73735_i = 350.0f;
        int width = font.func_78256_a(line);
        this.drawFancyBox(width, x + 12, y - 12, 8);
        font.func_78261_a(line, x + 12, y - 12, -1);
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    protected void drawHoveringText(List<String> lines, int x, int y, FontRenderer font) {
        int lineCount = lines.size();
        if (lineCount == 0) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        int width = 0;
        for (String s : lines) {
            int l = font.func_78256_a(s);
            if (l <= width) continue;
            width = l;
        }
        int left = x + 12;
        int top = y - 12;
        int height = 8;
        if (lineCount > 1) {
            height += 2 + (lineCount - 1) * 10;
        }
        this.field_73735_i = 350.0f;
        this.drawFancyBox(width, left, top, height);
        for (int i = 0; i < lineCount; ++i) {
            String line = lines.get(i);
            font.func_78261_a(line, left, top, -1);
            if (i == 0) {
                top += 2;
            }
            top += 10;
        }
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void drawItemStack(ItemStack stack, int x, int y, String overlayText) {
        this.field_73735_i = 200.0f;
        BaseComponent.ITEM_RENDERER.field_77023_b = 200.0f;
        RenderHelper.func_74520_c();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2977);
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        ITEM_RENDERER.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        ITEM_RENDERER.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y, overlayText);
        this.field_73735_i = 0.0f;
        BaseComponent.ITEM_RENDERER.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }
}

