/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import openmods.calc.BinaryOperator;
import openmods.calc.OperatorDictionary;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.IAstParser;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IExprNodeFactory;
import openmods.calc.parsing.IModifierStateTransition;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.calc.parsing.TokenUtils;
import openmods.calc.parsing.UnfinishedExpressionException;

public class PrefixParser<E>
implements IAstParser<E> {
    private final OperatorDictionary<E> operators;
    private final IExprNodeFactory<E> exprNodeFactory;

    public PrefixParser(OperatorDictionary<E> operators, IExprNodeFactory<E> exprNodeFactory) {
        this.operators = operators;
        this.exprNodeFactory = exprNodeFactory;
    }

    private static Token next(Iterator<Token> input) {
        try {
            return input.next();
        }
        catch (NoSuchElementException e) {
            throw new UnfinishedExpressionException();
        }
    }

    protected IExprNode<E> parseNode(ICompilerState<E> state, PeekingIterator<Token> input) {
        Token token = PrefixParser.next(input);
        return this.parseNode(state, input, token);
    }

    private IExprNode<E> parseNode(ICompilerState<E> state, PeekingIterator<Token> input, Token firstToken) {
        if (firstToken.type.isValue()) {
            return this.exprNodeFactory.createValueNode(firstToken);
        }
        switch (firstToken.type) {
            case SYMBOL: {
                return this.exprNodeFactory.createSymbolGetNode(firstToken.value);
            }
            case MODIFIER: {
                return this.parseModifierNode(firstToken.value, state, input);
            }
            case LEFT_BRACKET: {
                return this.parseNestedNode(firstToken.value, state, input);
            }
        }
        throw new IllegalArgumentException("Unexpected token: " + firstToken);
    }

    private IExprNode<E> parseNestedNode(String openingBracket, ICompilerState<E> state, PeekingIterator<Token> input) {
        String closingBracket = TokenUtils.getClosingBracket(openingBracket);
        if (openingBracket.equals("(")) {
            Token operationToken = PrefixParser.next(input);
            String operationName = operationToken.value;
            if (operationToken.type == TokenType.SYMBOL) {
                ISymbolCallStateTransition<E> stateTransition = state.getStateForSymbolCall(operationName);
                List<IExprNode<E>> args = this.collectArgs(openingBracket, closingBracket, input, stateTransition.getState());
                return stateTransition.createRootNode(args);
            }
            if (operationToken.type == TokenType.OPERATOR) {
                List<IExprNode<E>> args = this.collectArgs(openingBracket, closingBracket, input, state);
                if (args.size() == 1) {
                    UnaryOperator<E> unaryOperator = this.operators.getUnaryOperator(operationName);
                    Preconditions.checkState((unaryOperator != null ? 1 : 0) != 0, (String)"Invalid unary operator '%s'", (Object[])new Object[]{operationName});
                    return this.exprNodeFactory.createUnaryOpNode(unaryOperator, args.get(0));
                }
                if (args.size() > 1) {
                    BinaryOperator<E> binaryOperator = this.operators.getBinaryOperator(operationName);
                    Preconditions.checkState((binaryOperator != null ? 1 : 0) != 0, (String)"Invalid binary operator '%s'", (Object[])new Object[]{operationName});
                    return this.compileBinaryOpNode(binaryOperator, args);
                }
                throw new IllegalArgumentException("Called operator " + operationName + " without any arguments");
            }
            IExprNode<E> target = this.parseNode(state, input, operationToken);
            List<IExprNode<E>> args = this.collectArgs(openingBracket, closingBracket, input, state);
            return this.exprNodeFactory.createBinaryOpNode(this.operators.getDefaultOperator(), target, this.exprNodeFactory.createBracketNode(openingBracket, closingBracket, args));
        }
        List<IExprNode<E>> args = this.collectArgs(openingBracket, closingBracket, input, state);
        return this.exprNodeFactory.createBracketNode(openingBracket, closingBracket, args);
    }

    private List<IExprNode<E>> collectArgs(String openingBracket, String closingBracket, PeekingIterator<Token> input, ICompilerState<E> state) {
        Token argToken;
        ArrayList args = Lists.newArrayList();
        while (true) {
            argToken = (Token)input.peek();
            if (argToken.type == TokenType.SEPARATOR) {
                PrefixParser.next(input);
                continue;
            }
            if (argToken.type == TokenType.RIGHT_BRACKET) break;
            IAstParser<E> newParser = state.getParser();
            IExprNode<E> parsedNode = newParser.parse(state, input);
            args.add(parsedNode);
        }
        Preconditions.checkState((boolean)argToken.value.equals(closingBracket), (String)"Unmatched brackets: '%s' and '%s'", (Object[])new Object[]{openingBracket, argToken.value});
        PrefixParser.next(input);
        return args;
    }

    private IExprNode<E> parseModifierNode(String modifier, ICompilerState<E> state, PeekingIterator<Token> input) {
        IModifierStateTransition<E> stateTransition = state.getStateForModifier(modifier);
        ICompilerState<E> newState = stateTransition.getState();
        IAstParser<E> newParser = newState.getParser();
        IExprNode<E> parsedNode = newParser.parse(newState, input);
        return stateTransition.createRootNode(parsedNode);
    }

    private IExprNode<E> compileBinaryOpNode(BinaryOperator<E> op, List<IExprNode<E>> args) {
        if (op.associativity == BinaryOperator.Associativity.LEFT) {
            IExprNode<E> left = args.get(0);
            IExprNode<E> right = args.get(1);
            for (int i = 2; i < args.size(); ++i) {
                left = this.exprNodeFactory.createBinaryOpNode(op, left, right);
                right = args.get(i);
            }
            return this.exprNodeFactory.createBinaryOpNode(op, left, right);
        }
        int lastArg = args.size() - 1;
        IExprNode<E> left = args.get(lastArg - 1);
        IExprNode<E> right = args.get(lastArg);
        for (int i = lastArg - 2; i >= 0; --i) {
            right = this.exprNodeFactory.createBinaryOpNode(op, left, right);
            left = args.get(i);
        }
        return this.exprNodeFactory.createBinaryOpNode(op, left, right);
    }

    @Override
    public IExprNode<E> parse(ICompilerState<E> state, PeekingIterator<Token> input) {
        return this.parseNode(state, input);
    }
}

