/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.Environment;
import openmods.calc.ExecutableList;
import openmods.calc.Frame;
import openmods.calc.IExecutable;
import openmods.calc.Value;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.SameStateSymbolTransition;
import openmods.calc.parsing.SymbolCallNode;

public class ConstantSymbolStateTransition<E>
extends SameStateSymbolTransition<E> {
    private final String selfSymbol;
    private final Environment<E> env;

    public ConstantSymbolStateTransition(ICompilerState<E> parentState, Environment<E> env, String selfSymbol) {
        super(parentState);
        this.env = env;
        this.selfSymbol = selfSymbol;
    }

    @Override
    public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
        return new ConstantsNode(children);
    }

    private class ConstantsNode
    extends SymbolCallNode<E> {
        public ConstantsNode(List<IExprNode<E>> constants) {
            super(ConstantSymbolStateTransition.this.selfSymbol, constants);
        }

        @Override
        public void flatten(List<IExecutable<E>> output) {
            ArrayList ops = Lists.newArrayList();
            for (IExprNode child : this.getChildren()) {
                child.flatten(ops);
            }
            Frame resultFrame = ConstantSymbolStateTransition.this.env.executeIsolated(ExecutableList.wrap(ops));
            for (Object constant : resultFrame.stack()) {
                output.add(Value.create(constant));
            }
        }
    }
}

