/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openmods.calc.Token;
import openmods.calc.TokenType;

public class ExprTokenizerFactory {
    private static final Pattern DEC_NUMBER = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)");
    private static final Pattern HEX_NUMBER = Pattern.compile("^0x([0-9A-Fa-f]+(?:\\.[0-9A-Fa-f]+)?)");
    private static final Pattern OCT_NUMBER = Pattern.compile("^0([0-7]+(?:\\.[0-7]+)?)");
    private static final Pattern BIN_NUMBER = Pattern.compile("^0b([01]+(?:\\.[01]+)?)");
    private static final Pattern QUOTED_NUMBER = Pattern.compile("^([0-9]+#[0-9A-Za-z'\"]+(?:\\.[0-9A-Za-z'\"]+)?)");
    private static final Pattern SYMBOL = Pattern.compile("^([_A-Za-z$][_0-9A-Za-z$]*)");
    private static final Pattern SYMBOL_ARGS = Pattern.compile("^(@[0-9]*,?[0-9]*)");
    private final Set<String> operators = Sets.newTreeSet((Comparator)new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int sizes = Ints.compare((int)o2.length(), (int)o1.length());
            if (sizes != 0) {
                return sizes;
            }
            return o1.compareTo(o2);
        }
    });

    public void addOperator(String operator) {
        this.operators.add(operator);
    }

    public Iterable<Token> tokenize(String input) {
        return new ExprTokenizer(input);
    }

    public class ExprTokenizer
    implements Iterable<Token> {
        private final String input;

        public ExprTokenizer(String input) {
            this.input = input;
        }

        @Override
        public Iterator<Token> iterator() {
            return new TokenIterator(this.input);
        }
    }

    private class TokenIterator
    extends AbstractIterator<Token> {
        private String input;

        public TokenIterator(String cls) {
            this.input = cls;
        }

        protected Token computeNext() {
            try {
                if (this.input.isEmpty()) {
                    return (Token)this.endOfData();
                }
                this.skipWhitespace();
                if (this.input.isEmpty()) {
                    return (Token)this.endOfData();
                }
                if (this.input.startsWith("(")) {
                    return this.rawToken(1, TokenType.LEFT_BRACKET);
                }
                if (this.input.startsWith(")")) {
                    return this.rawToken(1, TokenType.RIGHT_BRACKET);
                }
                if (this.input.startsWith(",")) {
                    return this.rawToken(1, TokenType.SEPARATOR);
                }
                Matcher symbolMatcher = SYMBOL.matcher(this.input);
                if (symbolMatcher.find()) {
                    String operator = this.findOperator();
                    String symbol = symbolMatcher.group(1);
                    if (operator != null && operator.length() >= symbol.length()) {
                        this.consumeInput(operator.length());
                        return new Token(TokenType.OPERATOR, operator);
                    }
                    this.consumeInput(symbolMatcher.end());
                    Matcher argMatcher = SYMBOL_ARGS.matcher(this.input);
                    if (argMatcher.find()) {
                        this.consumeInput(argMatcher.end());
                        String symbolArgs = argMatcher.group(1);
                        return new Token(TokenType.SYMBOL_WITH_ARGS, symbol + symbolArgs);
                    }
                    return new Token(TokenType.SYMBOL, symbol);
                }
                String operator = this.findOperator();
                if (operator != null) {
                    this.consumeInput(operator.length());
                    return new Token(TokenType.OPERATOR, operator);
                }
                Token result = this.tryPattern(QUOTED_NUMBER, TokenType.QUOTED_NUMBER);
                if (result != null) {
                    return result;
                }
                result = this.tryPattern(HEX_NUMBER, TokenType.HEX_NUMBER);
                if (result != null) {
                    return result;
                }
                result = this.tryPattern(OCT_NUMBER, TokenType.OCT_NUMBER);
                if (result != null) {
                    return result;
                }
                result = this.tryPattern(BIN_NUMBER, TokenType.BIN_NUMBER);
                if (result != null) {
                    return result;
                }
                result = this.tryPattern(DEC_NUMBER, TokenType.DEC_NUMBER);
                if (result != null) {
                    return result;
                }
                throw new IllegalArgumentException("Unknown token type: '" + this.input + "'");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse: '" + this.input + "'", e);
            }
        }

        protected void consumeInput(int length) {
            this.input = this.input.substring(length);
        }

        private Token rawToken(int charCount, TokenType type) {
            String value = this.input.substring(0, charCount);
            this.consumeInput(charCount);
            return new Token(type, value);
        }

        private String tryPattern(Pattern pattern) {
            Matcher matcher = pattern.matcher(this.input);
            if (matcher.find()) {
                String matched = matcher.group(1);
                this.consumeInput(matcher.end());
                return matched;
            }
            return null;
        }

        private Token tryPattern(Pattern pattern, TokenType type) {
            String matched = this.tryPattern(pattern);
            return matched != null ? new Token(type, matched) : null;
        }

        private String findOperator() {
            for (String operator : ExprTokenizerFactory.this.operators) {
                if (!this.input.startsWith(operator)) continue;
                return operator;
            }
            return null;
        }

        private void skipWhitespace() {
            int i;
            for (i = 0; i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
            }
            if (i > 0) {
                this.consumeInput(i);
            }
        }
    }
}

