/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.block.RotationAxis;
import openmods.geometry.BlockTextureTransform;
import openmods.geometry.HalfAxis;
import openmods.geometry.Orientation;
import openmods.renderer.rotations.IRendererSetup;
import openmods.renderer.rotations.RendererSetupProxy;
import openmods.utils.BlockUtils;

public enum BlockRotationMode {
    NONE(RotationAxis.NO_AXIS, new Orientation[0]){

        @Override
        public boolean isPlacementValid(Orientation dir) {
            return true;
        }

        @Override
        public Orientation fromValue(int value) {
            return Orientation.XP_YP;
        }

        @Override
        public int toValue(Orientation dir) {
            return 0;
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            return Orientation.XP_YP;
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            return null;
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.NULL;
        }
    }
    ,
    TWO_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.ZN_YP, Orientation.XP_YP}){

        private Orientation directionToOrientation(ForgeDirection normalDir) {
            switch (normalDir) {
                case EAST: 
                case WEST: {
                    return Orientation.ZN_YP;
                }
                case NORTH: 
                case SOUTH: {
                    return Orientation.XP_YP;
                }
            }
            return null;
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            ForgeDirection playerOrientation = BlockUtils.get2dOrientation((EntityLivingBase)player);
            return this.directionToOrientation(playerOrientation);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            switch (axis) {
                case UP: 
                case DOWN: {
                    return currentOrientation == Orientation.ZN_YP ? Orientation.XP_YP : Orientation.ZN_YP;
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    return this.directionToOrientation(axis);
                }
            }
            return null;
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.proxy.getVanillaRenderer();
        }
    }
    ,
    THREE_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YP, Orientation.YP_XN, Orientation.XP_ZN}){

        private Orientation directionToOrientation(ForgeDirection dir) {
            switch (dir) {
                case EAST: 
                case WEST: {
                    return Orientation.YP_XN;
                }
                case NORTH: 
                case SOUTH: {
                    return Orientation.XP_ZN;
                }
            }
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            ForgeDirection normalDir = BlockUtils.get3dOrientation((EntityLivingBase)player);
            return this.directionToOrientation(normalDir);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            return this.directionToOrientation(axis);
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST).mirrorU(ForgeDirection.DOWN);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.proxy.getTweakedRenderer();
        }
    }
    ,
    FOUR_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YP, Orientation.ZN_YP, Orientation.XN_YP, Orientation.ZP_YP}){

        private Orientation directionToOrientation(ForgeDirection side) {
            switch (side) {
                case SOUTH: {
                    return Orientation.XP_YP;
                }
                case WEST: {
                    return Orientation.ZP_YP;
                }
                case NORTH: {
                    return Orientation.XN_YP;
                }
                case EAST: {
                    return Orientation.ZN_YP;
                }
            }
            return null;
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            ForgeDirection side = BlockUtils.get2dOrientation((EntityLivingBase)player).getOpposite();
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            switch (axis) {
                case UP: {
                    return currentOrientation.rotateAround(HalfAxis.POS_Y);
                }
                case DOWN: {
                    return currentOrientation.rotateAround(HalfAxis.NEG_Y);
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    return this.directionToOrientation(axis);
                }
            }
            return null;
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.proxy.getVanillaRenderer();
        }

        @Override
        public Orientation getInventoryRenderOrientation() {
            return Orientation.XN_YP;
        }
    }
    ,
    SIX_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XN_YN, Orientation.XP_YP, Orientation.XP_ZN, Orientation.XP_ZP, Orientation.YP_XN, Orientation.YN_XP}){

        public Orientation directionToOrientation(ForgeDirection localTop) {
            switch (localTop) {
                case DOWN: {
                    return Orientation.XN_YN;
                }
                case EAST: {
                    return Orientation.YN_XP;
                }
                case NORTH: {
                    return Orientation.XP_ZN;
                }
                case SOUTH: {
                    return Orientation.XP_ZP;
                }
                case WEST: {
                    return Orientation.YP_XN;
                }
            }
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            ForgeDirection localTop = BlockUtils.get3dOrientation((EntityLivingBase)player).getOpposite();
            return this.directionToOrientation(localTop);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            return this.directionToOrientation(axis);
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST).mirrorU(ForgeDirection.DOWN);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.proxy.getTweakedRenderer();
        }

        @Override
        public Orientation getInventoryRenderOrientation() {
            return Orientation.YN_XP;
        }
    }
    ,
    THREE_FOUR_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.XP_YP, Orientation.XN_YP, Orientation.ZP_YP, Orientation.ZN_YP, Orientation.YP_XN, Orientation.YN_XN, Orientation.ZP_XN, Orientation.ZN_XN, Orientation.XP_ZN, Orientation.XN_ZN, Orientation.YP_ZN, Orientation.YN_ZN}){

        private Orientation directionToOrientation(ForgeDirection dir) {
            switch (dir) {
                case EAST: 
                case WEST: {
                    return Orientation.YP_XN;
                }
                case NORTH: 
                case SOUTH: {
                    return Orientation.XP_ZN;
                }
            }
            return Orientation.XP_YP;
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            ForgeDirection normalDir = BlockUtils.get3dOrientation((EntityLivingBase)player);
            return this.directionToOrientation(normalDir);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            HalfAxis currentTop;
            HalfAxis newTop = HalfAxis.fromDirection(axis);
            if (newTop == (currentTop = currentOrientation.y)) {
                return currentOrientation.rotateAround(HalfAxis.POS_Y);
            }
            if (newTop == currentTop.negate()) {
                return currentOrientation.rotateAround(HalfAxis.NEG_Y);
            }
            return this.directionToOrientation(axis);
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST).mirrorU(ForgeDirection.DOWN);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.proxy.getTweakedRenderer();
        }

        @Override
        public Orientation getInventoryRenderOrientation() {
            return Orientation.XN_YP;
        }
    }
    ,
    TWELVE_DIRECTIONS(RotationAxis.THREE_AXIS, new Orientation[]{Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_Z), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_Z), Orientation.lookupYZ(HalfAxis.NEG_Z, HalfAxis.NEG_Y), Orientation.lookupYZ(HalfAxis.POS_Z, HalfAxis.NEG_Y), Orientation.lookupYZ(HalfAxis.NEG_X, HalfAxis.NEG_Y), Orientation.lookupYZ(HalfAxis.POS_X, HalfAxis.NEG_Y), Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.POS_Z), Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_X), Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.POS_X), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.NEG_Z), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_X), Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.NEG_X)}){

        public Orientation directionToOrientation(ForgeDirection localTop) {
            switch (localTop) {
                case DOWN: {
                    return Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_Z);
                }
                case EAST: {
                    return Orientation.lookupYZ(HalfAxis.POS_X, HalfAxis.NEG_Y);
                }
                case NORTH: {
                    return Orientation.lookupYZ(HalfAxis.NEG_Z, HalfAxis.NEG_Y);
                }
                case SOUTH: {
                    return Orientation.lookupYZ(HalfAxis.POS_Z, HalfAxis.NEG_Y);
                }
                case WEST: {
                    return Orientation.lookupYZ(HalfAxis.NEG_X, HalfAxis.NEG_Y);
                }
            }
            return Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_Z);
        }

        @Override
        public Orientation getPlacementOrientationFromSurface(ForgeDirection side) {
            return this.directionToOrientation(side);
        }

        @Override
        public Orientation getPlacementOrientationFromEntity(EntityPlayer player) {
            ForgeDirection playerDir = BlockUtils.get2dOrientation((EntityLivingBase)player).getOpposite();
            if (player.field_70125_A > 45.5f) {
                return Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.fromDirection(playerDir));
            }
            if (player.field_70125_A < -45.5f) {
                return Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.fromDirection(playerDir));
            }
            return Orientation.lookupYZ(HalfAxis.fromDirection(playerDir), HalfAxis.NEG_Y);
        }

        @Override
        public Orientation calculateToolRotation(Orientation currentOrientation, ForgeDirection axis) {
            switch (axis) {
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    return Orientation.lookupYZ(HalfAxis.fromDirection(axis), HalfAxis.NEG_Y);
                }
                case UP: {
                    if (currentOrientation.y != HalfAxis.POS_Y) {
                        return Orientation.lookupYZ(HalfAxis.POS_Y, HalfAxis.POS_Z);
                    }
                    return currentOrientation.rotateAround(HalfAxis.POS_Y);
                }
                case DOWN: {
                    if (currentOrientation.y != HalfAxis.NEG_Y) {
                        return Orientation.lookupYZ(HalfAxis.NEG_Y, HalfAxis.NEG_Z);
                    }
                    return currentOrientation.rotateAround(HalfAxis.POS_Y);
                }
            }
            return null;
        }

        @Override
        protected BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder builder) {
            return builder.mirrorU(ForgeDirection.NORTH).mirrorU(ForgeDirection.EAST).mirrorU(ForgeDirection.DOWN);
        }

        @Override
        public IRendererSetup getRenderSetup() {
            return RendererSetupProxy.proxy.getTweakedRenderer();
        }
    };

    private static final int MAX_ORIENTATIONS = 16;
    private final Orientation[] idToOrientation;
    private final int[] orientationToId;
    public final ForgeDirection[] rotationAxes;
    public final Set<Orientation> validDirections;
    public final int bitCount;
    public final int mask;
    public final BlockTextureTransform textureTransform;

    private BlockRotationMode(ForgeDirection[] rotations, Orientation ... validOrientations) {
        this.rotationAxes = rotations;
        this.validDirections = ImmutableSet.copyOf((Object[])validOrientations);
        int count = validOrientations.length;
        Preconditions.checkArgument((this.validDirections.size() == count ? 1 : 0) != 0, (Object)"Duplicated directions");
        Preconditions.checkArgument((count <= 16 ? 1 : 0) != 0, (String)"Too many values: %s", (Object[])new Object[]{count});
        this.idToOrientation = new Orientation[16];
        this.orientationToId = new int[Orientation.VALUES.length];
        int i = 0;
        while (i < count) {
            Orientation orientation = validOrientations[i];
            Preconditions.checkNotNull((Object)((Object)orientation));
            this.idToOrientation[i] = orientation;
            this.orientationToId[orientation.ordinal()] = i++;
        }
        if (count == 0) {
            this.bitCount = 0;
            this.mask = 0;
        } else {
            int maxValue = count - 1;
            this.bitCount = 32 - Integer.numberOfLeadingZeros(maxValue);
            this.mask = (1 << this.bitCount) - 1;
            for (int i2 = count; i2 < this.idToOrientation.length; ++i2) {
                this.idToOrientation[i2] = this.idToOrientation[0];
            }
        }
        this.textureTransform = this.setupTextureTransform(BlockTextureTransform.builder()).build();
    }

    protected abstract BlockTextureTransform.Builder setupTextureTransform(BlockTextureTransform.Builder var1);

    public abstract IRendererSetup getRenderSetup();

    public Orientation fromValue(int value) {
        try {
            return this.idToOrientation[value];
        }
        catch (IndexOutOfBoundsException e) {
            return this.idToOrientation[0];
        }
    }

    public int toValue(Orientation dir) {
        try {
            return this.orientationToId[dir.ordinal()];
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    public boolean isPlacementValid(Orientation dir) {
        return this.validDirections.contains((Object)dir);
    }

    public abstract Orientation getPlacementOrientationFromSurface(ForgeDirection var1);

    public abstract Orientation getPlacementOrientationFromEntity(EntityPlayer var1);

    public abstract Orientation calculateToolRotation(Orientation var1, ForgeDirection var2);

    public Orientation getInventoryRenderOrientation() {
        return Orientation.XP_YP;
    }
}

