/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import java.lang.reflect.Field;
import uristqwerty.gui_craftguide.Color;
import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.texture.AnimationFrame;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.theme.reader.AnimationFrameElement;
import uristqwerty.gui_craftguide.theme.reader.ColorTemplate;
import uristqwerty.gui_craftguide.theme.reader.DoubleElement;
import uristqwerty.gui_craftguide.theme.reader.IntegerElement;
import uristqwerty.gui_craftguide.theme.reader.ListTemplate;
import uristqwerty.gui_craftguide.theme.reader.RectTemplate;
import uristqwerty.gui_craftguide.theme.reader.TextureElement;
import uristqwerty.gui_craftguide.theme.reader.ValueTemplate;

public class ValueType {
    public static ValueTemplate getTemplate(Field field, TextureMeta.WithUnits units) {
        if (field.getType().isArray() && field.isAnnotationPresent(TextureMeta.ListSize.class)) {
            TextureMeta.ListSize size = field.getAnnotation(TextureMeta.ListSize.class);
            return new ListTemplate(field.getType(), size.value(), units);
        }
        return ValueType.getTemplate(field.getType(), units);
    }

    public static ValueTemplate getTemplate(Class<?> type, TextureMeta.WithUnits units) {
        if (type.equals(Color.class)) {
            return new ColorTemplate(units);
        }
        if (type.equals(Rect.class)) {
            return new RectTemplate(units);
        }
        if (type.equals(Texture.class)) {
            return new TextureElement();
        }
        if (type.equals(AnimationFrame.class)) {
            return new AnimationFrameElement();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return new IntegerElement(units);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class) || type.equals(Double.TYPE) || type.equals(Double.class)) {
            return new DoubleElement(units);
        }
        if (type.isArray()) {
            return new ListTemplate(type, units);
        }
        return null;
    }
}

