/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.reader.DependencyElement;
import uristqwerty.gui_craftguide.theme.reader.ElementHandler;
import uristqwerty.gui_craftguide.theme.reader.GenericHandler;
import uristqwerty.gui_craftguide.theme.reader.ImageElement;
import uristqwerty.gui_craftguide.theme.reader.MetadataProperty;
import uristqwerty.gui_craftguide.theme.reader.NullElement;
import uristqwerty.gui_craftguide.theme.reader.TextureElement;

public class ThemeReader
implements ContentHandler {
    private static ElementHandler metadataElement = new GenericHandler("id", new MetadataProperty("id"), "name", new MetadataProperty("name"), "description", new MetadataProperty("description"), "dependency", DependencyElement.class);
    private static ElementHandler themeElement = new GenericHandler("metadata", metadataElement, "image", ImageElement.class, "texture", TextureElement.class);
    private static ElementHandler rootElement = new GenericHandler("theme", themeElement);
    private LinkedList<ElementHandler> handlerStack = new LinkedList();
    private Theme theme;

    public Theme read(InputStream source, File themeDir) {
        this.theme = new Theme(themeDir);
        this.handlerStack.add(rootElement);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(this);
            reader.parse(new InputSource(source));
        }
        catch (Exception e) {
            e.printStackTrace();
            CraftGuideLog.log(e);
            return null;
        }
        this.handlerStack.clear();
        return this.theme;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.handlerStack.peek() != null) {
            this.handlerStack.peek().characters(this.theme, chars, start, length);
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        if (this.handlerStack.peek() == null) {
            CraftGuideLog.log("CraftGuide: Error loading theme file. Stack is null at element '" + name + "'", true);
        } else {
            ElementHandler h = this.handlerStack.peek().getSubElement(name, attributes);
            this.handlerStack.push(h != null ? h : NullElement.instance);
            this.handlerStack.peek().startElement(this.theme, name, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        ElementHandler handler = this.handlerStack.pop();
        handler.endElement(this.theme, name);
        if (this.handlerStack.peek() != null) {
            this.handlerStack.peek().endSubElement(this.theme, handler, name);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }
}

