/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import java.lang.reflect.Field;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.reader.PrimitiveValueTemplate;

public class IntegerElement
extends PrimitiveValueTemplate {
    Long value = 0L;
    private final TextureMeta.WithUnits units;

    public IntegerElement(TextureMeta.WithUnits units) {
        this.units = units;
    }

    @Override
    public void characters(Theme theme, char[] chars, int start, int length) {
        String str = String.valueOf(chars, start, length);
        double multiplier = 1.0;
        if (this.units != null) {
            String lower = str.toLowerCase();
            int longestMatch = 0;
            for (TextureMeta.Unit u : this.units.value()) {
                for (String unitName : u.names()) {
                    if (!lower.endsWith(unitName.toLowerCase()) || unitName.length() <= longestMatch) continue;
                    multiplier = u.multiplier();
                    longestMatch = unitName.length();
                }
            }
            if (longestMatch > 0) {
                str = str.substring(0, str.length() - longestMatch).trim();
            }
        }
        try {
            this.value = (long)((double)Long.parseLong(str) * multiplier);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public Class<?> valueType() {
        return Long.class;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean setField(Field field, Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        if (type == Long.class || type == Long.TYPE) {
            field.set(object, this.value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            field.set(object, this.value.intValue());
        } else if (type == Short.class || type == Short.TYPE) {
            field.set(object, this.value.shortValue());
        } else if (type == Byte.class || type == Byte.TYPE) {
            field.set(object, this.value.byteValue());
        } else {
            return false;
        }
        return true;
    }
}

