/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.reader.ElementHandler;
import uristqwerty.gui_craftguide.theme.reader.ImageSourceElement;
import uristqwerty.gui_craftguide.theme.reader.NullElement;

public class ImageElement
implements ElementHandler {
    private String id;
    private List<String> sources = new ArrayList<String>();

    @Override
    public void startElement(Theme theme, String name, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equalsIgnoreCase("id")) continue;
            this.id = attributes.getValue(i).toLowerCase().replaceAll("[^a-z0-9_-]", "");
        }
    }

    @Override
    public ElementHandler getSubElement(String name, Attributes attributes) {
        if (name.equalsIgnoreCase("source")) {
            return new ImageSourceElement();
        }
        return NullElement.instance;
    }

    @Override
    public void characters(Theme theme, char[] chars, int start, int length) {
    }

    @Override
    public void endElement(Theme theme, String name) {
        if (this.id == null || this.id.isEmpty()) {
            return;
        }
        theme.addImage(this.id, this.sources);
    }

    @Override
    public void endSubElement(Theme theme, ElementHandler handler, String name) {
        if (handler instanceof ImageSourceElement) {
            this.sources.add(((ImageSourceElement)handler).getSource());
        }
    }
}

