/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.texture;

import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.Texture;

@TextureMeta(name="subtexture")
public class SubTexture
implements Texture {
    @TextureMeta.TextureParameter
    public Texture source;
    @TextureMeta.TextureParameter
    public Rect rect;

    public SubTexture(Texture source, int u, int v, int width, int height) {
        this.source = source;
        this.rect = new Rect(u, v, width, height);
    }

    public SubTexture() {
    }

    @Override
    public void renderRect(RendererBase renderer, int x, int y, int width, int height, int u, int v) {
        if (this.rect.width < 1 || this.rect.height < 1) {
            return;
        }
        if ((u = (u % this.rect.width + this.rect.width) % this.rect.width) + width <= this.rect.width) {
            this.renderRectColumn(renderer, x, y, width, height, this.rect.x + u, v);
        } else {
            if (u != 0) {
                this.renderRectColumn(renderer, x, y, this.rect.width - u % this.rect.width, height, this.rect.x + u % this.rect.width, v);
            }
            int segment_start = u;
            while (segment_start + this.rect.width < width) {
                this.renderRectColumn(renderer, x + segment_start, y, this.rect.width, height, this.rect.x, v);
                segment_start += this.rect.width;
            }
            this.renderRectColumn(renderer, x + segment_start, y, width - segment_start, height, this.rect.x, v);
        }
    }

    private void renderRectColumn(RendererBase renderer, int x, int y, int width, int height, int u, int v) {
        int v1 = (v % this.rect.height + this.rect.height) % this.rect.height + this.rect.y;
        int v2 = v1 + height;
        if (v2 < this.rect.y + this.rect.height) {
            this.source.renderRect(renderer, x, y, width, height, u, v1);
        } else {
            if (v != 0) {
                this.source.renderRect(renderer, x, y, width, this.rect.height - v % this.rect.height, u, this.rect.y + v % this.rect.height);
            }
            int segment_start = v;
            while (segment_start + this.rect.height < height) {
                this.source.renderRect(renderer, x, y + segment_start, width, this.rect.height, u, this.rect.y);
                segment_start += this.rect.height;
            }
            this.source.renderRect(renderer, x, y + segment_start, width, height - segment_start, u, this.rect.y);
        }
    }
}

