/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.texture;

import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.AnimationFrame;
import uristqwerty.gui_craftguide.texture.Texture;

@TextureMeta(name="animation")
public class AnimatedTexture
implements Texture {
    private static final double UNINITIALIZED_DURATION = -718567.3;
    @TextureMeta.TextureParameter
    public AnimationFrame[] frames;
    private double totalDuration = -718567.3;

    public AnimatedTexture() {
    }

    @TextureMeta.TextureInit
    public AnimatedTexture(AnimationFrame[] frames) {
        this.frames = frames;
        this.initDuration();
    }

    private void initDuration() {
        this.totalDuration = 0.0;
        for (AnimationFrame frame : this.frames) {
            this.totalDuration += frame.duration;
        }
    }

    @Override
    public void renderRect(RendererBase renderer, int x, int y, int width, int height, int u, int v) {
        if (this.totalDuration == -718567.3) {
            this.initDuration();
        }
        double t = renderer.getClock() % this.totalDuration;
        for (AnimationFrame frame : this.frames) {
            if (t < frame.duration) {
                frame.source.renderRect(renderer, x, y, width, height, u, v);
                break;
            }
            t -= frame.duration;
        }
    }
}

