/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.components;

import java.util.EnumMap;
import java.util.Map;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.texture.Texture;

public class Window
extends GuiElement {
    private GuiRenderer renderer;
    private boolean mousePressed;
    private Map<Layer, GuiElement> layers = new EnumMap<Layer, GuiElement>(Layer.class);
    private int lastMouseX;
    private int lastMouseY;
    private int centerX;
    private int centerY;
    private int maxWidth;
    private int maxHeight;
    private boolean centred = false;

    public Window(int x, int y, int width, int height, GuiRenderer renderer) {
        super(x, y, width, height);
        this.renderer = renderer;
    }

    public void centerOn(int centerX, int centerY) {
        this.centred = true;
        this.centerX = centerX;
        this.centerY = centerY;
        this.setPosition(centerX - this.bounds.width() / 2, centerY - this.bounds.height() / 2);
    }

    @Override
    public GuiRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void render(Renderable renderable, int xOffset, int yOffset) {
        this.renderer.render(renderable, xOffset + this.bounds.x(), yOffset + this.bounds.y());
    }

    @Override
    public void render(Texture texture, int x, int y, int width, int height) {
        texture.renderRect(this.renderer, x + this.bounds.x(), y + this.bounds.y(), width, height, 0, 0);
    }

    public void updateMouse(int x, int y) {
        if (x != this.lastMouseX || y != this.lastMouseY) {
            this.mouseMoved(x, y);
            this.lastMouseX = x;
            this.lastMouseY = y;
        }
    }

    public void updateMouseState(int x, int y, boolean buttonState, GuiElement.MouseClick mouseButton) {
        if (this.mousePressed != buttonState) {
            this.mousePressed = buttonState;
            if (buttonState) {
                this.mousePressed(x, y);
                GuiElement element = this.getElementAtPoint(x, y);
                if (element != null) {
                    element.elementClicked(x - element.absoluteX(), y - element.absoluteY(), mouseButton);
                }
            } else {
                this.mouseReleased(x, y);
            }
        }
    }

    @Override
    public void mousePressed(int x, int y) {
        this.getLayer(Layer.MAIN).mousePressed(x - this.bounds.x(), y - this.bounds.y());
        this.getLayer(Layer.POPUP).mousePressed(x - this.bounds.x(), y - this.bounds.y());
    }

    @Override
    public void draw() {
        this.drawBackground();
        this.getLayer(Layer.MAIN).draw();
        this.getLayer(Layer.POPUP).draw();
        this.getLayer(Layer.TOOLTIP).draw();
    }

    @Override
    public GuiElement getElementAtPoint(int x, int y) {
        GuiElement element = null;
        element = this.getLayer(Layer.POPUP).getElementAtPoint(x - this.bounds.x(), y - this.bounds.y());
        if (element == null) {
            element = this.getLayer(Layer.MAIN).getElementAtPoint(x - this.bounds.x(), y - this.bounds.y());
        }
        return element;
    }

    public void setMaxSize(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        if (this.bounds.width() > width || this.bounds.height() > height) {
            this.setSize(Math.min(this.bounds.width(), width), Math.min(this.bounds.height(), height));
        }
    }

    @Override
    public GuiElement getLayer(Layer layer) {
        GuiElement element = this.layers.get((Object)layer);
        if (element == null) {
            element = new GuiElement(new Rect(0, 0, this.bounds.width(), this.bounds.height())).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false);
            this.layers.put(layer, element);
            super.addElement(element);
        }
        return element;
    }

    @Override
    public GuiElement addElement(GuiElement element) {
        this.addElement(element, Layer.MAIN);
        return this;
    }

    @Override
    public GuiElement setSize(int width, int height) {
        super.setSize(Math.min(width, this.maxWidth), Math.min(height, this.maxHeight));
        if (this.isCentred()) {
            this.setPosition(this.centerX - this.bounds.width() / 2, this.centerY - this.bounds.height() / 2);
        }
        return this;
    }

    private void addElement(GuiElement element, Layer layer) {
        this.getLayer(layer).addElement(element);
    }

    public boolean isCentred() {
        return this.centred;
    }

    public static enum Layer {
        MAIN,
        POPUP,
        TOOLTIP;

    }
}

