/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.components;

import java.util.Arrays;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.components.ScrollPane;
import uristqwerty.gui_craftguide.components.Window;
import uristqwerty.gui_craftguide.minecraft.Text;
import uristqwerty.gui_craftguide.texture.BorderedTexture;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.SubTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class DropdownSelector
extends GuiElement {
    private boolean open = false;
    private String[] options;
    private int selected = -1;
    private String selection = null;
    private Text selectedText = new Text(0, 0, "");
    private ScrollPane selectionPane;

    public DropdownSelector(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.selectionPane = new ScrollPane(x, y + height, width, 100);
        Texture texture = DynamicTexture.instance("base_image");
        this.selectionPane.background = new BorderedTexture(new Texture[]{new TextureClip(texture, 1, 1, 4, 4), new SubTexture(texture, 6, 1, 64, 4), new TextureClip(texture, 71, 1, 4, 4), new SubTexture(texture, 1, 6, 4, 64), new SubTexture(texture, 6, 6, 64, 64), new SubTexture(texture, 71, 6, 4, 64), new TextureClip(texture, 1, 71, 4, 4), new SubTexture(texture, 6, 71, 64, 4), new TextureClip(texture, 71, 71, 4, 4)}, 4);
    }

    @Override
    public void mousePressed(int x, int y) {
        if (this.open && !this.popupContainsPoint(x, y)) {
            this.open = false;
            this.getLayer(Window.Layer.POPUP).removeElement(this.selectionPane);
        }
        super.mousePressed(x, y);
    }

    @Override
    public void elementClicked(int x, int y, GuiElement.MouseClick mouseButton) {
        if (!this.open) {
            this.open = true;
            this.getLayer(Window.Layer.POPUP).addElement(this.selectionPane);
        }
        super.elementClicked(x, y, mouseButton);
    }

    private boolean popupContainsPoint(int x, int y) {
        return false;
    }

    public void setOptions(String[] list) {
        this.selected = -1;
        this.options = Arrays.copyOf(list, list.length);
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(this.selection)) continue;
            this.selected = i;
            break;
        }
        if (this.selected == -1) {
            this.selection = null;
        }
    }

    public String getCurrentSelection() {
        return this.selection;
    }

    @Override
    public void draw() {
        if (this.open) {
            this.selectionPane.setPositionAbsolute(this.absoluteX(), this.absoluteY() + this.bounds.height());
        }
        if (this.selection != null) {
            this.selectedText.setText(this.selection);
            this.render(this.selectedText);
        }
        super.draw();
    }
}

