/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.template_builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.Recipe;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;
import uristqwerty.CraftGuide.api.ChanceSlot;
import uristqwerty.CraftGuide.api.ConstructedRecipeTemplate;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.LiquidSlot;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.PseudoFluidStack;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeTemplateBuilder;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;
import uristqwerty.CraftGuide.api.slotTypes.IconSlot;
import uristqwerty.CraftGuide.api.slotTypes.TextSlot;

public class RecipeTemplateBuilderImplementation
implements RecipeTemplateBuilder {
    private ItemStack craftingType;
    private int maxColumnHeight = 0;
    private ArrayList<ColumnLayout> columns = new ArrayList();
    private ColumnLayout currentColumn = new ColumnLayout();
    private RecipeTemplateBuilder.TemplateBuilderSlotType slotType = RecipeTemplateBuilder.TemplateBuilderSlotType.INPUT;
    private RecipeTemplateBuilder.HorizontalAlign itemAlign = RecipeTemplateBuilder.HorizontalAlign.CENTER;
    private RecipeTemplateBuilder.VerticalAlign defaultColumnAlign = RecipeTemplateBuilder.VerticalAlign.CENTER;

    public RecipeTemplateBuilderImplementation(ItemStack type) {
        this.craftingType = type;
    }

    @Override
    public RecipeTemplateBuilder nextColumn() {
        return this.nextColumn(0);
    }

    @Override
    public RecipeTemplateBuilder nextColumn(int gap) {
        this.finishColumn(gap);
        return this;
    }

    @Override
    public RecipeTemplateBuilder shapelessItemGrid(int width, int height) {
        this.currentColumn.items.add(new ShapelessGrid(width, height, this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18 * width);
        this.currentColumn.totalHeight += 18 * height;
        return this;
    }

    @Override
    public RecipeTemplateBuilder shapedItemGrid(int width, int height) {
        this.currentColumn.items.add(new ShapedGrid(width, height, this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18 * width);
        this.currentColumn.totalHeight += 18 * height;
        return this;
    }

    @Override
    public RecipeTemplateBuilder item() {
        this.currentColumn.items.add(new Item(this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18);
        this.currentColumn.totalHeight += 18;
        return this;
    }

    @Override
    public RecipeTemplateBuilder outputItem() {
        this.currentColumn.items.add(new Item(RecipeTemplateBuilder.TemplateBuilderSlotType.OUTPUT, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18);
        this.currentColumn.totalHeight += 18;
        return this;
    }

    @Override
    public RecipeTemplateBuilder machineItem() {
        this.currentColumn.items.add(new Item(RecipeTemplateBuilder.TemplateBuilderSlotType.MACHINE, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18);
        this.currentColumn.totalHeight += 18;
        return this;
    }

    @Override
    public RecipeTemplateBuilder chanceItem() {
        this.currentColumn.items.add(new ChanceItem(this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18);
        this.currentColumn.totalHeight += 18;
        return this;
    }

    @Override
    public RecipeTemplateBuilder liquid() {
        this.currentColumn.items.add(new Liquid(this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, 18);
        this.currentColumn.totalHeight += 18;
        return this;
    }

    @Override
    public RecipeTemplateBuilder text(int width, RecipeTemplateBuilder.TextOverflow overflowHandling) {
        return this.textBlock(width, 1, overflowHandling);
    }

    @Override
    public RecipeTemplateBuilder textBlock(int width, int rows, RecipeTemplateBuilder.TextOverflow overflowHandling) {
        this.currentColumn.items.add(new Text(width, rows, overflowHandling, this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, width);
        this.currentColumn.totalHeight += rows * 9;
        return this;
    }

    @Override
    public RecipeTemplateBuilder icon(int width, int height) {
        return this.iconWithData(width, height, RecipeTemplateBuilder.IconMode.PLAIN_ICON, 0);
    }

    @Override
    public RecipeTemplateBuilder iconWithData(int width, int height, RecipeTemplateBuilder.IconMode mode, int spaceForText) {
        this.currentColumn.items.add(new Icon(width, height, mode, spaceForText, this.slotType, this.itemAlign));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, width + spaceForText);
        this.currentColumn.totalHeight += height + 1;
        return this;
    }

    @Override
    public RecipeTemplateBuilder setColumnAlign(RecipeTemplateBuilder.VerticalAlign align) {
        this.defaultColumnAlign = align;
        this.currentColumn.align = align;
        return this;
    }

    @Override
    public RecipeTemplateBuilder setItemAlign(RecipeTemplateBuilder.HorizontalAlign align) {
        this.itemAlign = align;
        return this;
    }

    @Override
    public RecipeTemplateBuilder repeatedSubunit(RecipeTemplateBuilder.SubunitLayout layoutMode, RecipeTemplateBuilder.SubunitDescriptor contents) {
        RecipeTemplateBuilderImplementation innerBuilder = new RecipeTemplateBuilderImplementation(null);
        innerBuilder.slotType = this.slotType;
        contents.defineSubunit(innerBuilder);
        ConstructedRecipeTemplate innerTemplate = innerBuilder.finishTemplate();
        int innerHeight = innerBuilder.maxColumnHeight + 3;
        int subunitWidth = 1;
        for (ColumnLayout column : innerBuilder.columns) {
            subunitWidth = Math.max(subunitWidth, column.offset + column.totalWidth);
        }
        this.currentColumn.align = RecipeTemplateBuilder.VerticalAlign.TOP;
        this.currentColumn.items.add(new Subunit(innerTemplate, this.itemAlign, subunitWidth, innerHeight));
        this.currentColumn.totalWidth = Math.max(this.currentColumn.totalWidth, subunitWidth);
        this.currentColumn.totalHeight += innerHeight;
        return this;
    }

    @Override
    public RecipeTemplateBuilder nextSlotType(RecipeTemplateBuilder.TemplateBuilderSlotType type) {
        this.slotType = type;
        return this;
    }

    @Override
    public ConstructedRecipeTemplate finishTemplate() {
        this.finishColumn(0);
        ArrayList<ColumnItem> dataPattern = new ArrayList<ColumnItem>();
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int xOffset = 0;
        int rightEdge = 0;
        for (ColumnLayout column : this.columns) {
            xOffset = column.offset + 3;
            rightEdge = Math.max(rightEdge, xOffset + column.totalWidth);
            int yOffset = (this.maxColumnHeight - column.totalHeight) / 2 + 3;
            if (column.align == RecipeTemplateBuilder.VerticalAlign.BOTTOM) {
                yOffset = this.maxColumnHeight - column.totalHeight + 3;
            } else if (column.align == RecipeTemplateBuilder.VerticalAlign.TOP) {
                yOffset = 3;
            }
            for (ColumnItem item : column.items) {
                int x;
                int y;
                int hAlign;
                int itemWidth;
                int hAlign2;
                dataPattern.add(item);
                if (item instanceof Item) {
                    int itemWidth2 = 18;
                    hAlign2 = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth2);
                    slots.add(new ItemSlot(xOffset + 1 + hAlign2, yOffset + 1, 16, 16, true).drawOwnBackground(item.slotType.drawBackground()).setSlotType(item.slotType.toSlotType()));
                    yOffset += 18;
                    continue;
                }
                if (item instanceof ChanceItem) {
                    int itemWidth3 = 18;
                    hAlign2 = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth3);
                    slots.add(new ChanceSlot(xOffset + 1 + hAlign2, yOffset + 1, 16, 16, true).setRatio(1).drawOwnBackground(item.slotType.drawBackground()).setSlotType(item.slotType.toSlotType()));
                    yOffset += 18;
                    continue;
                }
                if (item instanceof Liquid) {
                    int itemWidth4 = 18;
                    hAlign2 = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth4);
                    slots.add(new LiquidSlot(xOffset + 1 + hAlign2, yOffset + 1).setSlotType(item.slotType.toSlotType()));
                    yOffset += 18;
                    continue;
                }
                if (item instanceof ShapelessGrid) {
                    ShapelessGrid grid = (ShapelessGrid)item;
                    itemWidth = 18 * grid.width;
                    hAlign = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth);
                    slots.add(new DecorationSlot(xOffset, yOffset, grid.width * 18, grid.height * 18, "shapeless-grid"));
                    for (y = 0; y < grid.height; ++y) {
                        for (x = 0; x < grid.width; ++x) {
                            slots.add(new ItemSlot(xOffset + x * 18 + 1 + hAlign, yOffset + y * 18 + 1, 16, 16, true).drawOwnBackground(false).setSlotType(item.slotType.toSlotType()));
                        }
                    }
                    yOffset += grid.height * 18;
                    continue;
                }
                if (item instanceof ShapedGrid) {
                    ShapedGrid grid = (ShapedGrid)item;
                    itemWidth = 18 * grid.width;
                    hAlign = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth);
                    for (y = 0; y < grid.height; ++y) {
                        for (x = 0; x < grid.width; ++x) {
                            slots.add(new ItemSlot(xOffset + x * 18 + 1 + hAlign, yOffset + y * 18 + 1, 16, 16, true).drawOwnBackground(item.slotType.drawBackground()).setSlotType(item.slotType.toSlotType()));
                        }
                    }
                    yOffset += grid.height * 18;
                    continue;
                }
                if (item instanceof Text) {
                    Text text = (Text)item;
                    itemWidth = text.width;
                    hAlign = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth);
                    slots.add(new TextSlot(xOffset + hAlign, yOffset));
                    yOffset += text.rows * 9;
                    continue;
                }
                if (item instanceof Icon) {
                    Icon icon = (Icon)item;
                    itemWidth = icon.iconWidth + icon.textWidth;
                    hAlign = RecipeTemplateBuilderImplementation.calcHorizontalAlign(item.align, column.totalWidth, itemWidth);
                    slots.add(new IconSlot(xOffset + hAlign, yOffset, icon.iconWidth, icon.height));
                    if (icon.mode == RecipeTemplateBuilder.IconMode.ICON_AND_LABEL) {
                        slots.add(new TextSlot(xOffset + hAlign + icon.iconWidth, yOffset + (icon.height - 9) / 2));
                    }
                    yOffset += icon.height;
                    continue;
                }
                if (item instanceof Subunit) {
                    Subunit subunit = (Subunit)item;
                    slots.add(new SubunitSlot(item.align, xOffset, yOffset, subunit.width, subunit.height, column.totalWidth, subunit.innerTemplate));
                    yOffset += subunit.height;
                    continue;
                }
                CraftGuideLog.log("Unimplemented thingy! " + item.getClass().getSimpleName());
            }
        }
        ConstructedRecipeTemplateImplementation template = new ConstructedRecipeTemplateImplementation();
        template.slots = slots.toArray(new Slot[0]);
        template.data = dataPattern.toArray(new ColumnItem[0]);
        template.template = (DefaultRecipeTemplate)RecipeGeneratorImplementation.instance.createRecipeTemplate(template.slots, this.craftingType);
        template.template.setSize(rightEdge + 3, this.maxColumnHeight + 6);
        return template;
    }

    private static int calcHorizontalAlign(RecipeTemplateBuilder.HorizontalAlign align, int totalWidth, int itemWidth) {
        switch (align) {
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return totalWidth - itemWidth;
            }
        }
        return (totalWidth - itemWidth) / 2;
    }

    private void finishColumn(int gap) {
        this.maxColumnHeight = Math.max(this.maxColumnHeight, this.currentColumn.totalHeight);
        this.columns.add(this.currentColumn);
        ColumnLayout newColumn = new ColumnLayout();
        newColumn.offset = this.currentColumn.offset + this.currentColumn.totalWidth + gap;
        newColumn.align = this.defaultColumnAlign;
        this.currentColumn = newColumn;
    }

    private static class SubunitSlot
    implements Slot {
        private int groupX;
        private int groupY;
        private int groupWidth;
        private int unitWidth;
        private int unitHeight;
        private RecipeTemplateBuilder.HorizontalAlign alignment;
        private ConstructedRecipeTemplateImplementation template;

        public SubunitSlot(RecipeTemplateBuilder.HorizontalAlign align, int xOffset, int yOffset, int width, int height, int totalWidth, ConstructedRecipeTemplateImplementation innerTemplate) {
            this.alignment = align;
            this.groupX = xOffset;
            this.groupY = yOffset;
            this.groupWidth = totalWidth;
            this.unitWidth = width;
            this.unitHeight = height;
            this.template = innerTemplate;
        }

        @Override
        public void draw(Renderer renderer, int x, int y, Object[] data, int dataIndex, boolean isMouseOver) {
            Object[] subunits = (Object[])data[dataIndex];
            int units = subunits.length;
            int left = this.left(units);
            int perRow = this.perRow(units);
            for (int i = 0; i < subunits.length; ++i) {
                int unitX = x + left + i % perRow * this.unitWidth;
                int unitY = y + this.groupY + i / perRow * this.unitHeight;
                Object[] subunit = (Object[])subunits[i];
                for (int j = 0; j < this.template.slots.length; ++j) {
                    this.template.slots[j].draw(renderer, unitX, unitY, subunit, j, isMouseOver);
                }
            }
        }

        @Override
        public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
            int rows;
            int perRow;
            Object[] subunits = (Object[])data[dataIndex];
            int units = subunits.length;
            int left = this.left(units);
            int index = this.getIndex(x, y, left, units, perRow = this.perRow(units), rows = (units + perRow - 1) / perRow);
            if (index < 0) {
                return null;
            }
            x = this.leftOf(x, index, left, perRow);
            y = this.topOf(y, index, perRow);
            Object[] subunit = (Object[])subunits[index];
            for (int i = 0; i < this.template.slots.length; ++i) {
                Slot s = this.template.slots[i];
                if (!s.isPointInBounds(x, y, subunit, i)) continue;
                return s.getClickedFilter(x, y, subunit, i);
            }
            return null;
        }

        @Override
        public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
            int rows;
            int perRow;
            Object[] subunits = (Object[])data[dataIndex];
            int units = subunits.length;
            int left = this.left(units);
            int index = this.getIndex(x, y, left, units, perRow = this.perRow(units), rows = (units + perRow - 1) / perRow);
            if (index < 0) {
                return false;
            }
            x = this.leftOf(x, index, left, perRow);
            y = this.topOf(y, index, perRow);
            Object[] subunit = (Object[])subunits[index];
            for (int i = 0; i < this.template.slots.length; ++i) {
                Slot s = this.template.slots[i];
                if (!s.isPointInBounds(x, y, subunit, i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<String> getTooltip(int x, int y, Object[] data, int dataIndex) {
            int rows;
            int perRow;
            Object[] subunits = (Object[])data[dataIndex];
            int units = subunits.length;
            int left = this.left(units);
            int index = this.getIndex(x, y, left, units, perRow = this.perRow(units), rows = (units + perRow - 1) / perRow);
            if (index < 0) {
                return null;
            }
            x = this.leftOf(x, index, left, perRow);
            y = this.topOf(y, index, perRow);
            Object[] subunit = (Object[])subunits[index];
            for (int i = 0; i < this.template.slots.length; ++i) {
                Slot s = this.template.slots[i];
                if (!s.isPointInBounds(x, y, subunit, i)) continue;
                return s.getTooltip(x, y, subunit, i);
            }
            return null;
        }

        @Override
        public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
            Object[] subunits;
            for (Object subunit : subunits = (Object[])data[dataIndex]) {
                Object[] innerData = (Object[])subunit;
                for (int i = 0; i < innerData.length; ++i) {
                    if (!this.template.slots[i].matches(filter, innerData, i, type)) continue;
                    return true;
                }
            }
            return false;
        }

        int leftOf(int x, int index, int left, int perRow) {
            return x - left - index % perRow * this.unitWidth;
        }

        int topOf(int y, int index, int perRow) {
            return y - this.groupY - index / perRow * this.unitHeight;
        }

        private int getIndex(int x, int y, int left, int units, int perRow, int rows) {
            if (x < left || x > left + perRow * this.unitWidth || y < this.groupY || y > this.groupY + rows * this.unitHeight) {
                return -1;
            }
            int i = (x - left) / this.unitWidth + perRow * (y - this.groupY) / this.unitHeight;
            return i < units ? i : -1;
        }

        private int left(int itemCount) {
            if (this.alignment == RecipeTemplateBuilder.HorizontalAlign.LEFT) {
                return this.groupX;
            }
            int perRow = this.perRow(itemCount);
            int unusedWidth = this.groupWidth - this.unitWidth * perRow;
            if (this.alignment == RecipeTemplateBuilder.HorizontalAlign.RIGHT) {
                return unusedWidth + this.groupX;
            }
            return unusedWidth / 2 + this.groupX;
        }

        private int perRow(int itemCount) {
            return Math.min(this.groupWidth / this.unitWidth, itemCount);
        }
    }

    private static class Subunit
    extends ColumnItem {
        final int width;
        final int height;
        final ConstructedRecipeTemplateImplementation innerTemplate;

        public Subunit(ConstructedRecipeTemplate innerTemplate, RecipeTemplateBuilder.HorizontalAlign align, int width, int height) {
            super(RecipeTemplateBuilder.TemplateBuilderSlotType.DECORATIVE, align);
            this.innerTemplate = (ConstructedRecipeTemplateImplementation)innerTemplate;
            this.width = width;
            this.height = height;
        }
    }

    private static class Icon
    extends ColumnItem {
        final int iconWidth;
        final int textWidth;
        final int height;
        final RecipeTemplateBuilder.IconMode mode;

        public Icon(int width, int height, RecipeTemplateBuilder.IconMode mode, int spaceForText, RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
            this.iconWidth = width;
            this.height = height;
            this.textWidth = spaceForText;
            this.mode = mode;
        }
    }

    private static class Text
    extends ColumnItem {
        final int width;
        final int rows;
        final RecipeTemplateBuilder.TextOverflow overflow;

        public Text(int width, int rows, RecipeTemplateBuilder.TextOverflow overflowMode, RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
            this.width = width;
            this.rows = rows;
            this.overflow = overflowMode;
        }
    }

    private static class ShapedGrid
    extends ColumnItem {
        final int width;
        final int height;

        public ShapedGrid(int width, int height, RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
            this.width = width;
            this.height = height;
        }
    }

    private static class Liquid
    extends ColumnItem {
        public Liquid(RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
        }
    }

    private static class ChanceItem
    extends ColumnItem {
        public ChanceItem(RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
        }
    }

    private static class Item
    extends ColumnItem {
        public Item(RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
        }
    }

    private static class ShapelessGrid
    extends ColumnItem {
        final int width;
        final int height;

        public ShapelessGrid(int width, int height, RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            super(slotType, align);
            this.width = width;
            this.height = height;
        }
    }

    private static abstract class ColumnItem {
        final RecipeTemplateBuilder.TemplateBuilderSlotType slotType;
        final RecipeTemplateBuilder.HorizontalAlign align;

        public ColumnItem(RecipeTemplateBuilder.TemplateBuilderSlotType slotType, RecipeTemplateBuilder.HorizontalAlign align) {
            this.slotType = slotType;
            this.align = align;
        }
    }

    private static class ColumnLayout {
        public RecipeTemplateBuilder.VerticalAlign align = RecipeTemplateBuilder.VerticalAlign.CENTER;
        int totalHeight = 0;
        int totalWidth = 0;
        int offset = 0;
        ArrayList<ColumnItem> items = new ArrayList();

        private ColumnLayout() {
        }
    }

    private static class RecipeBuilderImplementation
    implements ConstructedRecipeTemplate.RecipeBuilder {
        private final ColumnItem[] data;
        private final Slot[] slots;
        private final DefaultRecipeTemplate template;
        private int dataIndex = 0;
        private int slotIndex = 0;
        private Object[] recipeData;

        public RecipeBuilderImplementation(ColumnItem[] data, Slot[] slots, DefaultRecipeTemplate template) {
            this.slots = slots;
            this.data = data;
            this.template = template;
            this.recipeData = new Object[slots.length];
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder shapelessItemGrid(Object[] items) {
            return this.shapelessItemGrid(Arrays.asList(items));
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder shapelessItemGrid(List<?> items) {
            ShapelessGrid grid = (ShapelessGrid)this.nextData();
            if (items.size() > grid.width * grid.height) {
                throw new RuntimeException("Shapeless recipe given more items than fit");
            }
            this.pushRecipeData(null);
            for (int i = 0; i < grid.width * grid.height; ++i) {
                if (i < items.size()) {
                    this.pushRecipeData(items.get(i));
                    continue;
                }
                this.pushRecipeData(null);
            }
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder shapedItemGrid(int width, int height, Object[] items) {
            return this.shapedItemGrid(width, height, Arrays.asList(items));
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder shapedItemGrid(int width, int height, List<?> items) {
            ShapedGrid grid = (ShapedGrid)this.nextData();
            if (width > grid.width || height > grid.height || items.size() != width * height) {
                throw new RuntimeException("Shaped recipe given mismatched data");
            }
            int yOffset = (grid.height - height) / 2;
            int xOffset = (grid.width - width) / 2;
            for (int y = 0; y < height; ++y) {
                int yPos = y + yOffset;
                for (int x = 0; x < width; ++x) {
                    int xPos = x + xOffset;
                    this.recipeData[this.slotIndex + yPos * grid.width + xPos] = items.get(y * width + x);
                }
            }
            this.slotIndex += grid.width * grid.height;
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder item(Object item) {
            if (!(this.nextData() instanceof Item)) {
                throw new RuntimeException("Data type mismatch");
            }
            this.pushRecipeData(item);
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder chanceItem(Object item, double chance) {
            if (!(this.nextData() instanceof ChanceItem)) {
                throw new RuntimeException("Data type mismatch");
            }
            this.pushRecipeData(new Object[]{item, chance});
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder liquid(FluidStack liquid) {
            if (!(this.nextData() instanceof Liquid)) {
                throw new RuntimeException("Data type mismatch");
            }
            this.pushRecipeData(liquid);
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder liquid(PseudoFluidStack liquid) {
            if (!(this.nextData() instanceof Liquid)) {
                throw new RuntimeException("Data type mismatch");
            }
            this.pushRecipeData(liquid);
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder text(String text) {
            Text textDef = (Text)this.nextData();
            String[] unwrappedLines = text.split("\n");
            switch (textDef.overflow) {
                default: {
                    this.pushRecipeData(unwrappedLines);
                    return this;
                }
                case TRUNCATE: {
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    if (unwrappedLines.length > textDef.rows) {
                        unwrappedLines = Arrays.copyOf(unwrappedLines, textDef.rows);
                    }
                    for (int i = 0; i < unwrappedLines.length; ++i) {
                        while (fontRenderer.func_78256_a(unwrappedLines[i]) > textDef.width) {
                            unwrappedLines[i] = unwrappedLines[i].substring(0, unwrappedLines[i].length() - 1);
                        }
                    }
                    this.pushRecipeData(unwrappedLines);
                    return this;
                }
                case WRAP: 
            }
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            ArrayList<String> wrappedLines = new ArrayList<String>();
            for (int i = 0; i < unwrappedLines.length; ++i) {
                String overflow = "";
                String current = unwrappedLines[i];
                do {
                    if (fontRenderer.func_78256_a(current) > textDef.width) {
                        int split = current.length() - 1;
                        overflow = current.substring(split) + overflow;
                        current = current.substring(0, split);
                        continue;
                    }
                    wrappedLines.add(current);
                    current = overflow;
                    overflow = "";
                } while (!current.isEmpty());
            }
            this.pushRecipeData(wrappedLines);
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder icon(String sourceTexture, String iconName) {
            return this.icon(sourceTexture, iconName, null, 0.0f, 0.0f, 16.0f, 16.0f);
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder icon(String sourceTexture, String iconName, Integer iconTint, float u, float v, float u2, float v2) {
            Icon icon = (Icon)this.nextData();
            if (icon.mode != RecipeTemplateBuilder.IconMode.PLAIN_ICON) {
                throw new RuntimeException("Data type mismatch");
            }
            if (iconTint == null) {
                iconTint = -1;
            }
            Object source = this.convertTextureSource(sourceTexture, iconName);
            this.pushRecipeData(new Object[]{source, Float.valueOf(u), Float.valueOf(v), Float.valueOf(u2), Float.valueOf(v2), iconTint});
            return this;
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder iconWithText(String sourceTexture, String iconName, String text) {
            return this.iconWithText(sourceTexture, iconName, null, 0.0f, 0.0f, 16.0f, 16.0f, text);
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder iconWithText(String sourceTexture, String iconName, Integer iconTint, float u, float v, float u2, float v2, String text) {
            Icon icon = (Icon)this.nextData();
            if (icon.mode == RecipeTemplateBuilder.IconMode.PLAIN_ICON) {
                throw new RuntimeException("Data type mismatch");
            }
            if (iconTint == null) {
                iconTint = -1;
            }
            Object source = this.convertTextureSource(sourceTexture, iconName);
            if (icon.mode == RecipeTemplateBuilder.IconMode.ICON_AND_STACKSIZE) {
                this.pushRecipeData(new Object[]{source, Float.valueOf(u), Float.valueOf(v), Float.valueOf(u2), Float.valueOf(v2), iconTint, text});
            } else if (icon.mode == RecipeTemplateBuilder.IconMode.ICON_AND_LABEL) {
                this.pushRecipeData(new Object[]{source, Float.valueOf(u), Float.valueOf(v), Float.valueOf(u2), Float.valueOf(v2), iconTint});
                this.pushRecipeData(text);
            }
            return this;
        }

        @Override
        public <T> ConstructedRecipeTemplate.RecipeBuilder subUnit(T[] items, ConstructedRecipeTemplate.SubunitBuilder<T> builder) {
            return this.subUnit(items != null ? Arrays.asList(items) : null, builder);
        }

        @Override
        public <T> ConstructedRecipeTemplate.RecipeBuilder subUnit(Collection<T> items, ConstructedRecipeTemplate.SubunitBuilder<T> builder) {
            Subunit subunit = (Subunit)this.nextData();
            ArrayList<Object[]> contents = new ArrayList<Object[]>();
            if (items != null) {
                for (T item : items) {
                    RecipeBuilderImplementation recipeBuilder = (RecipeBuilderImplementation)subunit.innerTemplate.buildRecipe();
                    builder.build(item, recipeBuilder);
                    contents.add(recipeBuilder.recipeData);
                }
            }
            this.pushRecipeData(contents.toArray());
            return this;
        }

        private Object convertTextureSource(String sourceTexture, String iconName) {
            ResourceLocation sourceLocation = new ResourceLocation(sourceTexture);
            if (iconName == null || iconName.isEmpty()) {
                return sourceLocation;
            }
            ITextureObject texture = Minecraft.func_71410_x().field_71446_o.func_110581_b(sourceLocation);
            if (texture instanceof TextureMap) {
                TextureAtlasSprite sprite = ((TextureMap)texture).func_110572_b(iconName);
                return new Object[]{sourceLocation, sprite};
            }
            return null;
        }

        private void pushRecipeData(Object item) {
            this.recipeData[this.slotIndex++] = item;
        }

        private ColumnItem nextData() {
            if (this.dataIndex >= this.data.length) {
                throw new RuntimeException("Slot underflow and I haven't implemented proper error handling");
            }
            return this.data[this.dataIndex++];
        }

        @Override
        public void addRecipe(RecipeGenerator generator) {
            if (this.dataIndex == this.data.length && this.slotIndex == this.slots.length) {
                int height = this.template.height();
                for (int i = 0; i < this.slots.length; ++i) {
                    int len;
                    SubunitSlot sub;
                    int perRow;
                    if (!(this.slots[i] instanceof SubunitSlot) || (perRow = (sub = (SubunitSlot)this.slots[i]).perRow(len = ((Object[])this.recipeData[i]).length)) <= 0) continue;
                    int rows = (len + perRow - 1) / perRow;
                    height = Math.max(height, sub.groupY + rows * sub.unitHeight + 3);
                }
                if (height != this.template.height()) {
                    Recipe recipe = this.template.generateWithSize(this.recipeData, this.template.width(), height);
                    generator.addRecipe(recipe, this.template.getCraftingType());
                } else {
                    generator.addRecipe(this.template, this.recipeData);
                }
            }
        }
    }

    private static class ConstructedRecipeTemplateImplementation
    implements ConstructedRecipeTemplate {
        ColumnItem[] data;
        Slot[] slots;
        DefaultRecipeTemplate template;

        private ConstructedRecipeTemplateImplementation() {
        }

        @Override
        public ConstructedRecipeTemplate.RecipeBuilder buildRecipe() {
            return new RecipeBuilderImplementation(this.data, this.slots, this.template);
        }
    }

    private static class DecorationSlot
    implements Slot {
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final NamedTexture texture;

        public DecorationSlot(int xOffset, int yOffset, int width, int height, String texture) {
            this.x = xOffset;
            this.y = yOffset;
            this.w = width;
            this.h = height;
            this.texture = Util.instance.getTexture(texture);
        }

        @Override
        public void draw(Renderer renderer, int x, int y, Object[] data, int dataIndex, boolean isMouseOver) {
            renderer.renderRect(this.x + x, this.y + y, this.w, this.h, this.texture);
        }

        @Override
        public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
            return null;
        }

        @Override
        public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
            return false;
        }

        @Override
        public List<String> getTooltip(int x, int y, Object[] data, int dataIndex) {
            return null;
        }

        @Override
        public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
            return false;
        }
    }
}

