/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.recipes;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.api.CraftGuideAPIObject;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class BrewingRecipes
extends CraftGuideAPIObject
implements RecipeProvider {
    private final Slot[] slots = new ItemSlot[]{new ItemSlot(12, 12, 16, 16).setSlotType(SlotType.INPUT_SLOT), new ItemSlot(12, 30, 16, 16).setSlotType(SlotType.INPUT_SLOT), new ItemSlot(49, 21, 16, 16).setSlotType(SlotType.OUTPUT_SLOT)};

    @Override
    public void generateRecipes(RecipeGenerator generator) {
        ItemStack stack = new ItemStack(Items.field_151067_bt);
        List<ItemStack[]> recipes = this.getRecipes();
        DefaultRecipeTemplate template = new DefaultRecipeTemplate(this.slots, stack, new TextureClip(DynamicTexture.instance("brew_recipe_background"), 1, 1, 79, 58), new TextureClip(DynamicTexture.instance("brew_recipe_background"), 82, 1, 79, 58));
        if (CraftGuide.hideMundanePotionRecipes) {
            Iterator<ItemStack[]> iterator = recipes.iterator();
            while (iterator.hasNext()) {
                ItemStack[] itemStackArray = iterator.next();
                if (itemStackArray[2] == null || CommonUtilities.getItemDamage(itemStackArray[2]) != 8192) continue;
                iterator.remove();
            }
        }
        for (Object[] objectArray : recipes) {
            generator.addRecipe(template, objectArray);
        }
        generator.setDefaultTypeVisibility(stack, false);
    }

    private List<ItemStack[]> getRecipes() {
        List<Item> ingredients = this.getIngredients();
        ItemStack water = new ItemStack((Item)Items.field_151068_bn);
        LinkedList<ItemStack[]> potionRecipes = new LinkedList<ItemStack[]>();
        HashSet<Integer> done = new HashSet<Integer>();
        done.add(0);
        this.addRecipesForPotion(potionRecipes, water, ingredients, done);
        return potionRecipes;
    }

    private void addRecipesForPotion(List<ItemStack[]> potionRecipes, ItemStack potion, List<Item> ingredients, Set<Integer> done) {
        LinkedList<ItemStack> next = new LinkedList<ItemStack>();
        for (Item ingredient : ingredients) {
            int result = PotionHelper.func_77913_a((int)CommonUtilities.getItemDamage(potion), (String)ingredient.func_150896_i(new ItemStack(ingredient)));
            if (result == 0 || result == CommonUtilities.getItemDamage(potion)) continue;
            ItemStack output = new ItemStack((Item)Items.field_151068_bn);
            output.func_77964_b(result);
            potionRecipes.add(new ItemStack[]{potion, new ItemStack(ingredient), output});
            if (done.contains(result)) continue;
            next.add(output);
            done.add(result);
        }
        for (ItemStack nextPotion : next) {
            this.addRecipesForPotion(potionRecipes, nextPotion, ingredients, done);
        }
    }

    private List<Item> getIngredients() {
        LinkedList<Item> ingredients = new LinkedList<Item>();
        for (Object item : Item.field_150901_e) {
            if (item == null || !((Item)item).func_150892_m(new ItemStack((Item)item))) continue;
            ingredients.add((Item)item);
        }
        return ingredients;
    }
}

