/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.filters;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;

public class StringItemFilter
implements ItemFilter {
    String comparison;
    private NamedTexture textImage = Util.instance.getTexture("TextFilter");

    public StringItemFilter(String string) {
        this.comparison = string.toLowerCase();
    }

    @Override
    public boolean matches(Object item) {
        if (item instanceof ItemStack) {
            try {
                return CommonUtilities.searchExtendedItemStackText(item, this.comparison);
            }
            catch (Throwable e) {
                CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.StringItemFilter.matches ItemStack branch");
                throw new RuntimeException(e);
            }
        }
        if (item instanceof String) {
            try {
                return ((String)item).toLowerCase().contains(this.comparison);
            }
            catch (Throwable e) {
                CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.StringItemFilter.matches String branch");
                throw new RuntimeException(e);
            }
        }
        if (item instanceof List) {
            try {
                List<String> lines;
                List list = (List)item;
                for (Object o : list) {
                    if (!this.matches(o)) continue;
                    return true;
                }
                if (list.size() < 1 && (lines = ForgeExtensions.emptyOreDictEntryText(list)) != null) {
                    for (String line : lines) {
                        if (line == null || !line.toLowerCase().contains(this.comparison)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (Throwable e) {
                CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.StringItemFilter.matches List branch");
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        renderer.renderRect(x, y, 16, 16, this.textImage);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> text = new ArrayList<String>(1);
        text.add("\u00a77Text search: '" + this.comparison + "'");
        return text;
    }
}

