/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.filters;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.api.CombinableItemFilter;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.LiquidFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.PseudoFluidFilter;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;
import uristqwerty.CraftGuide.filters.MultiFilter;
import uristqwerty.CraftGuide.filters.StringItemFilter;

public class SingleItemFilter
implements CombinableItemFilter {
    public ItemStack comparison;
    private NamedTexture overlayAny = Util.instance.getTexture("ItemStack-Any");

    public SingleItemFilter(ItemStack stack) {
        this.comparison = stack;
    }

    @Override
    public boolean matches(Object stack) {
        if (stack instanceof ItemStack) {
            return CommonUtilities.checkItemStackMatch((ItemStack)stack, this.comparison);
        }
        if (stack instanceof List) {
            for (Object item : (List)stack) {
                if (!this.matches(item)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        renderer.renderItemStack(x, y, this.comparison);
        if (CommonUtilities.getItemDamage(this.comparison) == Short.MAX_VALUE) {
            renderer.renderRect(x - 1, y - 1, 18, 18, this.overlayAny);
        }
    }

    @Override
    public List<String> getTooltip() {
        return Util.instance.getItemStackText(this.comparison);
    }

    @Override
    public ItemFilter addItemFilter(ItemFilter other) {
        if (other instanceof CombinableItemFilter) {
            List<ItemStack> otherItems = ((CombinableItemFilter)other).getRepresentativeItems();
            if (otherItems != null) {
                return Util.instance.getCommonFilter(Util.instance.addItemLists(this.getRepresentativeItems(), otherItems));
            }
        } else if (other instanceof StringItemFilter || other instanceof LiquidFilter || other instanceof PseudoFluidFilter) {
            return new MultiFilter(this).addItemFilter(other);
        }
        return null;
    }

    @Override
    public ItemFilter subtractItemFilter(ItemFilter other) {
        List<ItemStack> otherItems;
        if (other instanceof CombinableItemFilter && (otherItems = ((CombinableItemFilter)other).getRepresentativeItems()) != null) {
            return Util.instance.getCommonFilter(Util.instance.subtractItemLists(this.getRepresentativeItems(), otherItems));
        }
        return null;
    }

    @Override
    public List<ItemStack> getRepresentativeItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
        list.add(this.comparison);
        return list;
    }
}

