/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui.text;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class TextSource {
    private List<WeakReference<TextChangeListener>> listeners = new ArrayList<WeakReference<TextChangeListener>>();

    public void addListener(TextChangeListener listener) {
        this.listeners.add(new WeakReference<TextChangeListener>(listener));
    }

    public void removeListener(TextChangeListener listener) {
        Iterator<WeakReference<TextChangeListener>> i = this.listeners.iterator();
        while (i.hasNext()) {
            WeakReference<TextChangeListener> ref = i.next();
            if (ref.get() != listener) continue;
            i.remove();
        }
    }

    protected void sendTextChanged() {
        for (WeakReference<TextChangeListener> ref : this.listeners) {
            TextChangeListener listener = (TextChangeListener)ref.get();
            if (listener == null) continue;
            listener.onTextChanged(this);
        }
    }

    public abstract String getText();

    public static interface TextChangeListener {
        public void onTextChanged(TextSource var1);
    }
}

