/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.Arrays;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiScrollableGrid;

public abstract class GuiVariableRowHeightGrid
extends GuiScrollableGrid {
    private int[] rowHeights;
    private int[] rowStartY;

    public GuiVariableRowHeightGrid(int x, int y, int width, int height, GuiScrollBar scrollBar, int rowHeight, int columnWidth) {
        super(x, y, width, height, scrollBar, rowHeight, columnWidth);
    }

    @Override
    protected void recalculateRowHeight() {
        int rowCount = this.rowCount();
        int columns = this.getColumns();
        this.rowHeights = new int[rowCount];
        this.rowStartY = new int[rowCount];
        if (rowCount < 1) {
            return;
        }
        this.rowStartY[0] = 0;
        for (int row = 0; row < rowCount; ++row) {
            int height = 1;
            for (int column = 0; column < columns; ++column) {
                int cell = row * columns + column;
                if (cell >= this.getCells()) continue;
                height = Math.max(height, this.getMinCellHeight(cell));
            }
            this.rowHeights[row] = height;
            if (row + 1 >= rowCount) continue;
            this.rowStartY[row + 1] = this.rowStartY[row] + height;
        }
    }

    @Override
    protected int getHeightForRow(int row) {
        if (row >= 0 && row < this.rowHeights.length) {
            return this.rowHeights[row];
        }
        return 0;
    }

    @Override
    protected int rowAtScreenY(int y) {
        return this.rowAtGridY(this.pixelsScrolledForScreenY(y));
    }

    @Override
    protected int rowAtY(int y) {
        return this.rowAtGridY(this.pixelsScrolledForY(y));
    }

    @Override
    protected int rowAtGridY(int y) {
        int row = Arrays.binarySearch(this.rowStartY, y);
        if (row < 0) {
            row = Math.max(0, -row - 2);
        }
        return row;
    }

    @Override
    protected int rowStartPixels(int row) {
        if (row >= 0) {
            if (row < this.rowStartY.length) {
                return this.rowStartY[row];
            }
            if (this.rowStartY.length > 0) {
                return this.rowStartY[this.rowStartY.length - 1];
            }
        }
        return 0;
    }
}

